<?php
/*******************************************************************************
 * local.php
 *******************************************************************************
 * file to customize localization. can be changed here, or in admin/localization
 * format is to be the following:
 * All loc vars start with loc_
 * btn_      : button
 * tab_vxx_y : tab (see below for view, y stands for tab #)
 * mxx_      : mod (xx stands for which module uses it)
 * vxx_      : view page (different than module)
 * info_mxx_ : info tooltip
 * inst_     : install (all install vars are in install/local.php)
 ******************************************************************************/
// viewpoints
$rt3loc_view=array(
'Main',
'Event',
'Account',
'Group',
'Login',
'Add Event',
'Admin'
);

// units of time
// if (sys_time) {
	define ('loc_u_min',"minutes");
	define ('loc_u_hr',"hours");
	define ('loc_u_day',"days");
	define ('loc_u_week',"weeks");
	define ('loc_u_month',"months");
	define ('loc_life',"lifetime");															// in statcount now
$rt3loc_unit_tabbv=array('s','m','h','d');
$rt3loc_unit_treg=array('second','minute','hour','day','week','month','lifetime');
$rt3loc_unit_tpl=array('seconds','minutes','hours','days','weeks','months');

//}
// if yes/no:
	define ('loc_yes',"Yes");
	define ('loc_yes',"No");
	$rt3loc_yn=array(1=>loc_yes,0=>loc_no);

// buttons
define ('loc_btn_submit',"Submit");
define ('loc_btn_reset',"Reset");
define ('loc_btn_login',"Log in");
define ('loc_btn_modify',"Modify");
define ('loc_btn_delete',"Delete");
define ('loc_btn_update',"Update numbers");
define ('loc_btn_addevent',"+");
define ('loc_btn_addsub',"+");
// days
$rt3loc_days=array("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday");	
// previous and next buttons
define ('loc_nav_prev',"Previous");
define ('loc_nav_next',"Next");

//------------------------------------- general use

//------------------------------------- DKP (to be in dkp.php)
define ('loc_dkp_name',"$rt3pref_dkp[name]");
//------------------------------------- tabs
// log in view
$rt3loc_tab_login=array(
	"Log in",
	"Forgot",
	"Register"
);
// account view
$rt3loc_tab_account=array(
	"Profile",
	"Characters",
	"Statistics",
	loc_dkp_name
);

// main
define ('loc_tab_vmn_1',"Calendar");
define ('loc_tab_vmn_2',"List");


// group
$rt3loc_tab_group=array(
	"Active Accounts",
	"Inactive Accounts",
	"All characters"
);

// for modules/sublist.php
	define ('loc_char_main',"Main");
	define ('loc_char_alt',"Alt");
	define ('loc_visualnote_mark',"*");
	define ('loc_plannote_mark',"p");
	define ('loc_btn_charswitch',"Switch");
	define ('loc_info_wb', "This list is NOT finalized. All with this whiteboard icon are not approved");
	define ('loc_btn_wb_approve',"Approve");
	define ('loc_btn_wb_clear',"Clear");
	define ('loc_head_slbatch',"Batch options");
	define ('loc_sl_f01',"Select also");
	define ('loc_sl_f02',"Move to");
	define ('loc_sl_f03',"Visual note");
	define ('loc_sl_f04',"Planning note");
	define ('loc_sl_i01',"Only those with a subscription will be affected. Selecting a role or class will not affect subscriptions status withdrawn or removed");
	define ('loc_sl_nomove',"Don't move");
	define ('loc_sl_delete',"Delete");

// for modules/character.php
	define('loc_yes',"Yes");
	define('loc_no',"No");
	define('loc_account',"Account");
	define('loc_character',"Character");
	define('loc_charname',loc_character . " name");
	define('loc_main',"Main");
	define('loc_class',"Class");
	define('loc_role',"Role");
	define('loc_level',"Level");
	define('loc_note',"Note");
	define('loc_delete',"Delete");
	define('loc_infocharnote',"Character notes are optional, and are displayed only
	on the account view.");

// for modules/eventsummary.php
$rt3loc_eventstatus=array(
"Open",
"Withdrawls only",
"Additions only",
"Frozen",
"Invites open",
"Started",
"Completed");
$rt3loc_eventtimeblk=array(
"Date","Start","End","Invite","End Subscription","End Withdrawl");
$rt3loc_event_btntime=array('Show all times','Edit times');
$rt3loc_event_btnedit="Change";
$rt3loc_eventtime_status="Status";
$rt3loc_eventtimedur="Duration";
$rt3loc_eventtimeearly="early";

define ('loc_eventsummary',"Summary");
define ('loc_eventfname',"Name of event:");
define ('loc_eventfloc',"Location:");
define ('loc_eventfeventid',"Event ID");
define ('loc_eventfminlevel',"Minimum Level");
define ('loc_eventeventidlink',"Link to event");
define ('loc_eventeventidsoon',"ID will be assigned once completed");
define ('loc_eventfnote',"Public Note:");
define ('loc_eventfplan',"Planning Note:");
define ('loc_eventfleader',"Leader");
define ('loc_eventleadernone',"No leader");
define ('loc_eventtimes',"Times");
define ('loc_eventtimedate',"Date");
define ('loc_eventtimestart',"Start");
define ('loc_eventtimeend',"End");
define ('loc_eventtimeinv',"Invite");
define ('loc_eventtimeesub',"End Subscription");
define ('loc_eventtimeewithdraw',"End Withdrawl");
define ('loc_eventtimein',"in");
define ('loc_eventtimeexpand',"See all times");
define ('loc_eventaddmsg',"Times may be altered later");
define ('loc_btn_eventchange',"Change");
define ('loc_btn_eventdelete',"Delete");


// for modules/eventcount.php
define ('loc_eventroleheader',"Roles");
define ('loc_eventtotal',"Total");
define ('loc_eventcount',"Counts");

// for modules/login.php
define ('loc_h1_login',"Log in or Register");
	define('loc_primary','Main');
	define('loc_charname','Character');
	define('loc_email','e-mail');
	define('loc_infoemailforgot','Please enter your e-mail address. If an admin reset
	your account, this will be the new address 
	on file for you. Otherwise, this is required to verify your account');
	define('loc_infonewpassword','New passwords must be at least 8 characters, including an uppercase letter,
	a lowercase letter, and a number.');
	define('loc_infocharacter','Enter any character that matches your account.');
	define('loc_infomaincharacter','For verification, you will need to enter the main character for the account');
	define('loc_password','Password');
	define('loc_old','Current');
	define('loc_reset','Reset/temporary');
	define('loc_new','New');
	define('loc_repeat','Repeat');
define ('loc_register_h2',"Character info");

// for views/account.php
	define ('loc_accthead',loc_account ." for");
	define ('loc_acct_settings',loc_account ." Settings");
	define ('loc_acctID',loc_account . " ID");
	// loc_primary
	define ('loc_acct_chars',"Characters");
	define ('loc_rank_group',"Guild Rank");
	define ('loc_rank_rt',"RaidTracker Rank");
	define ('loc_acct_status', loc_account . " Status");
	define ('loc_acct_active', "Active");
	define ('loc_acct_inactive', "Inactive");
	define ('loc_acct_loginsettings', "Log in settings");
	define ('loc_acct_resetpassword',"Reset password");
	define ('loc_acct_visual',"Visual Settings");
	define ('loc_acct_localadj',"Local Hour adjustment");
	define ('loc_acct_dateformat',"Date formatting");
	define ('loc_acct_timeformat',"Time formatting");
	define ('loc_acct_homeopen',"Home view opens to");
	define ('loc_acct_theme',"Theme");
	define ('loc_acct_addchar', "Add ".loc_character);
	define ('loc_acct_currchar', "Current ".loc_character);

	define ('loc_info_ac_local',"This number, will adjust in hours from RaidTracker time to your local time.");
	define ('loc_info_ac_datef',"This uses the PHP <a href=\"http://www.php.net/manual/en/function.date.php\">date</a> function to format date");
	define ('loc_info_ac_timef',"This uses the PHP <a href=\"http://www.php.net/manual/en/function.date.php\">date</a> function to format time");
	define ('loc_info_ac_home',"This is the first view you see as you open this site.");
	define ('loc_info_ac_theme',"This is the theme you can use to display this RaidTracker");
	define ('loc_info_ad_invites',"Players can be alerted if one is on the event list by a newsticker if selected");
	define ('loc_info_ad_time',"If invites are yes, this setting will not show a ticker until the time selected or when the list is approved, whichever is later.");

// for module/tos.php
	define ('loc_tos_header',"Terms of Service");
	define ('loc_tos_head1',"If you wish to alter or use the TOS for this site, use the space below");
	define ('loc_tos_head2',"Please read and scroll through the Terms of Service and choose your decision below");
	define ('loc_tos_foot2',"Do you agree to the terms above?");
	define ('loc_tos_foot1',"To accept changes and activate the TOS, choose Save. To not require the TOS, choose deactivate.");
	define ('loc_btn_tos_2a',"I agree");
	define ('loc_btn_tos_2b',"I don't agree");
	define ('loc_btn_tos_1a',"Save changes");
	define ('loc_btn_tos_1b',"Deactivate");

// for lib/corelib (infotip)
	define ('loc_moreinfotip',"More info");

// Tabs for admin
$rt3loc_tab_admin=array(
	"News",
	"TOS",
	"Display",
	"System",
	"Events",
	"Accounts",
	loc_dkp_name,
	"Permissions",
	"Rank names",
	"System names",
	"Character options",
	"Log"
	);
define ('loc_h1_adm',"Administration");

// for admin/1.php (news)
	define ('loc_adm_1_header', "Newstickers");
	define ('loc_adm_1_para',"You can have up to 3 newstickers at one time.");
	define ('loc_adm_1_th1',"Delete");
	define ('loc_adm_1_th2',"Headline");
	define ('loc_adm_1_th3',"Text");
	define ('loc_adm_1_th4',"Expires (date/time)");
	define ('loc_adm_1_th5',"Created by");
	define ('loc_adm_1_none',"None");
	define ('loc_adm_1_new',"New");
	define ('loc_adm_1_head_features',"Other features");
	define ('loc_adm_1_showticker',"Show Newstickers");
	define ('loc_adm_1_showmain',"Main View only");
	define ('loc_adm_1_showinvites',"Show invites as newstickers");
	define ('loc_adm_1_earliesttime',"Earliest time before invite");

// for admin/3.php (display
	define ('loc_theme',"Theme");
	define ('loc_settings',"Settings");
	define ('loc_date',"Date");
	define ('loc_name',"Name");
	define ('loc_time',"Time");
	define ('loc_view',"View");
	define ('loc_force',"Force");
	define ('loc_default',"Default");
	define ('loc_home',"Home");
	define ('loc_calendar',"Calendar");
	define ('loc_list',"List");
	define ('loc_day0',"Sunday");
	define ('loc_day1',"Monday");
	define ('loc_day2',"Tuesday");
	define ('loc_day3',"Wednesday");
	define ('loc_day4',"Thursday");
	define ('loc_day5',"Friday");
	define ('loc_day6',"Saturday");

	define ('loc_adm_3_themehead',loc_theme."s");
	define ('loc_adm_3_deftheme',loc_default." ".loc_theme);
	define ('loc_adm_3_forcetheme',loc_force ." ".loc_theme);
	define ('loc_adm_3_03',"Convert disabled input to text");
	define ('loc_adm_3_dthead',loc_date . " &amp; ".loc_time);
	define ('loc_format',"format");
	define ('loc_datef',loc_date . " ".loc_format);
	define ('loc_timef',loc_time . " ".loc_format);
	define ('loc_caldf1',loc_calendar ." date (week display)");
	define ('loc_caldf2',loc_calendar ." Period date (week display)");
	define ('loc_caldf3',loc_calendar ." date (month display)");
	define ('loc_caldf4',loc_calendar ." Period date (month display)");
	define ('loc_adm_3_sorthead',"Tracking &amp; Sorting");
	define ('loc_adm_3_sortby',"Sort Subscriptions by");
	define ('loc_adm_3_sort1',"Time");
	define ('loc_adm_3_sort2',loc_class . " and ". loc_name);
	define ('loc_adm_3_statby',"Count stats for ".loc_u_day);
	define ('loc_adm_3_homeview',loc_home . " ". loc_view);
	define ('loc_adm_3_defview',loc_default . " ". loc_view);
	define ('loc_adm_3_forceview',"Disable tab bar");
	define ('loc_adm_3_navbar',"Navigation bars");
	define ('loc_adm_3_calhead',loc_calendar . " settings");
	define ('loc_adm_3_calstyle',"Style of ".loc_calendar);
	define ('loc_adm_3_month',"Month");
	define ('loc_adm_3_startday',"Starting day of the week");
	define ('loc_daysback',loc_u_day . " back");
	define ('loc_adm_3_specialday',"Special days of the week");
	define ('loc_adm_3_listhead',loc_list . " settings");
	define ('loc_adm_3_eventpg',"Events per page");
	define ('loc_adm_3_eventhide',"Automatically hide");
	define ('loc_adm_3_ehide_0',"Nothing");
	define ('loc_adm_3_ehide_1',"Past events");
	define ('loc_adm_3_ehide_2',"Future events");
	// infotip:
	define ('loc_info_ad_3_force',"If selected, users will not be able to select their theme, and the \"?theme=\" will not work");
	define ('loc_info_ad_3_03',"Changes input boxes to plain text if a user cannot edit it. Some browsers attach ugly scroll bars in number/time input boxes. This can be turned off for appearances.");
	define ('loc_info_ad_3_date',"This uses the <a href=\"http://php.net/date\">PHP date</a> format on dates");
	define ('loc_info_ad_3_time',"This uses the <a href=\"http://php.net/date\">PHP date</a> format on times");
	define ('loc_info_ad_3_caldate1',"This uses the <a href=\"http://php.net/date\">PHP date</a> format on dates in calendar. This is used when not formatted by month. Unlike the previous setting, this is not a user pref.");
	define ('loc_info_ad_3_caldate2',"This uses the <a href=\"http://php.net/date\">PHP date</a> format on header period (start or end day) in calendar. Unlike the previous setting, this is not a user pref.");
	define ('loc_info_ad_3_caldate3',"This uses the <a href=\"http://php.net/date\">PHP date</a> format on dates in calendar when formatted for month. Unlike the previous setting, this is not a user pref.");
	define ('loc_info_ad_3_caldate4',"This uses the <a href=\"http://php.net/date\">PHP date</a> format on the month header when formatted by month in calendar. Unlike the previous setting, this is not a user pref.");
	define ('loc_info_ad_3_sort',"How subscriptions are shown in event subscription and ". loc_dkp_name ." tabs. If by time, this is by when subscription was first created, not modified or moved.");
	define ('loc_info_ad_3_track',"This is the default to count subscriptions in group view and account statistics view. This will not count future events unless lifetime is selected");
	define ('loc_info_ad_3_defview',"The first view that is set for new accounts and logged out users. ");
	define ('loc_info_ad_3_forceview',"If selected, this will override user preferences, and will remove the tab bar");
	define ('loc_info_ad_3_nav',"If selected, users can navigate past and future calendars or event lists.");
	define ('loc_info_ad_3_calstyle',"In calendar view, this will show either a month (if month is selected) or a period of weeks.");
	define ('loc_info_ad_3_calstart',"The calendar can be set to a fixed day by choosing a day, or dynamically by selecting a number of days back.<br />\n
	Month calendars will not work with a dynamic day back.");
	define ('loc_info_ad_3_calspecial',"Any days that are special weekly recurring events can have date highlighted by choosing special days");
	define ('loc_info_ad_3_eventnum',"Number of events shown per page");
	define ('loc_info_ad_3_eventhide',"This will allow you to hide certain events if any from the event view.");

// for admin/4.php
	define ('loc_group',"Group");
	define ('loc_adm_4_gshead',loc_group . " ".loc_settings);
	define ('loc_adm_4_gname',loc_group." ".loc_name);
	define ('loc_adm_4_sname',"Location ".loc_name);
	define ('loc_adm_4_slochead',"Server location");
	define ('loc_adm_4_domain',"Domain");
	define ('loc_adm_4_rtpath',"Path to RaidTracker");
	define ('loc_adm_4_cookie',"Cookie name");
	define ('loc_adm_4_linkhead',"Links");
	define ('loc_adm_4_linkintro',"You may provide 2 links to add to the top menu for your convenience. These may include links to your home site or another installation of RaidTracker");
	define ('loc_adm_4_namelink',"Name to link");
	define ('loc_adm_4_urllink',"URL to link");
	define ('loc_adm_4_maint',"Maintenance");
	define ('loc_adm_4_maintmode',loc_adm_4_maint ." mode");
	// for infotip
	define ('loc_info_ad_4_group',"Name of your ".loc_group.". This is shown in the title bar and main page.");
	define ('loc_info_ad_4_server',"Location where your ".loc_group." is located. This shows in the title bar.");
	define ('loc_info_ad_4_domain',"The domain name where RaidTracker is installed. Please include the protocol (http:// or https://)");
	define ('loc_info_ad_4_path',"The path where RaidTracker is installed from the domain root. Do not include the beginning or final /");
	define ('loc_info_ad_4_cookie',"Change this value to avoid conflicts with other RaidTracker installs on the same server. If changed, everyone will be logged out.");
	define ('loc_info_ad_4_urllink',"Please include the complete protocol (http:// or https://) ");
	define ('loc_info_ad_4_maint',"This should be set to No unless testing this RaidTracker extensively that requires no interaction with others.
	Only accounts with superadmin (top rank) will have access to RT when set to Yes. ");
	
// for admin/5.php
	define ('loc_event',"Event");
	define ('loc_sstatus_0',"Not subscribed");
	define ('loc_sstatus_1',"Event list");
	define ('loc_sstatus_2',"Subscribed");
	define ('loc_sstatus_3',"Reserved");
	define ('loc_sstatus_4',"Withdrawn");
	define ('loc_sstatus_5',"Removed");
	define ('loc_sstatus_w',"Whiteboard");

	define ('loc_tstatus_0',"Open");
	define ('loc_tstatus_1a',"End subscriptions");
	define ('loc_tstatus_1b',"End withdrawls");
	define ('loc_tstatus_2',"End changes");
	define ('loc_tstatus_3',"Invites open");
	define ('loc_tstatus_4',"Start");
	define ('loc_tstatus_5',"End");
	
	define ('loc_adm_5_h_1',"Sync with server");
	define ('loc_adm_5_h_2',loc_event." ".loc_settings);
	define ('loc_adm_5_h_3',loc_event." ".loc_default);
	define ('loc_adm_5_f_01',"Server offset");
	define ('loc_adm_5_f_02',loc_tstatus_1a ." and ". loc_tstatus_1b. " at same time");
	define ('loc_adm_5_f_03',"Hide irrelevant times");
	define ('loc_adm_5_f_04',"Relative times in ".loc_event." ".loc_view);
	define ('loc_adm_5_f_05',"Require minimum levels");
	define ('loc_adm_5_f_06',"Leader at creation");
	define ('loc_adm_5_f_07',"Minimum level");
	define ('loc_adm_5_f_08',loc_tstatus_4." ".loc_time);
	define ('loc_adm_5_f_09',loc_event." duration");
	define ('loc_adm_5_f_10',loc_tstatus_3." ".loc_time);
	define ('loc_adm_5_f_11',loc_tstatus_1a ." ".loc_time);
	define ('loc_adm_5_f_12',loc_tstatus_1b ." ".loc_time);

	define ('loc_adm_5_f1caption',loc_hour);
	define ('loc_adm_5_f3_maybe',"Auto");
	define ('loc_adm_5_f6_maybe',"Prompt");
	define ('loc_adm_5_tprior',"prior to start");
	
	define ('loc_info_ad_5_01',"This sets the primary time offset to sync RT to the server location. 
	(in case the server hosting RT and the primary location are incorrect.) The times in RT that are 
	stored are based on location, and not local time.<br />\n
	<strong>This should NOT be your local time unless you live in the same location as the primary location.</strong>
   Use your settings to adjust display times to local time.");
	define ('loc_info_ad_5_02',"The End withdrawl time will be replaced by the End subscription time in future events.");
	define ('loc_info_ad_5_03',"If active, times that have lapsed (apart from start and
	end times) are hidden by default. These times may be shown when someone presses 
	the 'Show All Events' button. If Relative times are shown, invite will not be
	shown as long as subscriptions aren't frozen.");
	define ('loc_info_ad_5_04',"This will convert invite and end subscription/
	withdrawl times into relative times like \"30m\". Any times expired will be 
	hidden. All times can be seen when someone presses \"Show all times\" button.");
	define ('loc_info_ad_5_05',"When selected, the Minimum level box is shown. This will not 
	allow new subscriptions or swapping with characters who do not meet the minimum. Will not affect older subscriptions.");
	define ('loc_info_ad_5_06',"Leaders will always be placed on event list and will have full modify 
	rights for this event. This will allow whoever creates an event to be the leader (or the option 
	to decline if set to prompt).");
	define ('loc_info_ad_5_07',"Used with require minimum setting above, will set a default level for new events created.");
	define ('loc_info_ad_5_08',"This is the default time assigned to all new events created. 
	Fill this time with <strong>your local time</strong>. RaidTracker will convert this to internal time.");
	define ('loc_info_ad_5_09',"Set this value to define future events to a specific duration. 
	If enabled, the end time is hidden at creation, but may be altered later on.");
	define ('loc_info_ad_5_10',"Set this value to define future events with an invite time prior 
	to the start of the event. If enabled, this will be automatically set at creation.");
	define ('loc_info_ad_5_11',"Set this value to define future events with a close window to subscribe 
	prior to the start of the event. If enabled, this will be automatically set at creation.");
	define ('loc_info_ad_5_12',"Set this value to define future events with a close window to withdraw 
	prior to the start of the event. If enabled, this will be automatically set at creation. 
	This value is ignored if End Subscriptions and withdrawls at the same time is enabled.");

// for admin/6.php
	define ('loc_adm_6_h_1',"Character defaults");
	define ('loc_adm_6_h_2',"Account defaults");
	
	define ('loc_adm_6_f_1',"Default level");
	define ('loc_adm_6_f_2',"Account Activation");
	define ('loc_adm_6_f_3',"Initial group settings");
	define ('loc_adm_6_f_4',"Initial RaidTracker privileges");
	define ('loc_adm_6_intro',"You may choose to share the account/character settings with multiple installations 
	of RaidTracker (version 3+), but each RT site needs to activate the account prior to use. To set database settings 
	for each table, select the System tab.");
	define ('loc_adm_6_2a',"Low: Creation or log in");
	define ('loc_adm_6_2b',"Med: Creation only");
	define ('loc_adm_6_2c',"High: Authorized users only");

	define ('loc_info_ad_6_1',"This prefills the level when new characters are created");
	define ('loc_info_ad_6_2',"This value determines how accounts are activated on this installation of RT, whether accounts are shared among other 
	installations or not. The higher the value, the more control you have over accounts that can access this RT copy.");
	define ('loc_info_ad_6_3',"The initial group level once an account is activated. Group rank in RT is purely cosmetical.");
	define ('loc_info_ad_6_4',"The initial privileges assigned to an account in this RaidTracker.");
$rt3loc_form['admin'][6]['h'][0]="Character Defaults";
$rt3loc_form['admin'][6]['h'][1]="Account Defaults";
$rt3loc_form['admin'][6]['h'][2]="Self options";
$rt3loc_form['admin'][6]['f'][0]="Starting level";
$rt3loc_form['admin'][6]['f'][1]="Account activation";
$rt3loc_form['admin'][6]['f'][2]="Initial group rank";
$rt3loc_form['admin'][6]['f'][3]="Initial RaidTracker level";
$rt3loc_form['admin'][6]['f'][4]="Add characters";
$rt3loc_form['admin'][6]['f'][5]="Edit characters";
$rt3loc_form['admin'][6]['f'][6]="Delete characters";
$rt3loc_form['admin'][6]['f'][7]="Change main character";
$rt3loc_form['admin'][6]['f'][8]="Change class";
$rt3loc_form['admin'][6]['f'][9]="Change character name";
$rt3loc_form['admin'][6]['f'][10]="Change character level";
$rt3loc_form['admin'][6]['f'][11]="Change character role";
$rt3loc_form['admin'][6]['f'][12]="Change character note";
$rt3loc_form['admin'][6]['o'][2][0]="Low: Creation or log in";
$rt3loc_form['admin'][6]['o'][2][1]="Medium: Creation only";
$rt3loc_form['admin'][6]['o'][2][2]="High: Approval required";
$rt3loc_form['admin'][6]['i'][0]="This is the prefilled value when a character is created";
$rt3loc_form['admin'][6]['i'][1]="This value determines how accounts are activated on this installation of RT, whether accounts are shared with other
installations or not. The higher the value, the more control you have over usage.";
$rt3loc_form['admin'][6]['i'][2]="This is the initial group rank when an account is activated or created. Group rank is purely cosmetical.";
$rt3loc_form['admin'][6]['i'][3]="This is the initial access privs when an account is activated and created. ";
$rt3loc_form['admin'][6]['i'][4]="Allows the player to add a character.";
$rt3loc_form['admin'][6]['i'][5]="Allows the player to edit characters. This is required";
$rt3loc_form['admin'][6]['i'][6]="Allows the player to delete characters (not the main character.)";
$rt3loc_form['admin'][6]['i'][7]="Allows the player to change the main character. Requires edit set above.";
$rt3loc_form['admin'][6]['p'][1]="You may choose to share the accounts with another installation of RaidTracker (3.00+). But accounts must be
activated individually on each installation of RaidTracker prior to use. These are the settings for this installation.";
$rt3loc_form['admin'][6]['p'][2]="The following settings are possible for individuals to do on their own characters without setting
privileges. These do not override privileges with regards to other account characters.";



// ----- for admin/8.php
	define ('loc_adm_8_h1',"Permissions");
	define ('loc_adm_8_head1',"Property");
	define ('loc_adm_8_head2',"Level");
	define ('loc_adm_8_cat',"Category");
	define ('loc_adm_8_none',"None");
	define ('loc_adm_8_all',"All");
	

// ------- for admin/local.php
	define ('loc_adm_h1_local',"RaidTracker Local settings");
	define ('loc_adm_h1_acct',"Account local settings");
	define ('loc_adm_h1_rank',"Rank settings");
	define ('loc_adm_p_local',"You may add, edit or delete locations here. You may only rename
	status names here. Please note that you must also add the icon in /images/(category)/(nickname).png for it to show");
	define ('loc_adm_p_acct',"You may add, edit or delete classes or roles here. Please note this affects all versions of RT using this list.
	Also note that you must also add the icon in /images/(category)/(nickname).png for it to show");
	define ('loc_adm_p_rank',"You may add, edit or delete rank names here. Guild ranks are shown everywhere. RT ranks affect the permissions, though
	these are ultimately set in permissions");
	define ('loc_adm_sn',"Nickname");
	define ('loc_adm_ln',"Name");
	define ('loc_adm_rankorder',"Order");
	define ('loc_adm_lbl_del',"Delete");
	define ('loc_adm_lbl_ins',"Add new");
	

//------------------ for view/group.php
	define ('loc_grp_h1',"Member list");
	define ('loc_grp_grank',"Group Rank");
	define ('loc_grp_rtrank',"RaidTracker Rank");
	define ('loc_tab_vgr_1',"Active accounts");
	define ('loc_tab_vgr_2',"Inactive accounts");
	define ('loc_tab_vgr_3',"Characters");
	define ('loc_grp_stats',"Statistics counting the last");
	define ('loc_grp_col_checkbox',"&nbsp;");
	define ('loc_grp_col_char',"Character");
	define ('loc_grp_col_main',"Main Character");
	define ('loc_grp_col_note',"Notes");
	define ('loc_grp_col_grank',loc_grp_grank);
	define ('loc_grp_col_rtrank',loc_grp_rtrank);
	define ('loc_grp_col_dkp',loc_dkp_name);
	define ('loc_btn_grp_activate',"Activate account");
	define ('loc_btn_grp_deactivate',"Deactivate account");
	define ('loc_btn_grp_delete',"Delete account");
	define ('loc_btn_grp_change',"Change");
	define ('loc_grp_h2',"Change ranks");
	define ('loc_grp_intro',"Change selected players to these ranks:");
	define ('loc_grp_nonefound',"No records found");
	define ('loc_grp_stathead',"Track stats for:");
	define ('loc_grp_statinfo',"Unless ".loc_life." is selected, this will include previous events where a subscription status is entered");
	define ('loc_grp_nochange',"No change");

//-------------------------- for mod/log.php
	$rt3loc_loghead=array(
		"Date/Time",
		"Account",
		"Category",
		"Code",
		"Reason"
	);
	$rt3loc_btn_log="Clear log";
//========================= for view/event.php
$rt3loc_tab_event=array(
	"Details",
	"Subscriptions",
	"Transactions",
	loc_dkp_name
);
//========================= for mod/suboptions.php
define ('loc_subopt_head',"Your Status");
$rt3loc_so_errmsg=array (
	'',      // leave 0 empty: not used
	'Account is inactive.',
	'Not logged in',
	'Cannot change subscriptions once event has started',
	'Event is now closed to subscriptions/modifications',
	'Cannot modify subscription status',
	'Cannot modify subscription status'
);

define ('loc_subopt_notlog',"You are not logged in");
define ('loc_subopt_notsub',"You are not subscribed");
define ('loc_subopt_subas',"You are subscribed as");
define ('loc_subopt_btn_quick',"OneClick Subscribe&trade;");
define ('loc_subopt_f01',"Status");
define ('loc_subopt_f02',"Character");
define ('loc_subopt_f03',"Role");
define ('loc_subopt_f04',"Visual note");
define ('loc_subopt_f05',"Planning note");
define ('loc_subopt_i01',"Your planner might have changed your subscription status if Event List or Removed is shown");
define ('loc_subopt_i02',"Character may be swapped if available, and admin allows it");
define ('loc_subopt_i03',"Roles cannot be changed without a planner's permission");
define ('loc_subopt_i04',"Used to communicate between you and the planners");
define ('loc_subopt_i05',"Used to communicate between planners. This cannot be changed here--only in the subscriptions tab");
define ('loc_subopt_btn_change',"Change");
define ('loc_subopt_btn_withdraw',"Withdraw");

//-------------------------- for view/main.php
$rt3loc_tab_main=array(
	"Calendar",
	"List"
);
define ('loc_main_head',"Welcome to ");
//-------------------------- for mod/eventtable.php
define ('loc_mod_et_col1',"Date");
define ('loc_mod_et_col2',"Time");
define ('loc_mod_et_col3',"Name");
define ('loc_mod_et_col4',"Sub");
define ('loc_mod_et_col5',"Status");
define ('loc_mod_et_col6',"Total");
define ('loc_mod_et_col7',"Character");
define ('loc_mod_et_col8',"Role");
define ('loc_mod_et_col9',"Notes");
define ('loc_mod_et_subbtn',"Subscribe");
define ('loc_mod_et_details',"Details");

//-------------------------- for view/account/1.php
define ('loc_acct_h2_reset',"Reset account");
define ('loc_acct_btn_reset',"Reset");
define ('loc_acct_info_reset',"Should be used as a last-minute resort only for a hacked account or an account that cannot be
changed normally. Click this button to reset the account. Once it is reset, the user needs to use the forget login setting
to get access to account again.");


//-------------------------- for view/account/3.php
define ('loc_view_acc_t3_h1',"Subscription counts");
define ('loc_view_acc_t3_h2',"Recent subscriptions");

//-------------------------- for mod/menu.php
define ('loc_menu_top_add',"Add Event");
define ('loc_menu_top_help',"Help");
define ('loc_menu_top_logout',"Log out");
define ('loc_menu_top_install',"Installation");
define ('loc_menu_top_login',"Log in or Register");
define ('loc_menu_top_forgot',"Forgot password");
define ('loc_menu_top_register',"New Account");
$rt3loc_menu_top_view=array(
	"Main",
	"Account",
	"Group",
	"Admin",
	"Log"
);
//-------------------------- for lib/rank.php
define ('loc_rank0',"No one");
define ('loc_rank1',"Everyone");
//-------------------------- for add.php
define ('loc_h1_add',"Add Event");
//-------------------------- for core/news.php
define ('loc_mainthead',"Maintenance");
define ('loc_mainttext',"RaidTracker has been placed in maintenance mode by an admin");
define ('loc_demohead',"Demo mode");
define ('loc_demotext',"RaidTracker is in demo mode. Changes will not be saved.");
define ('loc_installhead',"Install");
define ('loc_installtext',"RaidTracker is in installation mode.");

//-------------------------- error codes
$rt3loc_error=array (
	1=>"Subscription added",
	2=>"Subscription modified",
	3=>"Subscription not changed",
	4=>"Event created",
	5=>"Event deleted",
	6=>"Event modified",
	7=>"Event not changed",
	8=>"Subscription moved",
	9=>"Subscription deleted",
	10=>"Moved account/created subscription",
	11=>"Role changed",
	12=>"Character changed",
	13=>"Approved whiteboard",
	14=>"Cleared whiteboard",
	15=>"Mass deletion successful",
	16=>"Moved all to whiteboard",
	17=>"Mass subscriptions changed",
	18=>"Accounts activated",
	19=>"Accounts deactivated",
	20=>"Deleted account ",
	21=>"Ranks changed",
	22=>"Deleted character ",
	23=>"Main character is changed",
	24=>"Characters changed",
	25=>"Characters not changed",
	26=>"Character created",
	27=>"Settings changed",
	28=>"Account modified",
	29=>"Password / e-mail updated",
	30=>"Account is reset. Please instruct account owner of this",
	31=>"Privileges changed",
	32=>"Properties not changed",
	33=>"Property added",
	34=>"Properties deleted",
	35=>"Properties modified",
	36=>"News not changed",
	37=>"News deleted",
	38=>"News modified",
	39=>"Preferences updated",
	40=>"Terms of Service updated",
	41=>"Terms of Service deactivated",
	42=>"Logged out",
	43=>"Logged in",
	44=>"Password changed, and logged in",
	45=>"Account created, and logged in",
	46=>"TOS accepted.",
	1000=>"Success code outside range:",
	1001=>"Error code outside range:",
	1002=>"SQL returned an error with this query: ",
	1003=>"SQL did not update--error with this query: ",
	1004=>"SQL did not insert--error with this query: ",
	1005=>"Database could not be opened. Check your database parameters and db.php",
	1006=>"rt.php could not be edited, check the chmod settings on the /user dir",
	1007=>"tos.txt could not be opened. Check your chmod settings on the /user dir",
	1008=>"Cannot activate TOS when text is empty.",
	1009=>"Cookie invalid or older version. You are logged out.",
	1010=>"Account not found",
	1011=>"Account credentials not valid",
	1012=>"Account protected",
	1013=>"Password not valid",
	1014=>"Character already exists",
	1015=>"Account already exists with the e-mail supplied",
	1016=>"Character name or level missing.",
	1020=>"Inactive tab the same as active tab: ",
	1021=>"Inactive tab out of range: ",
	1022=>"Tab out of range: ",
	1023=>"Invalid start day parameter",
	1024=>"Cannot use days back in month mode",
	1025=>"Number of weeks cannot be negative",
	1026=>"Only one parameter defined: ",
	1027=>"No privileges to add event",
	1028=>"Cannot reset your account while RaidTracker is in maintenance. Try later",
	1029=>"Cannot create an account while RaidTracker is in maintenance. Try later.",
	1098=>"Unrecognized form parameters",
	1100=>"Not logged in to change subscription",
	1101=>"Cannot add: already subscribed",
	1102=>"Cannot add: No character given",
	1103=>"Cannot add: No status given",
	1104=>"Time has expired to add or change subscription",
	1105=>"Cannot add/change: Character ineligible to subscribe",
	1110=>"Account ineligible to add (level too low)",
	1111=>"Cannot move account status: account is leader",
	1112=>"Cannot switch characters: level is too low",
	1113=>"No characters selected for batch options",
	1114=>"Cannot select leader in batch move",
	1200=>"Account does not exist",
	1201=>"Cannot view own account if not logged in",
	1202=>"Account is not in local system",
	1203=>"Cannot delete main character",
	1204=>"Cannot make name blank",
	1205=>"Name is already in use",
	1206=>"Name is missing",
	1207=>"Cannot deactivate account: invalid rank",
	1208=>"No changes made",
	1210=>"Cannot delete self",
	1250=>"No accounts selected",
	1251=>"Cannot modify self here",
	1252=>"No rank change specified",
	1260=>"Password not changed: password does not match",
	1261=>"Password not changed: invalid password",
	1262=>"Password not changed: duplicate password",
	1263=>"Invalid e-mail address",
	1264=>"Password not valid. Requires minimum 8 characters, including a uppercase letter, a lowercase letter and a number",
	1300=>"Event does not exist",
	1301=>"Cannot add: New event missing date",
	1302=>"Cannot add: New event missing start time",
	1303=>"Cannot add: New event missing end time",
	1304=>"Cannot add: New event missing invite time",
	1305=>"Cannot add: New event missing close subscription time",
	1306=>"Cannot add: New event missing close withdrawl time",
	1307=>"Cannot add: New event has no name",
	1400=>"No changes to privileges",
	1401=>"Duplicate nickname",
	1402=>"A nickname and name are both required",
	1403=>"Cannot delete all keys",
	1404=>"Duplicate pointer of nickname not allowed. Key:",
	1405=>"Form returned a different total keys than what was in the database.",
	1406=>"Nickname or name cannot be blank",
	1410=>"News ticker line incomplete",
	1411=>"Ticker time expired: deleting",
	1500=>"You cannot view the log",
	1501=>"No entries in the log",
	1502=>"You have no access to the admin menu",
	1503=>"Invalid admin privs",
	1504=>"TOS not accepted... logging out."
	);
define ('loc_error_head_fatal',"Fatal Error");
define ('loc_error_body_fatal',"RaidTracker has encountered a fatal error. The message is given below.
You may return back to the main screen here:");
define ('loc_error_link_fatal',"Return to the main page");
define ('loc_error_name',"Error");
define ('loc_success',"Success!");
define ('loc_criterror',"RaidTracker has encountered an exception and cannot continue. The message is 
given below. Please inform the administrator of both the code and message.");
// define for maintenance
define ('loc_maint_head',"Maintenance mode");
define ('loc_maint_body',"RaidTracker has been placed in a maintenance mode by an administrator. Access
is temporarily closed for non-administrators for the time being. This includes registration and reset
accounts. Please check back later.");


?>