<?php
/*******************************************************************************
 * 1.php
 * -----------------------------------------------------------------------------
 * Calendar view
 * -----------------------------------------------------------------------------
 * 
 ******************************************************************************/
// ================================================	Includes
include RT_LC."calendar.php";
// ================================================	Variables
// *** set up calendar settings ************************************************
if (!$rt3pref_view['home']['n']) unset ($_GET);									// if navigation disabled, unset get vars.
// *** get current date ***
$rt3mod_cal_today=$rt3time->get_systs(); 										// gets today's date
// *** get start date ***
if (!$_GET['startdate']) {														// if start date isn't passed in
	$rt3mod_cal_start=$rt3mod_cal_today;										// use today's date
	$rt3mod_cal_sastoday=1;														// set start as today flag on
} else {
	$rt3mod_cal_start=strtotime($_GET['startdate']);							// takes start date from Y-m-d to unix
}
// *** get current week mode ***
if (!$_GET['week']) $rt3mod_cal_wk=$rt3pref_view['cal']['w'];
else $rt3mod_cal_wk=$_GET['week'];
// *** set permission ***
$rt3priv_add=rt3f_checkpriv('event','add');										// get privs for adding 	
$rt3priv_pn=rt3f_checkpriv('subscription','pn');								// get privs for adding 	
// *** set special days ***
$rt3mod_cal_sd=$rt3pref_view['cal']['sd'];
// *** set start day ***
if (!$rt3sys_startday) $rt3mod_cal_day=$rt3pref_view['cal']['s'];
else $rt3mod_cal_day=$rt3sys_startday;
// *** set format ***
if ($rt3mod_cal_wk>0) $rt3mod_cal_format=$rt3pref_format['date'][1];			// if week, use week format
else $rt3mod_cal_format=$rt3pref_format['date'][3];								// use month format
// *** create calendar *********************************************************
$rt3mod_cal=new rt3cl_calendar ($rt3mod_cal_start,$rt3mod_cal_wk, $rt3mod_cal_day);
$rt3mod_cal->setAdd($rt3priv_add);												// add event button
$rt3mod_cal->setFormat($rt3mod_cal_format);										// set format of days
if (is_array($rt3mod_cal_sd))
foreach ($rt3mod_cal_sd as $k=>$v) $rt3mod_cal->setSpecial($k);				// set special days
if (!$rt3mod_cal_sastoday) $rt3mod_cal->setToday($rt3mod_cal_today);			// set today if not already
// *** Calculate critical dates for nav and DB *********************************
if ($rt3mod_cal_wk==0) {														// if in month mode
	$rt3mod_cal_tf['b']=strtotime(date("Y-m-01",$rt3mod_cal_start));			// start date of cal
	$rt3mod_cal_tf['p']=strtotime("-1 month", $rt3mod_cal_tf['b']);				// previous month
	$rt3mod_cal_tf['n']=strtotime("+1 month", $rt3mod_cal_tf['b']);				// next month
	$rt3mod_cal_tf['e']=strtotime("-1 second", $rt3mod_cal_tf['n']);			// end date of cal
	$rt3mod_cal_head=date($rt3pref_format['date'][4],$rt3mod_cal_tf['b']);		// date format for cal
} else {
	$rt3mod_cal_tf['b']=$rt3mod_cal->getStart();								// start date of cal
	$rt3mod_cal_tf['p']=$rt3time->addtime(-($rt3mod_cal_wk*7),'d',$rt3mod_cal_tf['b']);// previous period
	$rt3mod_cal_tf['n']=$rt3time->addtime($rt3mod_cal_wk*7,'d',$rt3mod_cal_tf['b']);// next period
	$rt3mod_cal_tf['e']=strtotime("-1 second", $rt3mod_cal_tf['n']);				// end date of cal
	$rt3mod_cal_head=date($rt3pref_format['date'][2],$rt3mod_cal_tf['b']);		// date format for start day
	$rt3mod_cal_head.=" - ".date($rt3pref_format['date'][2],$rt3mod_cal_tf['e']); // and end day
}
// *** get events **************************************************************
$rt3mod_cal_tf['b']=$rt3time->get_DBtime($rt3time->loc2sys($rt3mod_cal_tf['b']));
$rt3mod_cal_tf['e']=$rt3time->get_DBtime($rt3time->loc2sys($rt3mod_cal_tf['e']));
$rt3mod_cal_elist=$rt3db_table[0]->select(db_event,'*',"ts>='$rt3mod_cal_tf[b]' AND ts<='$rt3mod_cal_tf[e]'","ORDER BY ts ASC");
//var_dump ($rt3mod_cal_elist); // test
// *** put events on calendar **************************************************
for ($i=0; $i<count ($rt3mod_cal_elist); $i++) {
	// *** calculate local time *************************************************
	$rt3mod_cal_event['time']=$rt3time->sys2loc(strtotime($rt3mod_cal_elist[$i]['ts']));
	// *** calculate status of event ********************************************
	$rt3mod_cal_etimes=rt3f_timeconvert($rt3mod_cal_elist[$i]);
	$rt3mod_cal_estatus=rt3f_eventstatus($rt3mod_cal_etimes);
	// *** get subscription status **********************************************
	if ($rt3user && $rt3user_status>0) {													// make sure user is active
		$rt3mod_cal_selfsub=rt3f_subscriptionlist($rt3mod_cal_elist[$i]['eid'],$rt3user); // must be logged in to see
		if (is_null($rt3mod_cal_selfsub)) $rt3mod_cal_substat=rt3f_status(0);
		else $rt3mod_cal_substat=rt3f_status($rt3mod_cal_selfsub[0]['status'],1);
	}
	// *** make base text *******************************************************
	$rt3mod_cal_base=rt3f_location($rt3mod_cal_elist[$i]['loc']);					// make icon
	$rt3mod_cal_base=rt3h_url($rt3mod_cal_base, "./?event=".$rt3mod_cal_elist[$i]['eid']); // url
	if ($rt3mod_cal_selfsub>0) $rt3mod_cal_base.=rt3f_status($rt3mod_cal_selfsub[0]['status'],0);
	// *** make tooltip text ****************************************************
	$rt3mod_cal_tooltip=null; // temp 
	// *** put status ***
	if ($rt3user && $rt3user_status>0){														// if user logged in and active
		if (is_null($rt3mod_cal_selfsub) ) {
			if ($rt3mod_cal_estatus[0]==0 || $rt3mod_cal_estatus[0]==2)
			$rt3mod_cal_tooltip=rt3h_div(rt3h_button('qsub['.$rt3mod_cal_elist[$i]['eid']."]",loc_mod_et_subbtn),'cstatus');
		} else 
		$rt3mod_cal_tooltip=rt3h_div($rt3mod_cal_substat,'cstatus');
	}
	$rt3mod_cal_tooltip.=rt3h_div($rt3loc_eventstatus[$rt3mod_cal_estatus[0]],'estatus');
	$rt3mod_cal_tooltip.=rt3h_div($rt3mod_cal_elist[$i]['name'],'eventname');			// name of event
	$rt3mod_cal_tooltip.=rt3h_div(loc_eventtimestart.": ".$rt3time->futime($rt3mod_cal_event['time']),"eventtime"); // event time
	if ($rt3mod_cal_event[$i]['vn'])															// visual note
		$rt3mod_cal_tooltip.=rt3h_div($rt3mod_cal_event[$i]['vn'],'eventnote');
	if ($rt3mod_cal_event[$i]['pn'] && $rt3priv_pn)										// plan note
		$rt3mod_cal_tooltip.=rt3h_div($rt3mod_cal_event[$i]['pn'],'eventnote officer');
	$rt3mod_cal_tooltip.=rt3h_div(rt3h_url(loc_mod_et_details,"./?event=".$rt3mod_cal_elist[$i]['eid']),'eventlink'); // link to event
	// *** make tooltip *********************************************************
	$rt3mod_cal_tt=rt3f_tooltip('',$rt3mod_cal_tooltip);
	$rt3mod_cal_base.=$rt3mod_cal_tt;
	// *** put up event on calendar *********************************************
	$rt3mod_cal->setEvent($rt3time->get_DBtime($rt3mod_cal_event['time']),$rt3mod_cal_base);
}
// *** generate calendar *******************************************************
$rt3mod_cal_page=rt3h_h(2,$rt3mod_cal_head);												// make heading
$rt3mod_cal_page.=$rt3mod_cal->html();														// get calendar html
// *** generate navigation bars ************************************************
if ($rt3pref_view['home']['n']) {															// navigation is on
	$rt3mod_cal_link="?view=main&amp;tab=1&amp;week=$rt3mod_cal_wk&amp;startdate=";
	$rt3mod_cal_lk=rt3h_url(loc_nav_prev,$rt3mod_cal_link.date("Y-m-d",$rt3mod_cal_tf['p']));
	$rt3mod_cal_lk.= " | ";
	$rt3mod_cal_lk.=rt3h_url(loc_nav_next,$rt3mod_cal_link.date("Y-m-d",$rt3mod_cal_tf['n']));
	$rt3mod_cal_page.=rt3h_div($rt3mod_cal_lk,"navlink");
}
$rt3sys_page['main']=rt3f_forms($rt3mod_cal_page);
?>