<?php
/*******************************************************************************
 * event.php
 * -----------------------------------------------------------------------------
 * how to manipulate the event view.
 ******************************************************************************/
// *** setup for menu/title/help etc. ******************************************
$rt3sys_viewname=$rt3loc_view[1];															// sets up view name from local
$rt3sys_helppage=$rt3sys_tab+9;																// sets up help file to point to r.d.c/help
// *** get permissions *********************************************************
$rt3priv_e=rt3f_checkpriv('event');
$rt3priv_s=rt3f_checkpriv('subscription');
$rt3priv_d=rt3f_checkpriv('points','view');
// *** get event info from DB **************************************************
$rt3sys_eventinfo=$rt3db_table[0]->selectrec(db_event,'*',"eid=$rt3sys_event"); // get event info
if (is_null($rt3sys_eventinfo)) { 												// Event does not exist: error
	rt3f_fatalerror(1300);
	return;
}
// *** set leader privs ********************************************************
if ($rt3sys_eventinfo['leader']) {												// if there is a leader
	if ($rt3sys_eventinfo['leader']==$rt3user) {								// if leader is logged in user
		foreach ($rt3priv_e as &$v) $v=1;										// set event privs to true
		foreach ($rt3priv_s as $k=>&$v){										// go thru subscription privs
			if ($k!='delete') $v=1;												// set sub privs to true except delete
		}
	} elseif ($rt3priv_e['leader']==0) {										// if logged in does NOT have override privs
		$rt3priv_e['edit']=0;													// set event edit priv off
		$rt3priv_e['time']=0;													// set event override time priv off
		$rt3priv_e['log']=0;													// set event view log priv off
		$rt3priv_e['s5']=0;														// set event restricted priv off
		$rt3priv_e['wb']=0;														// set event whiteboard priv off
		$rt3priv_s['edit']=0;													// set sub edit priv off
		$rt3priv_s['add']=0;													// set sub add priv off
	}
}
// *** set privs right *********************************************************
if ($rt3priv_s['edit']==0) {													// no edit privs
	$rt3priv_s['add']=0;
	$rt3priv_s['delete']=0;
	$rt3priv_s['move']=0;
	$rt3priv_s['character']=0;
	$rt3priv_s['swap']=0;
	$rt3priv_s['role']=0;
}
for ($i=1; $i<6; $i++) 															// scroll thru privs
	if ($rt3priv_e["s$i"]==0 || $rt3priv_s['move']==0) $rt3priv_s["s$i"]=0;		// if column is not visible or move is off, disable move to col button
if ($rt3priv_e["wb"]==0 || $rt3priv_s['move']==0) $rt3priv_s["wb"]=0;			// if wb column is not visible or move is off, disable move to wb button
if ($rt3priv_s['wb']==0) {														// if move to WB is disabled, disable WB controls
	$rt3priv_s['wbapprove']=0;
	$rt3priv_s['wbclear']=0;
}
//------------------------ testing subscription list
$rt3mod_sublist=rt3f_subscriptionlist($rt3sys_event);									// to tab 2 and 4? and 1 for leader
// to tab 2?
$rt3mod_subnot=$rt3db_table[0]->select(
 db_acct.", ".db_char.", ".db_accts,
 db_char.".*",
 db_acct.".main=".db_char.".cid AND ".db_acct.".aid=".db_accts.".aid AND " .db_accts.".active=1 AND ".db_acct.".aid NOT IN (SELECT aid FROM ".db_sub." WHERE eid=$rt3sys_event)",
 "ORDER BY UCASE(`name`)");
for ($i=0; $i<count ($rt3mod_subnot); $i++) 														// generate class/name icons
	$rt3mod_subnot[$i]['fullname']=rt3f_classname($rt3mod_subnot[$i]['class'], $rt3mod_subnot[$i]['name']);



/*
SELECT 
	ts_character.* 
	FROM ts_character, ts_account, tl_locset 
	WHERE ts_account.main=ts_character.cid AND ts_account.aid=tl_locset.aid AND tl_locset.active=1 AND ts_account.aid NOT IN (SELECT aid FROM tl_sub WHERE eid=5)
*/
// ---------------------- event heading. THIS is temporary till date/name is fixed
$rt3mod_eventheaddate=date('l F j, Y',strtotime($rt3sys_eventinfo['ts']));
$rt3sys_page['heading']="$rt3mod_eventheaddate ".rt3f_location($rt3sys_eventinfo['loc'])." ".$rt3sys_eventinfo['name'];
//$rt3sys_page['heading']="Event. (temp)";

// ---------------------- make tabs
if (!($rt3priv_d && $rt3pref_dkp['active']))	$rt3mod_tabin[]=4;					// no dkp view or not active
if (!$rt3priv_e['log']) $rt3mod_tabin[]=3;												// no view log	
rt3f_tabs('event',$rt3mod_tab,$rt3mod_tabin,$rt3sys_event);
// ---------------------- go to the tab
if ($rt3sys_tab<4) include RT_LV."event/$rt3sys_tab.php";

?>