<?php
/*******************************************************************************
 * 5.php
 * -----------------------------------------------------------------------------
 * the event tab
 ******************************************************************************/
// functions needed for this
function rt3f_select($name, $q, $choice, $def=null, $info=null) {
	$rt3l_field=rt3h_select($name,$choice,null,$def);
	if ($info) $rt3l_field.=rt3f_infotip($info);
	return rt3h_formline($q,$rt3l_field);
}
function rt3f_radio($name, $q, $choice, $def=null, $info=null) {
	foreach ($choice as $k=>$v) {
		$rt3l_field.=rt3h_radio($name, $k, $v,($def==$k?1:0))." ";
	}
	if ($info) $rt3l_field.=rt3f_infotip($info);
	return rt3h_formline($q,$rt3l_field);
}
function rt3f_text($name, $q, $def=null, $info=null) {
	$rt3l_field=rt3h_text($name,$def);
	if ($info) $rt3l_field.=rt3f_infotip($info);
	return rt3h_formline($q,$rt3l_field);
}
function rt3f_time($name, $q, $def=null, $info=null) {
	$rt3l_field=rt3h_time($name,$def);
	if ($info) $rt3l_field.=rt3f_infotip($info);
	return rt3h_formline($q,$rt3l_field);
}
function rt3f_number($name, $q, $def=null, $info=null, $min=null,$max=null, $step=null) {
	$rt3l_field=rt3h_number($name,$def,null,$min, $max, $step);
	if ($info) $rt3l_field.=rt3f_infotip($info);
	return rt3h_formline($q,$rt3l_field);
}
function rt3f_timedrop($name, $q, $def=null, $info=null, $capt=true) {
	$rt3l_timearr=array('m'=>loc_u_min, 'h'=>loc_u_hr); // set up drop box
	if (!is_null($def)) {
		$rt3l_tm=$def/60;
		$rt3l_unit='m';
		if ((int)($rt3l_tm/60)===($rt3l_tm/60)) {
			$rt3l_unit='h';
			$rt3l_tm/=60;
		}
	} else {
		$rt3l_tm=$def;
	}
	$rt3l_field=rt3h_number($name.'[val]', $rt3l_tm,null,0)." ";
	$rt3l_field.=rt3h_select($name.'[unit]',$rt3l_timearr,null,$rt3l_unit)." ";
	if ($capt) $rt3l_field .=loc_adm_5_tprior." ";
	if ($info) $rt3l_field.=rt3f_infotip($info);
	return rt3h_formline($q,$rt3l_field);
}

// for the yes/no option
$rt3l_yn=array(1=>loc_yes,0=>loc_no);

// page 5: events
// header for sync server
$rt3mod_page.=rt3h_h(2,loc_adm_5_h_1);
// 01 server offset
// number events per page. uses number
	$rt3l_field=rt3h_number('pref[event][offset]',$rt3pref_event['offset'],null,-24,24).loc_u_hr." ";
	$rt3l_field.=rt3f_infotip(loc_info_ad_5_01);
	$rt3mod_page.= rt3h_formline(loc_adm_5_f_01,$rt3l_field);

// header for event settings
$rt3mod_page.=rt3h_h(2,loc_adm_5_h_2);
// 02 end both. uses radio
$rt3mod_page.=rt3f_radio('pref[event][close]',loc_adm_5_f_02,$rt3l_yn,$rt3pref_event['close'],loc_info_ad_5_02);
// 03 irrelevant. uses radio
$rt3mod_page.=rt3f_radio('pref[event][collapse]',loc_adm_5_f_03,$rt3l_yn,$rt3pref_event['collapse'],loc_info_ad_5_03);
// 04 relative times. uses radio
$rt3mod_page.=rt3f_radio('pref[event][relative]',loc_adm_5_f_04,$rt3l_yn,$rt3pref_event['relative'],loc_info_ad_5_04);
// 05 require minimum. uses radio
$rt3mod_page.=rt3f_radio('pref[event][min][r]',loc_adm_5_f_05,$rt3l_yn,$rt3pref_event['min']['r'],loc_info_ad_5_05);
// 06 leader. uses radio
$rt3l_ynm=$rt3l_yn;
$rt3l_ynm[2]=loc_adm_5_f6_maybe;
$rt3mod_page.=rt3f_radio('pref[event][leader]',loc_adm_5_f_06,$rt3l_ynm,$rt3pref_event['leader'],loc_info_ad_5_06);
// header for event defaults
$rt3mod_page.=rt3h_h(2,loc_adm_5_h_3);
// 07 minimum level. uses number
$rt3mod_page.=rt3f_number('pref[event][min][l]',loc_adm_5_f_07,$rt3pref_event['min']['l'], loc_info_ad_5_07);
// 08 start time. uses time
if ($rt3pref_event['start']) {
$rt3l_st=strtotime(date('Y-m-d').$rt3pref_event['start']);						// Add today's date and convert to unix
$rt3l_st=$rt3time->sys2loc($rt3l_st);											// convert to local time
$rt3pref_event['start']=date("H:i",$rt3l_st);									// convert back to HH:mm format for dialog box
}
$rt3mod_page.=rt3f_time('pref[event][start]',loc_adm_5_f_08,$rt3pref_event['start'], loc_info_ad_5_08);
// 09 duration.
$rt3mod_page.=rt3f_timedrop('pref[event][dur]',loc_adm_5_f_09,$rt3pref_event['dur'],loc_info_ad_5_09,0);
// 10 invite.
$rt3mod_page.=rt3f_timedrop('pref[event][invite]',loc_adm_5_f_10,$rt3pref_event['invite'],loc_info_ad_5_10);
// 11 end additions.
$rt3mod_page.=rt3f_timedrop('pref[event][sub]',loc_adm_5_f_11,$rt3pref_event['sub'],loc_info_ad_5_11);
// 12 end withdrawls.
$rt3mod_page.=rt3f_timedrop('pref[event][with]',loc_adm_5_f_12,$rt3pref_event['with'],loc_info_ad_5_12);
// button
$rt3mod_page.=rt3h_formline(null,rt3h_button('submit',loc_btn_submit));
$rt3sys_page['main']=rt3f_forms($rt3mod_page);
?>