<?php
/*******************************************************************************
 * account.php
 * -----------------------------------------------------------------------------
 * how to manipulate the account page tabs.
 ******************************************************************************/
// *** for the menu/title ******************************************************
$rt3sys_viewname=$rt3loc_view[2];															// sets up view name from local
$rt3sys_helppage=$rt3sys_tab+14;																// sets up help file to point to r.d.c/help
// *** Check for account and if logged in **************************************
if ($rt3sys_account==0) {																		// no account ID passed in
	if (!$rt3user) {																				// and not logged in. fail
		rt3f_fatalerror(1201);
		return;
	}
	$rt3sys_account=$rt3user;																	// set account ID to logged in user
}

// *** get permissions (in general) ********************************************
$rt3priv_a=rt3f_checkpriv('account');
// *** check proper permissions for viewing this account ***********************
if ($rt3sys_account==$rt3user) {																// account is self?
	$rt3mod_acctinfo=$rt3user_info;															// skip DB: get acct info
	$rt3priv_a['reset']=0;																		// turn off reset
	$rt3priv_a['gedit']=0;																		// turn off change guild edit
	$rt3priv_a['gview']=1;																		// turn ON view guild rank
	$rt3priv_a['rtedit']=0;																		// turn off change RT rank
	$rt3priv_a['stats']=1;																		// turn ON stats
	$rt3priv_a['email']=1;																		// turn ON self change e-mail
	$rt3priv_a['delete']=0;																		// turn off delete
	$rt3priv_a['inactive']=-1;																	// turn on inactive (to view only)
	$rt3priv_a['dkp']=$rt3pref_dkp['active'];												// turn off DKP if not active
	foreach ($rt3pref_acct['self'] as $k=>$v)
		$rt3priv_a[$k]=$v;

	
	// add checks for add/class/edit/level/main/name/remove/role
	$rt3priv_a['reset']=0;																		// turn off reset
} else {																								// not same account
// *** check if account exists *************************************************
	if (is_null($rt3db_table[0]->selectrec(db_accts,'*',"aid=$rt3sys_account"))){   // if not found in local table
		if (is_null($rt3db_table[1]->selectrec(db_acct,'*',"aid=$rt3sys_account")))  // if account is not found period
			rt3f_fatalerror(1200);																// account not found error
		else	
			rt3f_fatalerror(1202);																// account not logged in yet. Check needs to be first for local settings
		return;
	}
	$rt3mod_acctinfo=rt3f_masterlist($rt3sys_account);									// get account from DB
	$rt3priv_a['email']=0;																		// turn off self change e-mail
	$rt3priv_a['dkp']=rt3f_checkpriv('points','view') && $rt3pref_dkp['active']; // turns on DKP based on priv AND if DKP is active
	if (!$rt3priv_a['edit']) {																	// no edit privs, set next privs off
		$rt3priv_a['add']=0;																		// turn Off add rights
		$rt3priv_a['class']=0;																	// turn Off class
		$rt3priv_a['level']=0;																	// turn Off level
		$rt3priv_a['main']=0;																	// turn Off switch main
		$rt3priv_a['name']=0;																	// turn Off rename character
		$rt3priv_a['remove']=0;																	// turn Off remove character
		$rt3priv_a['role']=0;																	// turn Off role
		$rt3priv_a['gedit']=0;																	// turn Off edit group rank
		$rt3priv_a['rtedit']=0;																	// turn Off edit RT rank
		$rt3priv_a['reset']=0;																	// turn Off reset account
		if ($rt3priv_a['inactive']) $rt3priv_a['inactive']=-1;						// if inactive is set, set read only
	}
}
// *** Get character info from DB **********************************************
$rt3mod_acctchar=rt3f_charlist($rt3sys_account);										// get characters from DB
// *** Generate header for page ************************************************
$rt3sys_page['heading']=loc_accthead." ".$rt3mod_acctinfo['fullname'];
// *** Generate tabs ***********************************************************
if (!$rt3priv_a['dkp']) $rt3mod_tabin[]=4;
if (!$rt3priv_a['stats']) $rt3mod_tabin[]=3;
rt3f_tabs('account',$rt3sys_tab,$rt3mod_tabin,$rt3sys_account);
// ---------------------- go to the tab
if ($rt3sys_tab<4) include RT_LV."account/$rt3sys_tab.php";
return;

// *** everything below this is trash ******************************************

// need to set permissions

// set sample data
// flags to determine if active or not
$rt3sys_admin=1; // admin

// min ranks if you can edit. based on your rank. (for tab 1)
$rt3sys_minrank['g']=1;
$rt3sys_minrank['r']=1;

// privs
$rt3sys_priv['char']['add']=1;    // add characters
$rt3sys_priv['char']['edit']=1;   // edit characters
$rt3sys_priv['char']['delete']=0; // delete characters

$rt3sys_priv['char']['main']=0;   // change main character
$rt3sys_priv['char']['name']=1;   // alter name
$rt3sys_priv['char']['role']=1;   // alter role
$rt3sys_priv['char']['level']=1;  // alter level
$rt3sys_priv['char']['class']=1;  // alter class
$rt3sys_priv['char']['notes']=1;  // alter note

// these settings are -1 to see only, 1 to edit, 0 none
$rt3sys_priv['rank']=-1;           // change guild/group rank
$rt3sys_priv['rtrank']=-1;         // change RT rank
$rt3sys_priv['active']=1;         // make account active/deactive

// Other variables
// *** delete next line? *******************************************************
$rt3mod_acct=null; // null if current, id# 
//-------------------------------------------------------	CODE
// *** Get Char info from DB ***************************************************
//$rt3mod_acctchar=rt3f_charlist($rt3sys_account);										// get characters from DB
// *** Generate header for page ************************************************
$rt3sys_page['heading']=loc_accthead." ".$rt3mod_acctinfo['fullname'];
// *** Generate tabs ***********************************************************
if (!$rt3priv_a['dkp']) $rt3mod_tabin[]=4;
if (!$rt3priv_a['stats']) $rt3mod_tabin[]=3;
rt3f_tabs('account',$rt3sys_tab,$rt3mod_tabin,$rt3sys_account);
// ---------------------- go to the tab
if ($rt3sys_tab<4) include RT_LV."account/$rt3sys_tab.php";

?>