<?php
/*******************************************************************************
 * suboptions.php
 * -----------------------------------------------------------------------------
 * module that shows event summary for add/modify for the current user
 * -----------------------------------------------------------------------------
 * Passed in variables
 * rt3sys_acctsub			array	subscription for account
 *	rt3sys_eventtime		array	times (RT time) of event
 *	rt3priv_event			array	privs for event (override only, status sub)
 *	rt3pref_disp			array	(close at same time only)
 * rt3sys_time				class system time
 * -----------------------------------------------------------------------------
 * output: rt3sys_page['subscribe']
 * does not provide a button or form. That is to the calling sub
 ******************************************************************************/
//================================================ VARIABLES
$rt3mod_so_override=rt3f_checkpriv('event','time');  							// override possible
$rt3mod_so_charalt=rt3f_checkpriv('event','character');							// Sign up with alt characters
$rt3mod_so_pn=rt3f_checkpriv('subscription','pn');								// check for planning note
//==============================================	CODE =======================
// *** to get the subscription status of event *********************************
$rt3mod_so_times=rt3f_timeconvert($rt3sys_eventinfo);
$rt3mod_so_statusinfo=rt3f_eventstatus($rt3mod_so_times);
$rt3mod_so_status=$rt3mod_so_statusinfo[0];
$rt3mod_so_time=$rt3mod_so_statusinfo[1];
// *** to get subscription status of the user **********************************
if ($rt3user){																	// don't waste time if not logged in
	$rt3mod_so_sub1=rt3f_subscriptionlist($rt3sys_event, $rt3user);	
	$rt3mod_so_sub=$rt3mod_so_sub1[0];
// *** to get character list of player eligible ********************************
	$rt3mod_so_char=rt3f_charlist($rt3user,($rt3pref_event['min']['r']?$rt3sys_eventinfo['level']:0));  // also check if flag is set for min levels
}
// *** to figure out subscription and allocation to subscribe ******************
if ($rt3user_status<1)  { 														// not logged in, or inactive
	if ($rt3user_status==-1) $rt3mod_so_formerr=1;								// 1: inactive
	else $rt3mod_so_formerr=2;													// 2: not logged in
} else if ($rt3mod_so_status>4) $rt3mod_so_formerr=3;							// 3: Event has started error
else if ($rt3mod_so_sub['status']==5) $rt3mod_so_formerr=5;					// 5: Removed: cannot subscribe
else if ($rt3mod_so_sub['status']==1) $rt3mod_so_formerr=6;					// 6: On event list: cannot modify
else if ($rt3mod_so_status==3 && !$rt3mod_so_override) $rt3mod_so_formerr=4;	// 4: event closed to subscription
else $rt3mod_so_formerr=0;														// 0: form open (check for add/withdraw later)
// *** Generate header and form ************************************************
$rt3mod_so_form=rt3h_h(2,loc_subopt_head);												// create header
// *** if logged in, process this form *****************************************
if ($rt3mod_so_formerr==0 || $rt3mod_so_formerr>2) {									// can show sub status if logged in/active
// *** subscribed or not? ******************************************************
	if (is_null($rt3mod_so_sub)) {															// not subscribed
		$rt3l_field=loc_subopt_notsub;
		if ($rt3mod_so_status==0 || $rt3mod_so_status==2)								// stil time to subscribe
			$rt3l_field.=" ".rt3h_button('quick',loc_subopt_btn_quick);				// add One-Click subscribe :) 
	} else {
		$rt3l_field=loc_subopt_subas." ";
	}	
	$rt3mod_so_form.=rt3h_formline(null, $rt3l_field);
// *** rest of form only if subscribed or able to subscribe ********************
	if (!is_null($rt3mod_so_sub) || $rt3mod_so_status<3){								
// *** status here *************************************************************
		if ($rt3mod_so_formerr) {
			$rt3mod_so_parm['data']=rt3f_status($rt3mod_so_sub['status'],1);
			$rt3mod_so_parm['type']='none';
		} else {
			$rt3l_stat=($rt3mod_so_sub['status']) % 10;
			for ($i=2; $i<5 ; $i++) {
				$rt3l_stlist[$i]=rt3f_status($i,1);
				if ($i>3 && $rt3mod_so_status==1) $rt3mod_so_parm['disabled'][$i]=1;
				if ($i<4 && $rt3mod_so_status==2) $rt3mod_so_parm['disabled'][$i]=1;
				if ($i==$rt3l_stat) $rt3mod_so_parm['selected']=$i;
			}
			$rt3mod_so_parm['data']=$rt3l_stlist;
			$rt3mod_so_parm['type']='radio';
		}
		$rt3mod_so_parm['name']='eventsub[status]';
		$rt3mod_so_parm['field']=loc_subopt_f01;
		//$rt3mod_so_parm['class']='long';
		$rt3mod_so_parm['info']=loc_subopt_i01;
		//$rt3mod_so_parm['dis']=($rt3mod_so_formerr?1:0);
		$rt3mod_so_form.=rt3h_inpline($rt3mod_so_parm);
		unset($rt3mod_so_parm['disabled']);
		unset($rt3mod_so_parm['selected']);
		unset($rt3mod_so_parm['data']);
// *** character here **********************************************************
		// making list here
		for ($i=0; $i<count ($rt3mod_so_char); $i++) {
			$rt3l_cid=$rt3mod_so_char[$i]['cid'];
			$rt3l_clist[$rt3l_cid]=$rt3mod_so_char[$i]['fullname'];
			if (!$rt3mod_so_charalt || $rt3mod_so_formerr) $rt3mod_so_parm['disabled'][$rt3l_cid]=1;
			if ($rt3l_cid==$rt3mod_so_sub['cid']) $rt3mod_so_parm['selected']=$rt3l_cid;
		}
		$rt3mod_so_parm['name']='eventsub[cid]';
		$rt3mod_so_parm['field']=loc_subopt_f02;
		$rt3mod_so_parm['data']=$rt3l_clist;
		$rt3mod_so_parm['type']='radio';
		//$rt3mod_so_parm['class']='long';
		$rt3mod_so_parm['info']=loc_subopt_i02;
		//$rt3mod_so_parm['dis']=($rt3mod_so_formerr?1:0);
		$rt3mod_so_form.=rt3h_inpline($rt3mod_so_parm);
		unset($rt3mod_so_parm['disabled']);
		unset($rt3mod_so_parm['selected']);
		unset($rt3mod_so_parm['data']);
// *** Role here **********************************************************
		// So far no swap. if used later, uncomment need to include no swap privs here
		$rt3mod_so_parm['name']='eventsub[role]';
		$rt3mod_so_parm['field']=loc_subopt_f03;
		$rt3mod_so_parm['data']=rt3f_role($rt3mod_so_sub['role'],1);
		$rt3mod_so_parm['type']='none';
		//$rt3mod_so_parm['class']='long';
		$rt3mod_so_parm['info']=loc_subopt_i03;
		//$rt3mod_so_parm['dis']=($rt3mod_so_formerr?1:0);
		$rt3mod_so_form.=rt3h_inpline($rt3mod_so_parm);
		unset($rt3mod_so_parm['dis']);
		unset($rt3mod_so_parm['class']);
		unset($rt3mod_so_parm['type']);
// *** visual note here ********************************************************
		$rt3mod_so_parm['name']='eventsub[vn]';
		$rt3mod_so_parm['field']=loc_subopt_f04;
		$rt3mod_so_parm['data']=$rt3mod_so_sub['vn'];
		$rt3mod_so_parm['type']='text';
		$rt3mod_so_parm['class']='long';
		$rt3mod_so_parm['info']=loc_subopt_i04;
		$rt3mod_so_parm['dis']=($rt3mod_so_formerr?1:0);
		$rt3mod_so_form.=rt3h_inpline($rt3mod_so_parm);
		unset($rt3mod_so_parm['dis']);
		unset($rt3mod_so_parm['class']);
		unset($rt3mod_so_parm['type']);
// *** plan note here ********************************************************
		if ($rt3mod_so_pn) {
			$rt3mod_so_parm['name']='eventsub[pn]';
			$rt3mod_so_parm['field']=loc_subopt_f05;
			$rt3mod_so_parm['data']=$rt3mod_so_sub['pn'];
			$rt3mod_so_parm['type']='text';
			$rt3mod_so_parm['class']='long';
			$rt3mod_so_parm['info']=loc_subopt_i05;
			$rt3mod_so_parm['dis']=1; // always disable this
			$rt3mod_so_form.=rt3h_inpline($rt3mod_so_parm);
			unset($rt3mod_so_parm['dis']);
			unset($rt3mod_so_parm['class']);
			unset($rt3mod_so_parm['type']);
		}
	}
}
if ($rt3mod_so_formerr) {
	$rt3mod_so_form.=rt3h_formline(null,$rt3loc_so_errmsg[$rt3mod_so_formerr]);
} else {
	$rt3mod_so_form.=rt3h_formline(null,rt3h_button('eventsub[change]',loc_subopt_btn_change));
}
?>