<?php
/*******************************************************************************
 * sublist.php
 * -----------------------------------------------------------------------------
 * module that shows event summary for add/modify
 * -----------------------------------------------------------------------------
 * Passed in variables
 * rt3sys_acctsub			array	subscription for account
 *	rt3sys_eventtime		array	times (RT time) of event
 *	rt3priv_event			array	privs for event (override only, status sub)
 *	rt3pref_disp			array	(close at same time only)
 * rt3sys_time				class system time
 * -----------------------------------------------------------------------------
 * output: rt3sys_page['subscribe']
 * does not provide a button or form. That is to the calling sub
 ******************************************************************************/
// ****************************************************** VARIABLES ************
$rt3mod_sl_eid=$rt3sys_event;													// event id
$rt3mod_sl_view=$rt3sys_event_status;											// get privs to see list status
$rt3mod_sl_priv=$rt3sys_event_priv;												// get privs to alter list
// ******************************************************* FUNCTIONS ***********
// create group with tooltip for each group
function rt3f_slgroup ($list, $per, $level=0) {
	foreach ($list as $k=>$list2) {
		if (!is_null ($list2)) {
			foreach ($list2 as $v) {
				$nam=$v['fullname'];
				if ($k==2) $nam=rt3f_status('wb',0)." ".rt3f_role($v['role'],0)." $nam";
				else if ($k<7) $nam=rt3f_status($v['status'],0)." ".rt3f_role($v['role'],0)." $nam";
				// to make tooltip, need account
				$rt3l_list=rt3f_charlist($v['aid'],$level);
				$rt3l_acct=rt3f_masterlist($v['aid']);
				if ($rt3l_acct['fullname']==$v['fullname']) $rt3l_tchar=loc_char_main;
				else $rt3l_tchar=loc_char_alt;
				$tt=rt3h_div($rt3l_tchar,'cstatus');										// start with char status
				$tt.=rt3h_div(rt3f_rank('g',$rt3l_acct['grank']),'estatus');		// put up guild rank
// *** generate notes **********************************************************
				if ($k<7) {																			// check notes if subscribed
					if ($v['vn'] && $per['vn']) {												// check visual note
						$nam.=rt3h_span(loc_visualnote_mark,"notes public");
						$tt.=rt3h_div($v['vn'],"notes public");
						$thr=1;
					}
					if ($v['pn'] && $per['pn']) {												// check planning note
						$nam.=rt3h_span(loc_plannote_mark,"notes private");
						$tt.=rt3h_div($v['pn'],"notes private");
						$thr=1;
					}
					if ($thr) $tt.="<hr />\n";													// if used, need divider
					$thr=0;
				}
// *** generate characters *****************************************************
				for ($i=0; $i<count($rt3l_list); $i++) {
					if ($rt3l_list[$i]['fullname'] != $v['fullname']) {
						if ($rt3l_list[$i]['fullname']==$rt3l_acct['fullname'])
							$tcl=loc_char_main.": ";
						else
							$tcl=loc_char_alt.": ";
						$tcl.=$rt3l_list[$i]['fullname'];
						if ($k<7 && $per['character'])
							$tcl.=rt3h_button('swap['.$v['sid']."][".$rt3l_list[$i]['cid']."]",loc_btn_charswitch,'charselect');
						$tt.=rt3h_div($tcl,'characterlist');
						$thr=1;
					}
				}
// *** generate roles **********************************************************
				if ($k<7) {
					if ($thr) $tt.="<hr />\n";													// if used, need divider
					$thr=0;
					if ($per['role']){
					for ($i=1; $i<=rt3f_rolecount(); $i++) {
						if ($v['role']!=$i) {
							$tt.=rt3h_image('role['.$v['sid']."][".$i.']',RT_WI."role/$i.png", rt3f_role($i,2));
						}
					}
					$tt.=BR;
					}
// *** generate statuses *******************************************************
					if ($per['move']){
					if ($k!=2) { 																	// if not in whiteboard
						if ($per['wb'])															// if permissions, add button
							$tt.=rt3h_image('status['.$v['sid'].'][wb]',RT_WI."status/wb.png", rt3f_status('wb',2));
					}
					for ($i=1; $i<6; $i++) {													// go thru statuses
						if ($v['status']!=$i) {													// if status is NOT the same as this col
							if ($per["s$i"])														// check status permissions
								$tt.=rt3h_image('status['.$v['sid']."][$i]",RT_WI."status/$i.png", rt3f_status($i,2));
						}
					}
					if ($per['delete'])															// add delete if permissions
						$tt.=rt3h_button('status['.$v['sid']."][delete]",loc_btn_delete);
					}
				}
				$nam.=rt3f_tooltip('',$tt);													// makes tooltip
				$nam=rt3h_span($nam,'info');
				if ($per['edit'] && $k<7) $nam=rt3h_check('batch[list][]',$v['sid'],$nam);
				if ($per['add'] && $k==7) $nam=rt3h_button('add['.$v['aid']."]",loc_btn_addsub)." $nam";
				$grp[$k].=rt3h_div($nam);
			}
		} else {
			$grp[$k]=null;
		}
	}
	return $grp;
}
// ********************************************************* CODE **************
// *** set up permissions right ************************************************


// *** set up lists ************************************************************
if ($rt3mod_sl_view[1])																			// if can view event list
	$rt3mod_sl_group[1]=rt3f_subscriptionlist($rt3mod_sl_eid,0,1,1);				// group 1 is only event list
else 
	$rt3mod_sl_group[1]=null;
if ($rt3mod_sl_view[10])																		// if can view event list
	$rt3mod_sl_group[2]=rt3f_subscriptionlist($rt3mod_sl_eid,0,1,10);				// group 2 is only whiteboard
else 
	$rt3mod_sl_group[2]=null;
if ($rt3mod_sl_view[2]) {
	if ($rt3mod_sl_view[10])																	// if can view event list
		$rt3mod_sl_group[3]=rt3f_subscriptionlist($rt3mod_sl_eid,0,1,2);			// group 3 will show available
	else 
		$rt3mod_sl_group[3]=rt3f_subscriptionlist($rt3mod_sl_eid,0,1,array(2,12));	// group 3 will show available and wb if no wb access
} else 
	$rt3mod_sl_group[3]=null;
if ($rt3mod_sl_view[3]) {
	if ($rt3mod_sl_view[10])																	// if can view event list
		$rt3mod_sl_group[4]=rt3f_subscriptionlist($rt3mod_sl_eid,0,1,3);			// group 4 will show reserve
	else 
		$rt3mod_sl_group[4]=rt3f_subscriptionlist($rt3mod_sl_eid,0,1,array(3,13));	// group 4 will show reserve and wb if no wb access
} else 
	$rt3mod_sl_group[4]=null;
if ($rt3mod_sl_view[4]) {
	if ($rt3mod_sl_view[10])																	// if can view event list
		$rt3mod_sl_group[5]=rt3f_subscriptionlist($rt3mod_sl_eid,0,1,4);			// group 5 will show withdraw
	else 
		$rt3mod_sl_group[5]=rt3f_subscriptionlist($rt3mod_sl_eid,0,1,array(4,14));	// group 4 will show withdraw and wb if no wb access
} else 
	$rt3mod_sl_group[5]=null;
if ($rt3mod_sl_view[5]) 
	$rt3mod_sl_group[6]=rt3f_subscriptionlist($rt3mod_sl_eid,0,1,5);				// group 6 will show removed
else 
	$rt3mod_sl_group[6]=null;
if ($rt3mod_sl_view[0]) 
	$rt3mod_sl_group[7]=rt3f_notinsub($rt3mod_sl_eid);									// group 7 will show not in list
else 
	$rt3mod_sl_group[7]=null;
for ($i=1; $i<8; $i++)
	$rt3mod_sl_c[$i]=count($rt3mod_sl_group[$i]);
// *** check mode for popup/list generation ************************************
if ($rt3sys_event_mode==1)
	$rt3mod_sl_g=rt3f_slgroup($rt3mod_sl_group, $rt3mod_sl_priv);					// make the lists
// *** do the whiteboard approval **********************************************
if ($rt3mod_sl_g[2]) {
	if ($rt3mod_sl_priv['wbapprove']) {
		$rt3mod_sl_g[2].=rt3h_button("wbapprove",loc_btn_wb_approve);
	}	
	if ($rt3mod_sl_priv['wbclear']) {
		$rt3mod_sl_g[2].=rt3h_button("wbclear",loc_btn_wb_clear);
	}	
}
// *** make lists into 4 cells *************************************************
$rt3mod_sl_finallist[0]=$rt3mod_sl_g[1].$rt3mod_sl_g[2];
$rt3mod_sl_finallist[1]=$rt3mod_sl_g[3].$rt3mod_sl_g[4];
$rt3mod_sl_finallist[2]=$rt3mod_sl_g[5].$rt3mod_sl_g[6];
$rt3mod_sl_finallist[3]=$rt3mod_sl_g[7];
// *** make table **************************************************************
$rt3mod_sl_table=new rt3cl_table(4,1,1);
// *** make headers ************************************************************
for ($i=0;$i<4; $i++) $rt3mod_sl_h[$i]='';												// set headers blank
$rt3mod_sl_h[0]=rt3f_status(1,0); 															// populate head1 with icon head
if ($rt3mod_sl_view[1]) $rt3mod_sl_h[0].="- $rt3mod_sl_c[1]";
if ($rt3mod_sl_c[2] && $rt3mod_sl_view[10]) {
	$rt3mod_sl_h[0].=" | ".rt3f_status('wb',0); 																// populate head1 with icon head
	$rt3mod_sl_h[0].="- $rt3mod_sl_c[2]";
	$rt3mod_sl_h[0].=rt3f_infotip(loc_info_wb);
}
$rt3mod_sl_h[1]=rt3f_status(2,0); 																// populate head1 with icon head
if ($rt3mod_sl_view[2]) $rt3mod_sl_h[1].="- $rt3mod_sl_c[3]";
$rt3mod_sl_h[1].=" | ".rt3f_status(3,0); 																// populate head1 with icon head
if ($rt3mod_sl_view[3]) $rt3mod_sl_h[1].="- $rt3mod_sl_c[4]";
$rt3mod_sl_h[2]=rt3f_status(4,0); 																// populate head1 with icon head
if ($rt3mod_sl_view[4]) $rt3mod_sl_h[2].="- $rt3mod_sl_c[5]";
if ($rt3mod_sl_view[5]) {
	$rt3mod_sl_h[2].=" | ".rt3f_status(5,0); 																// populate head1 with icon head
	$rt3mod_sl_h[2].="- $rt3mod_sl_c[6]";
}
$rt3mod_sl_h[3]=rt3f_status(0,1); 																// populate head1 with icon head
if ($rt3mod_sl_view[0]) $rt3mod_sl_h[3].="- $rt3mod_sl_c[7]";
// *** put headers in table ****************************************************
for ($i=0; $i<4; $i++) $rt3mod_sl_table->addhead($rt3mod_sl_h[$i]);
// *** put data (row) in *******************************************************
for ($i=0; $i<4; $i++) $rt3mod_sl_table->addcell($rt3mod_sl_finallist[$i]);
// *** final table features ****************************************************
$rt3mod_sl_table->setattributes(0,0,array('id'=>'subscriptions'));				// set table ID to 'subscriptions'
$rt3sys_page['sublist']=$rt3mod_sl_table->html();						// output table to page
// *** edit features at bottom *************************************************
if ($rt3mod_sl_priv['edit']) {
	$rt3mod_sl_form=rt3h_h(2,loc_head_slbatch);

	foreach ($rt3loc_class as $k=>$v) { }													// batch select group
		
if (true) { // if move privs
	// get move row privs
	$rt3l_trow['00']=loc_sl_nomove;															// batch no move clause
	for ($i=1; $i<6; $i++)
		if ($rt3mod_sl_priv["s$i"]) $rt3l_trow[$i].=rt3f_status($i,1);				// if move status, include in drop box
	if ($rt3mod_sl_priv['wb']) $rt3l_trow['wb']=rt3f_status('wb',1);				// whiteboard 
	if ($rt3mod_sl_priv['delete']) $rt3l_trow['delete']=loc_btn_delete;			// delete
	$rt3mod_sl_rec[]=rt3h_select('batch[move]',$rt3l_trow,null,"00");
	$rt3mod_sl_field[]=loc_sl_f02;
}
if (true) { // if vn privs
	$rt3l_field=rt3h_text('batch[vn][note]','',"long");
	$rt3l_field.=rt3h_check('batch[vn][del]',1,loc_sl_delete);
	$rt3mod_sl_rec[]=$rt3l_field;
	$rt3mod_sl_field[]=loc_sl_f03;
}
if (true) { // if pn privs
	$rt3l_field=rt3h_text('batch[pn][note]','',"long");
	$rt3l_field.=rt3h_check('batch[pn][del]',1,loc_sl_delete);
	$rt3mod_sl_rec[]=$rt3l_field;
	$rt3mod_sl_field[]=loc_sl_f04;
}
$rt3mod_sl_rec[].=rt3h_button('batch[submit]',loc_btn_submit);
$rt3mod_sl_field[].=null;
// *** output all fields to screen *********************************************
for ($i=0; $i<count($rt3mod_sl_rec); $i++)
	$rt3mod_sl_form.=rt3h_formline($rt3mod_sl_field[$i], $rt3mod_sl_rec[$i]);
}
$rt3sys_page['sublist'].=$rt3mod_sl_form;													// output form to page
?>