<?php
/*******************************************************************************
 * login.php
 * -----------------------------------------------------------------------------
 * module that allows log in or creates log in credentials.
 * -----------------------------------------------------------------------------
 * Variables needed:
 * rt3sys_loginmode: Login mode 
 *  - s-short   (menubar login)
 *  - i-install (new install)
 *  - u-install (upgrade from 2.x)
 *  - l-install (link another 3.x table)
 *  - p-account profile page
 *  - a-admin reset profile
 *  - 1/2/3 login page (regular, forgot, register)
 * constants needed:
 * loc_charname
 * loc_infocharnote: tooltip info for character notes
 * loc_class
 * loc_role
 * loc_level
 * loc_submitbutton
 * loc_note
 * -----------------------------------------------------------------------------
 * returns rt3s_page[character] form
 * Note, this DOES create a submit button, but no form control. That's to the 
 * calling routine. 
 ******************************************************************************/

//--- general login mode	
//	$rt3sys_loginmode='2';
//********************************* form */
// ---- character name
// features for form
$rt3mod_form['name']=false;
$rt3mod_form['email']=false;
$rt3mod_form['pwd']=false;
$rt3mod_form['newpwd']=false;
$rt3mod_form['resetpwd']=false;
$rt3mod_form['tooltip']=false;
$rt3mod_form['button']=false;
$rt3mod_form['noform']=false;  //special for short: no formline
switch ($rt3sys_loginmode) {
	case 'p':  //profile (account)
		$rt3mod_form['pwd']=true;
		$rt3mod_form['button']='s';  //submit
	case 3:    //register page
	case 'i':  //install new
		$rt3mod_form['email']=true;
	case 'a':  //admin reset
		$rt3mod_form['newpwd']=true;
		if ($rt3sys_loginmode=='a') 
			$rt3mod_form['button']='r';  //reset button
		break;
		
	case 2:    //forgot page
		//$rt3mod_form['resetpwd']=true;  // reset password only
		$rt3mod_form['tooltip']=true;
		$rt3mod_form['button']='r'; // reset button
	case 'u':  //upgrade 
		$rt3mod_form['name']=1; // main only
		$rt3mod_form['email']=true;
		$rt3mod_form['newpwd']=true; // newpwd also inc. confirm
		if ($rt3sys_loginmode=='2')
			$rt3mod_form['button']='l'; // login button
		break;

	case 's':  //short login
		$rt3mod_form['noform']=true;
	case 1:    //regular login
		$rt3mod_form['name']=2; // any name
	case 'l':  //link
		if ($rt3sys_loginmode=='l') {
			$rt3mod_form['name']=1; // main name
			//$rt3mod_form['email']=true;
		}
		$rt3mod_form['pwd']=true;
		if ($rt3sys_loginmode!='l')
		$rt3mod_form['button']='l'; // login button
		break;
	default:   //not matching above
		echo "Error 95: Invalid login mode: $rt3sys_loginmode";
		exit();
}

$rt3mod_att['required']='required';

// ----- character name
if ($rt3mod_form['name']>0) {
	if ($rt3mod_form['name']==1) {
		$rt3l_caption=loc_primary." ";
		$rt3l_tt=loc_infomaincharacter;
	} else if ($rt3mod_form['noform']==false) {
		$rt3l_tt=loc_infocharacter;
	}
	$rt3l_caption.=loc_charname;

$rt3mod_att['required']='required';
$rt3mod_ctl=rt3h_text("login[name]",null,null,null, $rt3mod_att);
if (!$rt3mod_form['noform']) {
	$rt3mod_ctl.=rt3f_infotip($rt3l_tt);
	$rt3sys_mod['login'].=rt3h_formline($rt3l_caption, $rt3mod_ctl);
} else $rt3sys_mod['login'].=$rt3l_caption . " ". $rt3mod_ctl;
}
// ----- e-mail
if ($rt3mod_form['email']==true) {
$rt3mod_att['required']='required';
$rt3mod_ctl=rt3h_email("login[email]",null,null,null, $rt3mod_att);
if ($rt3mod_form['tooltip'])
$rt3mod_ctl.=rt3f_infotip(loc_infoemailforgot);
$rt3sys_mod['login'].=rt3h_formline(loc_email, $rt3mod_ctl);
}
// ----- password
if ($rt3mod_form['pwd']==true) {
$rt3mod_ctl=rt3h_password("login[pwd][curr]",null,null, $rt3mod_att);
if (!$rt3mod_form['noform']) {
	$rt3sys_mod['login'].=rt3h_formline(loc_password, $rt3mod_ctl);
} else $rt3sys_mod['login'].= loc_password . " ". $rt3mod_ctl;
}
// ----- reset password
if ($rt3mod_form['resetpwd']==true) {
unset($rt3mod_att['required']);
$rt3mod_ctl=rt3h_password("login[pwd][reset]",null,null, $rt3mod_att);
$rt3sys_mod['login'].=rt3h_formline(loc_reset." ".loc_password, $rt3mod_ctl);
}
// ----- new password
if ($rt3mod_form['newpwd']==true) {
$rt3mod_att['required']='required';
$rt3mod_ctl=rt3h_password("login[pwd][new]",null,null, $rt3mod_att);
$rt3mod_ctl.=rt3f_infotip(loc_infonewpassword);
$rt3sys_mod['login'].=rt3h_formline(loc_new." ".loc_password, $rt3mod_ctl);
// ----- repeat new password
$rt3mod_ctl=rt3h_password("login[pwd][r]",null,null, $rt3mod_att);
$rt3sys_mod['login'].=rt3h_formline(loc_repeat." ".loc_new." ".loc_password, $rt3mod_ctl);
unset($rt3mod_att['required']);
}
// ----- submit
if ($rt3mod_form['button']) {
if ($rt3mod_form['button']=='s') $rt3l_btn=loc_btn_submit;
if ($rt3mod_form['button']=='r') $rt3l_btn=loc_btn_reset; // reset
if ($rt3mod_form['button']=='l') $rt3l_btn=loc_btn_login; // login
$rt3mod_ctl=rt3h_button("submit",$rt3l_btn,null,null, $rt3mod_att);
	if ($rt3mod_form['noform']) $rt3sys_mod['login'].=$rt3mod_ctl;
	else $rt3sys_mod['login'].=rt3h_formline(null, $rt3mod_ctl);
}
// -----wrap up form
?>