<?php
/*******************************************************************************
 * log.php
 * -----------------------------------------------------------------------------
 * module that shows the log
 ******************************************************************************/
// *** check privs *************************************************************
if ($rt3sys_event) $rt3priv_logacc=rt3f_checkpriv('event','log');
else $rt3priv_logacc=rt3f_checkpriv('admin','syslog');
$rt3priv_logclear=rt3f_checkpriv('admin','clearlog');
if (!$rt3priv_logacc) {																			// no privs: error
	rt3f_fatalerror(1500);
	return;
}
// *** get log info ************************************************************
$rt3mod_logstart=0;
$rt3mod_loglimit=$rt3pref_log;
if ($rt3sys_event) {
	$rt3mod_log_q="ref=$rt3sys_event AND (`code`>299 AND `code`<610)";
} else {
	$rt3mod_log_q="(`code`<310 OR `code`>609)";
}
$rt3mod_log_ct1=$rt3db_table[0]->select(db_log,"count(*) as `ct`",$rt3mod_log_q);
$rt3mod_log_ct=$rt3mod_log_ct1[0]['ct'];
$rt3mod_log_base=$rt3db_table[0]->select(db_log,"*",$rt3mod_log_q,"LIMIT $rt3mod_logstart, $rt3mod_loglimit");
// *** check if count is greater than 0 ****************************************
if (!$rt3mod_log_ct) {
	rt3f_fatalerror(1501);
	return;
}
// --- set up table
$rt3mod_rows=count($rt3mod_log_base); // sets up that it is no more than pref : should be a min(pref, count)
$rt3mod_header=$rt3loc_loghead; // the headers 
$rt3mod_cols=count ($rt3mod_header);  // the exact # of table headers
$rt3mod_btn=$rt3loc_btn_log; // button header to clear log

// ****************************** THIS POINT ON, use own vars
// get log. 
// for general only, code 0-409 and 800+. For event, 400-709

// header cols: date/time | account | Category | code | reason

// make table
$rt3mod_logt=new rt3cl_table($rt3mod_cols,$rt3mod_rows);
// put in headers
for ($i=0; $i<$rt3mod_cols; $i++) $rt3mod_logt->addhead($rt3mod_header[$i]);
// routine to process rows
for ($i=0; $i<count($rt3mod_log_base); $i++) {
	// date & time
	$rt3mod_logcell=$rt3mod_log_base[$i]['date'];
	$rt3mod_logt->addcell($rt3mod_logcell);
	// account
	$rt3mod_logcell=$rt3mod_log_base[$i]['acct'];
	$rt3mod_logt->addcell($rt3mod_logcell);
	// category
//	$rt3mod_logcell=$rt3mod_log_base[$i]['date'];
	$rt3mod_logcell="Testing";
	$rt3mod_logt->addcell($rt3mod_logcell);
	// code
	$rt3mod_logcell=$rt3mod_log_base[$i]['code'];
	$rt3mod_logt->addcell($rt3mod_logcell);
	// reason
	$rt3mod_logcell=$rt3mod_log_base[$i]['desc'];
	$rt3mod_logt->addcell($rt3mod_logcell);

}
// print out table
$rt3mod_log=$rt3mod_logt->html();
// add clear?
if ($rt3priv_logclear)
	$rt3mod_log.=rt3h_formline(null,rt3h_button('clearlog',$rt3mod_btn));
// last line. gives procedure back
$rt3sys_page['main']=rt3f_forms($rt3mod_log);
?>