<?php
/*******************************************************************************
 * eventtable.php
 * -----------------------------------------------------------------------------
 * to generate the list table
 ******************************************************************************/
//====================================================	Variables
if (!$rt3pref_view['home']['n']) unset ($_GET);									// if navigation disabled, unset get vars.
$rt3mod_et_m=$rt3sys_table['mode'];
$rt3mod_et_stats=rt3f_checkpriv('account','stats');								// get stat permissions
for ($i=1; $i<6; $i++) 	$rt3mod_et_priv[$i]=rt3f_checkpriv('event',"s$i");		// get permissions for statuses
$rt3mod_et_priv[0]=1;															// keep total on : need priv?

$rt3mod_et_fdate=$rt3pref_format['date'][0];									// date format
$rt3mod_et_ftime=$rt3pref_format['time'];										// time format

if ($_GET['num']) $rt3mod_et_num=$_GET['num'];									// if num is set, use from get
else $rt3mod_et_num=$rt3pref_view['list']['n'];									// number of entries to publish
if ($_GET['start']) $rt3mod_et_ns=$_GET['start'];								// if start is set, use from get
else $rt3mod_et_ns=0;															// start at this number

//====================================================	code
// get data
//	$lst=$rt3db_table[0]->select($tbl,$field,$cond,$other);
if ($rt3mod_et_m==0) {
$rt3mod_et_Tct=$rt3db_table[0]->selectone('CT',db_event,'count(*) AS CT',null,"ORDER BY `ts` DESC");
$rt3mod_et_list=$rt3db_table[0]->select(db_event,'*',null,"ORDER BY `ts` DESC LIMIT $rt3mod_et_ns,$rt3mod_et_num");
} else {
$rt3mod_et_Tct=count($rt3db_table[0]->select(db_event.", ".db_sub,db_event.'.*',db_sub.".aid=$rt3sys_account AND ".db_sub.".eid=".db_event.".eid","ORDER BY `ts` DESC"));
$rt3mod_et_list=$rt3db_table[0]->select(db_event.", ".db_sub,db_event.'.*',db_sub.".aid=$rt3sys_account AND ".db_sub.".eid=".db_event.".eid","ORDER BY `ts` DESC LIMIT $rt3mod_et_ns,$rt3mod_et_num");
}

// *** make table columns ******************************************************
$rt3mod_et_head[]=loc_mod_et_col1;
$rt3mod_et_head[]=loc_mod_et_col2;
$rt3mod_et_head[]=loc_mod_et_col3;
if ($rt3user) $rt3mod_et_head[]=loc_mod_et_col4;								// if logged in, add sub column
if ($rt3mod_et_m==0){															// if general, do stats
	$rt3mod_et_head[]=loc_mod_et_col5;
	if ($rt3mod_et_stats) {
		for ($i=0; $i<6; $i++) {
			if ($rt3mod_et_priv[$i]) {
				if ($i==0) $rt3mod_et_head[]=loc_mod_et_col6;
				else $rt3mod_et_head[]=rt3f_status($i);
			}
		}
	}
} else {																		// self, look at char/role
	$rt3mod_et_head[]=loc_mod_et_col7;
	$rt3mod_et_head[]=loc_mod_et_col8;
	$rt3mod_et_head[]=loc_mod_et_col9;
}	
// *** create table ************************************************************
$rt3mod_et_tbl=new rt3cl_table(count($rt3mod_et_head),1);
// *** put column heads into table *********************************************
for ($i=0; $i<count ($rt3mod_et_head); $i++) {
	$rt3mod_et_tbl->addhead($rt3mod_et_head[$i]);
}
// *** generate rows ***********************************************************
for ($i=0; $i<count($rt3mod_et_list); $i++) { 
	// *** date and time ********************************************************
	$rt3mod_et_evt=$rt3mod_et_list[$i];														// focus on one event at a time
	$rt3mod_ldate=strtotime($rt3mod_et_evt['ts']);										// get sys date for start
	$rt3mod_et_date=$rt3time->fldate($rt3mod_ldate);									// get date/time format in local time
	$rt3mod_et_time=$rt3time->fltime($rt3mod_ldate);
	$rt3mod_et_tbl->addcell($rt3mod_et_date);												// put up date and time in table
	$rt3mod_et_tbl->addcell($rt3mod_et_time);
	// *** check status of event ************************************************
	$rt3mod_et_times=rt3f_timeconvert($rt3mod_et_evt);									// convert times to unix
	$rt3mod_et_status=rt3f_eventstatus($rt3mod_et_times);								// get result
	// *** get user subscription status *****************************************
	if ($rt3mod_et_m==0 && $rt3user) {
		$rt3mod_et_selfsub=rt3f_subscriptionlist($rt3mod_et_evt['eid'],$rt3user); // must be logged in to see
		if (is_null($rt3mod_et_selfsub)) $rt3mod_et_substat=rt3f_status(0);
		else $rt3mod_et_substat=rt3f_status($rt3mod_et_selfsub[0]['status'],1);
	} else if ($rt3mod_et_m==1) {
		$rt3mod_et_selfsub=rt3f_subscriptionlist($rt3mod_et_evt['eid'],$rt3sys_account); // must be logged in to see
		if (is_null($rt3mod_et_selfsub)) $rt3mod_et_substat=rt3f_status(0);
		else $rt3mod_et_substat=rt3f_status($rt3mod_et_selfsub[0]['status'],1);
	}
	// *** format event name ****************************************************
	$rt3mod_et_nam=rt3f_location($rt3mod_et_evt['loc'],0)." $rt3mod_et_evt[name]";
	$rt3mod_et_nam=rt3h_url($rt3mod_et_nam,"./?event=".$rt3mod_et_evt['eid']);
	// *** make tooltip *********************************************************
	if ($rt3mod_et_m==0) {
	$rt3mod_et_tt=null;
	if ($rt3user && $rt3user_status>0){														// if user logged in and active
		if (is_null($rt3mod_et_selfsub) ) {
			if ($rt3mod_et_status[0]==0 || $rt3mod_et_status[0]==2)
			$rt3mod_et_tt=rt3h_div(rt3h_button('qsub['.$rt3mod_et_evt['eid']."]",loc_mod_et_subbtn),'cstatus');
		} else 
		$rt3mod_et_tt=rt3h_div($rt3mod_et_substat,'cstatus');
	}
	$rt3mod_et_tt.=rt3h_div($rt3loc_eventstatus[$rt3mod_et_status[0]],'estatus');
	$rt3mod_et_tt.=rt3h_div($rt3mod_et_evt['name'],'eventname');						// event name
	if ($rt3mod_et_evt['vn'])
	$rt3mod_et_tt.=rt3h_div($rt3mod_et_evt['vn'],'eventnote');						// visual note
	if ($rt3mod_et_evt['pn'] && $rt3priv_event['pn'])
	$rt3mod_et_tt.=rt3h_div($rt3mod_et_evt['pn'],'eventnote officer');			// plan note
	$rt3mod_et_tt.=rt3h_div(rt3h_url(loc_mod_et_details,"./?event=$rt3mod_et_evt[eid]"),'eventlink');
	
		$rt3mod_et_nam.=rt3f_tooltip('',$rt3mod_et_tt);
	$rt3mod_et_nam=rt3h_span($rt3mod_et_nam,"event");
	}
	// need tooltip here
	// insert name here. Need to put in a tooltip 
	// *** insert name here *****************************************************
	$rt3mod_et_tbl->addcell($rt3mod_et_nam);
	// *** Add subscription status **********************************************
	if ($rt3user) {																				// if logged in, show column
		$rt3mod_et_tbl->addcell($rt3mod_et_substat);
	}
	// *** event status *********************************************************
	if ($rt3mod_et_m==0) { // if table mode is 0
		$rt3mod_et_tbl->addcell($rt3loc_eventstatus[$rt3mod_et_status[0]]);
	// *** stats of the event ***************************************************
		if ($rt3mod_et_stats) {
			for ($j=0; $j<6; $j++) {
				if ($rt3mod_et_priv[$j]) {
					if ($j==0) 																		// add totals
						$rt3mod_et_tbl->addcell($rt3mod_et_evt['total']);
					else {																			// add stat
						$rt3mod_et_sublist=count(rt3f_subscriptionlist($rt3mod_et_evt['eid'],0,1,$j));     // count of stats
						$rt3mod_et_sublist+=count(rt3f_subscriptionlist($rt3mod_et_evt['eid'],0,1,$j+10)); // to cover wb numbers
						$rt3mod_et_tbl->addcell($rt3mod_et_sublist);
					}
				}
			}
		}
	} else {
		// role
		$rt3mod_et_tbl->addcell($rt3mod_et_selfsub[0]['fullname']);
		$rt3mod_et_tbl->addcell(rt3f_role($rt3mod_et_selfsub[0]['role'],1));
		$rt3mod_et_tbl->addcell($rt3mod_et_selfsub[0]['vn']);
	}	
}
$rt3mod_tblfinal=$rt3mod_et_tbl->html();
if ($rt3pref_view['home']['n']) {												// navigation is on
	if ($rt3mod_et_Tct > $rt3mod_et_num) {										// if there is a reason to navigate (more than displayed)
		$rt3mod_tbl_link="?view=main&amp;tab=2&amp;num=$rt3mod_et_num&amp;";	// set link text
		if ($rt3mod_et_ns>0) {													// if not at beginning
			if ($rt3mod_et_ns-$rt3mod_et_num<0) $rt3mod_et_p=0;					// set it to 0 if in risk of negative back
			else $rt3mod_et_p=$rt3mod_et_ns-$rt3mod_et_num;						// subtract number
			$rt3mod_tbl_lk=rt3h_url(loc_nav_prev,$rt3mod_tbl_link."start=$rt3mod_et_p"); // link here
		}
		if (($rt3mod_et_n=$rt3mod_et_ns+$rt3mod_et_num)<$rt3mod_et_Tct) {		// set next block. if not past end of list
			if (isset($rt3mod_tbl_lk)) $rt3mod_tbl_lk.= " | ";					// if prev link set, add divider
			$rt3mod_tbl_lk.=rt3h_url(loc_nav_next,$rt3mod_tbl_link."start=$rt3mod_et_n");  // link here
		}
		$rt3mod_tblfinal.=rt3h_div($rt3mod_tbl_lk,"navlink");					// make link bar
	}
}
?>