<?php
/*******************************************************************************
 * eventsummary.php
 * -----------------------------------------------------------------------------
 * module that shows event summary for add/modify
 * -----------------------------------------------------------------------------
 * Passed in variables
 * rt3sys_event			array	from the DB on event structure
 *	rt3sys_add				bool	add mode only
 *	rt3priv_event			array	privs for event
 *	rt3pref_disp			array	(input only for suppress input boxes)
 * rt3pref_event			array	(check for collapse and relative)
 * rt3sys_time
 * -----------------------------------------------------------------------------
 * Variables:
 * -----------------------------------------------------------------------------
 * Const required: 
 * loc_eventsummary: localization for eventsummary
 * loc_eventtotal: localization for total
 * sys_disableinput : disables input boxes if scroll bars are tacky
 * -----------------------------------------------------------------------------
 * output: rt3sys_page['eventsummary']
 * does not provide a button or form. That is to the calling sub
 ******************************************************************************/
//=================================================	VARIABLES  ===============
$rt3mod_es_event=$rt3sys_eventinfo;
//$rt3mod_es_add=$rt3sys_add;
$rt3mod_es_ntime=$rt3form_adddate;												// new time if selected on calendar
$rt3mod_es_priv=$rt3priv_event;
$rt3mod_es_input=$rt3pref_disp['input'];
$rt3mod_es_expand=0; // to get the expand status
$rt3mod_es_coll=$rt3pref_event['collapse'];
$rt3mod_es_rel=$rt3pref_event['relative'];
// *** get the subscription status *********************************************
$rt3mod_es_times=rt3f_timeconvert($rt3sys_eventinfo);
$rt3mod_es_statusinfo=rt3f_eventstatus($rt3mod_es_times);
$rt3mod_es_status=$rt3mod_es_statusinfo[0];
$rt3mod_es_time=$rt3mod_es_statusinfo[1];
//================================================ FUNCTIONS
// for the yes/no option
$rt3l_yn=array(1=>loc_yes,0=>loc_no);
function rt3f_radio($name, $q, $choice, $def=null, $info=null) {
	foreach ($choice as $k=>$v) {
		$rt3l_field.=rt3h_radio($name, $k, $v,($def==$k?1:0))." ";
	}
	if ($info) $rt3l_field.=rt3f_infotip($info);
	return rt3h_formline($q,$rt3l_field);
}

//================================================ CODE
include RT_LM."eventtimes.php";

if ($rt3mod_es_event['eid']==0) $rt3mod_es_add=1;
else {
// *** get the subscription status *********************************************
	$rt3mod_es_times=rt3f_timeconvert($rt3sys_eventinfo);
	$rt3mod_es_statusinfo=rt3f_eventstatus($rt3mod_so_times);
	$rt3mod_es_status=$rt3mod_so_statusinfo[0];
	$rt3mod_es_time=$rt3mod_so_statusinfo[1];
}

/********************************   Check for mode and privileges */
if ($rt3mod_es_add) {															// if in add mode, check for privs
	if ($rt3mod_es_priv['add']) {												// have permissions for add. set init variables
		$rt3mod_es_flag=0;														// protect field MUST be off
		$rt3mod_es_event['note']['vn']='';										// set initial event values to empty
		$rt3mod_es_event['note']['pn']='';
		$rt3mod_es_event['loc']='';
		$rt3mod_es_event['name']='';
		$rt3mod_es_event['leader']='';
		//$rt3mod_es_event['id']='';
		// do something about leader with pref
	} else {																	// oops, no privs, error 20
		rt3f_fatalerror(1027);
		return;
	}
} else {																		// not in add mode, check for edit rights
	$rt3mod_es_flag=(!$rt3mod_es_priv['edit']);									// disabled is opposite of edit privs
}
/****************************************** Summary form */
$rt3sys_page['eventsummary']=rt3h_h(2,loc_eventsummary);						// creates summary header
// ------------------------------------------   event name
if (!$rt3mod_es_add)
	$rt3mod_es_parm['before']=rt3f_location($rt3mod_es_event['loc']);
$rt3mod_es_parm['type']='text';
$rt3mod_es_parm['name']='event[name]';
$rt3mod_es_parm['data']=$rt3mod_es_event['name'];
$rt3mod_es_parm['class']='long';
$rt3mod_es_parm['att']['required']='required';
$rt3mod_es_parm['field']=loc_eventfname;
$rt3mod_es_parm['dis']=$rt3mod_es_flag;
$rt3sys_page['eventsummary'].=rt3h_inpline($rt3mod_es_parm);
unset($rt3mod_es_parm['att']['required']);
unset($rt3mod_es_parm['before']);
unset($rt3mod_es_parm['class']);
// ---------------------------------------   location
if (!$rt3mod_es_flag) {								// need privs to edit this field or have it show
	$rt3mod_es_parm['type']='none';				// don't need new type. using premade field below
	$rt3mod_es_parm['data']=rt3f_locationlist("event[loc]",null, $rt3mod_es_event['loc']); 
	$rt3mod_es_parm['field']=loc_eventfloc;
$rt3mod_es_parm['dis']=0; 							// don't disable this field
$rt3sys_page['eventsummary'].=rt3h_inpline($rt3mod_es_parm);
}
// ---------------------------------------  event id
if (!$rt3mod_es_add) {
	$rt3mod_es_parm['after']=rt3h_url(loc_eventeventidlink ,".?event=$rt3mod_es_event[eid]"); // change to link
	$rt3mod_es_parm['type']='number';
	$rt3mod_es_parm['data']=$rt3mod_es_event['eid'];
} else {
	$rt3mod_es_parm['type']='none';
	$rt3mod_es_parm['data']=loc_eventeventidsoon;
}
$rt3mod_es_parm['name']='event[eid]';
$rt3mod_es_parm['field']=loc_eventfeventid;
$rt3mod_es_parm['dis']=1; // always disable this field
$rt3sys_page['eventsummary'].=rt3h_inpline($rt3mod_es_parm);
unset($rt3mod_es_parm['after']);
// -----------------------------------   level
// restore it to normals
if (!($rt3mod_es_add && $rt3pref_event['min']['l'])) {
$rt3mod_es_parm['name']='event[level]';
$rt3mod_es_parm['field']=loc_eventfminlevel;
$rt3mod_es_parm['data']=$rt3mod_es_event['level'];
$rt3mod_es_parm['type']='number';
$rt3mod_es_parm['class']='';
$rt3mod_es_parm['dis']=$rt3mod_es_flag;
$rt3sys_page['eventsummary'].=rt3h_inpline($rt3mod_es_parm);
unset($rt3mod_es_parm['dis']);
unset($rt3mod_es_parm['class']);
unset($rt3mod_es_parm['type']);
}
// -----------------------------------   public note
// restore it to normals
$rt3mod_es_parm['name']='event[vn]';
$rt3mod_es_parm['field']=loc_eventfnote;
$rt3mod_es_parm['data']=$rt3mod_es_event['vn'];
$rt3mod_es_parm['type']='text';
$rt3mod_es_parm['class']='long';
$rt3mod_es_parm['dis']=$rt3mod_es_flag;
$rt3sys_page['eventsummary'].=rt3h_inpline($rt3mod_es_parm);
unset($rt3mod_es_parm['dis']);
unset($rt3mod_es_parm['class']);
unset($rt3mod_es_parm['type']);
// ------------- ---------------------  private note
// privs to see plan note
if ($rt3mod_es_priv['pn']) {
	$rt3mod_es_parm['name']='event[pn]';
	$rt3mod_es_parm['data']=$rt3mod_es_event['pn'];
	$rt3mod_es_parm['field']=loc_eventfplan;
	$rt3mod_es_parm['type']='text';
	$rt3mod_es_parm['class']='long';
	$rt3mod_es_parm['dis']=$rt3mod_es_flag;
	$rt3sys_page['eventsummary'].=rt3h_inpline($rt3mod_es_parm);
	unset($rt3mod_es_parm['dis']);
	unset($rt3mod_es_parm['class']);
	unset($rt3mod_es_parm['type']);
}
// ------------- leader
if ($rt3mod_es_add) {
	if ($rt3pref_event['leader']==2) {
		$rt3l_yn2=array($rt3user=>loc_yes, 0=>loc_no); 									// set yes/no to acct ID
		$rt3sys_page['eventsummary'].=rt3f_radio('event[leader]',loc_eventfleader,$rt3l_yn2);
	} else {
		$rt3sys_page['eventsummary'].=rt3h_hidden('event[leader]',($rt3pref_event['leader']?$rt3user:0));
	}
} else {
	$rt3l_leaderlist[0]=loc_eventleadernone;
	for ($i=0; $i<count($rt3mod_sublist);$i++) {
		$rt3l_id=$rt3mod_sublist[$i]['aid'];
		$rt3l_leaderlist[$rt3l_id]=$rt3mod_sublist[$i]['fullname'];
	}
	$rt3l_leader=$rt3mod_es_event['leader'];
	if (is_null($rt3l_leader)) $rt3l_leader=0;
	if ($rt3mod_es_flag) $rt3l_field=$rt3l_leaderlist[$rt3l_leader];
	else $rt3l_field=rt3h_select('event[leader]',$rt3l_leaderlist,null,$rt3l_leader);
	$rt3sys_page['eventsummary'].=rt3h_formline(loc_eventfleader,$rt3l_field);
}
// *** add buttons if in edit/delete mode **************************************
if ($rt3mod_es_event && $rt3priv_event['edit']) {
	$rt3mod_es_btn=rt3h_button('event[edit]',loc_btn_eventchange);
	if ($rt3priv_event['del'])
		$rt3mod_es_btn.=rt3h_button('event[delete]',loc_btn_eventdelete);
	if ($rt3mod_es_btn) 
	$rt3sys_page['eventsummary'].=rt3h_formline(null,$rt3mod_es_btn);
}
?>