<?php
/*******************************************************************************
 * deleteac.php
 *******************************************************************************
 * deletes accounts or characters
 * Version 3.01  created date 9-03-2013  
 ******************************************************************************/
// *** this is for deleting characters, takes a list of charid's 1 or array ****
function rt3f_deletechar($charlist) {
	if (is_array($charlist)) {
		foreach ($charlist as $v) {
			$rt3f_deletechar($v);
		}
	} else {
		global $rt3db_table;
		if ($rt3db_table[1]->selectrec(db_acct,'*',"`main`=$charlist")) {
			rt3f_error(1203);
			return false;
		}
		$charrec=$rt3db_table[1]->selectrec(db_char,'*',"cid=$charlist"); // get name for log/message
		$charname=$charrec['name'];
		$acctid=$charrec['aid'];
		// *** delete from tables **********************************************
		$rt3db_table[1]->delete(db_char,"cid=$charlist");						// delete character in char table
		$rt3db_table[0]->delete(db_sub,"cid=$charlist");						// delete records of character in sub table
		$rt3db_table[0]->delete(db_dkp,"aid=$charlist");						// delete character in dkp table
		$rt3db_table[0]->delete(db_dkpl,"aid=$charlist");						// delete records of character in dkp list table
		// *** log and final message *******************************************
		$logdata="Deleted $charname";
		rt3f_logdata(243,$logdata,$acctid);
		rt3f_success(22,$charname);
	}
	return true;
}
function rt3f_deleteacct($acctlist) {
	if (is_array($acctlist)) {
		foreach ($acctlist as $v) {
			rt3f_deleteacct($v);
		}
	} else {
		global $rt3db_table, $rt3user;
//		if ($rt3db_table[1]->selectrec(db_acct,'*',"`main`=$charlist")) {
		if ($v==$rt3user) {														// CANNOT delete self
			rt3f_error(1210);
			return false;
		}
		$acctinfo=rt3f_masterlist($acctlist);									// get acct info.
		$acctmain=$acctinfo['fullname'];										// need main name
		// *** need the next for DKP, tables are missing true aid **************
		$charrec=rt3f_charlist($acctlist);
		for ($i=0; $i<count($charrec); $i++) {									// make linear list of char IDs
			if ($i>0) $clist.=", ";
			$clist.=$charrec[$i]['cid'];
		}
		$clist="IN ($clist)";													// list for sql
		// *** delete from tables **********************************************
		$rt3db_table[1]->delete(db_acct,"aid=$acctlist");						// delete account
		$rt3db_table[1]->delete(db_char,"aid=$acctlist");						// delete character in char table
		$rt3db_table[0]->delete(db_accts,"aid=$acctlist");						// delete in local
		$rt3db_table[0]->delete(db_sub,"aid=$acctlist");						// delete records of character in sub table
		$rt3db_table[0]->update(db_event,array('leader'=>0),"`leader`=$acctlist"); // change leaders to none where acct was listed
		$rt3db_table[0]->delete(db_dkp,"aid $clist");							// delete character in dkp table
		$rt3db_table[0]->delete(db_dkpl,"aid $clist");							// delete records of character in dkp list table
		// *** log and final message *******************************************
		$logdata="Deleted $acctmain";
		rt3f_logdata(232,$logdata);
		rt3f_success(20,$acctmain);
	}
	return true;
}
?>