<?php
/*******************************************************************************
 * checkpwd.php
 * -----------------------------------------------------------------------------
 * password and e-mail verification
 ******************************************************************************/
// *** check NEW password and repeat are same, proper length and chars *********
function rt3f_checkpwd($pass, $rep) {
	if ($pass!=$rep) $e=1260;													// new password doesn't match
	elseif (strlen($pass)<7) $e=1264;											// password must be 8+ char
	else {
		$arr=array('/[A-Z]/','/[a-z]/','/\d/');									// array of required characters in pwd
		for ($i=0; $i<count($arr); $i++) {										// cycle thru array
			if (!preg_match($arr[$i],$pass)) {										// missing a required character
				$e=1264;
				break;
			}
		}
	}
	if (!$e) return true;														// if no error, return true
	rt3f_error($e);																// show error
	return false;																// return false
}
// *** check for a valid e-mail. validates 99% of email ************************
function rt3f_checkmail($em) {
	if (preg_match('/^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4}$/i',$em))  		// valid e-mail
		return true;
	rt3f_error(1263);															// error
	return false;																// return false
}
// *** checks if password does not match old one *******************************
function rt3f_pwdmatch($old, $new) {
	if ($old!=$new)	return true;												// passwords don't match which is good
	rt3f_error(1262);															// error
	return false;
}
// *** checks if password DOES match (crypt) ***********************************
// *** problem is if hash (old pwd) is blank or set to "masterreset"
function rt3f_verifypwd($curr, $hash) {
	if (crypt($curr, $hash)==$hash)	return true;								// password crypted is the same, good.
	rt3f_error(1261);															// doesn't match, error
	return false;																// return false
}
// *** checks e-mail and new password (like for forgot or register) ************
function rt3f_vnewpwd($email, $new, $rep) {
	if (rt3f_checkmail($email) && rt3f_checkpwd($new, $rep))					// if both email valid and password valid 
		return true;															// return true
	return false;																// return false
}
// *** checks e-mail and old/new password correctness (change password) ********
function rt3f_changepwd($email, $old, $new, $rep) {
	if (rt3f_pwdmatch($old, $new) && rt3f_vnewpwd($email, $new, $rep))			// if both new pwd passes and not same as old
		return true;															// returns true
	return false;
}
?>