<?php
/*******************************************************************************
 * html.php
 * *****************************************************************************
 * Holds the HTML function calls here
 ******************************************************************************/

/*******************************************************************************
 * define the class (new)
 ******************************************************************************/
define ('NL',"\n");
class rt3cl_htmltag {
	//============================================== Variables
	private $name; 				// tag name
	private $data;					// data (only in standard tag)
	private $short;				// is a short tag <tag /> 0/1
	private $att;					// elements
	private $br;					// breaks 1/during, 0/after
	private $space;				// spacing around tab 0/before 1/during 2/after
	private $xmltag;				// special tag: 1/xml style tags <? > 2/comment <!-- > 3/doctype <! >
	//=============================================== Functions
	// constructor. name of tag | short tag (self-close?) | special tag (0/HTML, 1/xml, 2/comment, 3/doctype)
	function __construct ($tag, $s=0) {
		if ($s==4) { $st=1; $s=0; }
		$this->name=$tag;
		$this->short=$st;
		$this->xmltag=$s;
		$this->br[0]=0;
		$this->br[1]=0;
		$this->space[0]=0;
		$this->space[1]=0;
		$this->space[2]=0;
	}
	// *** adds data to tag (if short makes it a regular tag now) ***************
	public function adddata($s){
		if ($this->short) $this->short=0;
		$this->data=$s;
	}
	// *** sets element attribute. if $v is not set, uses name ******************
	public function setatt ($n, $v=null){
		if ($n!='value' && $v===null) $v=$n;
		$this->att[$n]=$v;
	}
	// *** batch set list *******************************************************
	public function setattlist($arr){
		if (is_array($arr))
			foreach ($arr as $k=>$v)
				$this->setatt ($k, $v);
	}
	// *** unsets element attribute *********************************************
	public function unsetatt($n) {
		unset ($this->att[$n]);
	}
	// *** set newline. on/off (off) and during/after (after) *******************
	public function breaks($b=0, $a=1)	{
		$this->br[$a]=$b;
	}
	// *** set spacing (tabs)  before/during/after | Number (0) *****************
	public function spacing($l, $n=0) {
		$this->space[$l]=$n;
	}
	// *** Wrapper for set/unset class attribute ********************************
	public function cl ($v) {
		if (is_null($v)) $this->unsetatt('class');
		else $this->setatt('class', $v);
	}
	// *** wrapper function for set/unset id attribute **************************
	public function id ($v) {
		if (is_null($v)) $this->unsetatt('id');
		else $this->setatt('id', $v);
	}
	// *** makes tag (Open/short or close.) Default is open/short ***************
	private function make($e=0){
		$t="<";
		if ($e) $t.="/";
		$t.=$this->name;
		if (!$e){
			if (count($this->att)) {
				foreach ($this->att as $k=>$v) {
					$t.=" $k=\"$v\"";
				}
			}
			if ($this->short) $t.= " /";
		}
		$t.=">";
		return $t;
	}
	// *** Returns the tag structure ********************************************
	public function get(){
		if ($this->space[0])
			for ($i=0; $i< ($this->space); $i++) $t.=" ";
		$t.=$this->make();
		if (!$this->short){
			if ($this->br[1]) $t.=NL;
			if ($this->space[1])
				for ($i=0; $i< ($this->space); $i++) $t.=" ";
			$t.=$this->data;
			if ($this->br[1]) $t.=NL;
			if ($this->space[0])
				for ($i=0; $i< ($this->space); $i++) $t.=" ";
			$t.=$this->make(1);
		}
		if ($this->br[0]) $t.=NL;
		if ($this->space[2])
			for ($i=0; $i< ($this->space); $i++) $t.=" ";
		return $t;
	}
}
/*******************************************************************************
 * Start with the base functions
 ******************************************************************************/
// base function. name of tag, close/open/self, and attributes, and a line break
function rt3h_tag($name, $open=1, $att=null, $lb=0){
	$t="<";
	if (!$open) $t.="/";
	$t.=$name;
	if ($open>0) {
		if (is_array($att)) {
			foreach ($att as $k=>$v){
				$t.=" $k=\"$v\"";
			}
		} else if (!is_null($att)) {
			$t.=$att;
		}
		if ($open>1) $t.="/";
	}
	$t.=">";
	if ($lb) $t.="\n";
	return $t;
}
// function to create regular tag with data in between.
// name, data between tags, attribute list, breaks btw elements, break after
function rt3h_tagr ($name, $data=null, $att=null, $lb=0, $la=0) {
	/* * /
	$u=new rt3cl_htmltag($name,0);
	$u->breaks($lb, $la);
	$u->adddata($data);
	$u->setattlist($att);
	return $u->get();
	// old code
	/* */
	$t=rt3h_tag($name, 1, $att, $lb);
	$t.=$data;
	if ($lb) $t.="\n";
	$t.=rt3h_tag($name, 0, null, $la);
	return $t;
}
// function to create self-closing tags (no data).
// name, attribute list, line breaks
function rt3h_tags ($name, $att=null, $lb=0) {
	$t=rt3h_tag($name, 2, $att, $lb);
	return $t;
}
// needed to add class, id to attribute list
function rt3h_att_ci (&$attlist, $class=null, $id=null){
	if ($class) $attlist['class']=$class;
	if ($id) $attlist['id']=$id;
}
// needed for input type, name and value to class
function rt3h_att_inp (&$attlist, $itype, $name, $value=null){
	$attlist['type']=$itype;
	$attlist['name']=$name;
	if (!is_null($value)) $attlist['value']=$value;
}
// general tag so other functions can wrap around it.
function rt3h_tag1 ($name, $data, $class=null, $id=null, $att=null, $lb=0, $la=0) {
	rt3h_att_ci($att, $class, $id);
	$t=rt3h_tagr($name,$data, $att, $lb, $la);
	return $t;
}
// general self-closing tag so other functions can wrap around it.
function rt3h_tag2 ($name, $class=null, $id=null, $att=null, $lb=0) {
	rt3h_att_ci($att, $class, $id);
	$t=rt3h_tags($name, $att, $lb);
	return $t;
}
//input in general
function rt3h_input ($type, $name, $value, $class=null, $id=null, $att=null){
	rt3h_att_inp($att, $type, $name, $value);
	return rt3h_tag2('input', $class, $id, $att, 1);
}
/*******************************************************************************
 * Now the essential wrappers for html elements. Start with block n text formatting
 ******************************************************************************/
function rt3h_div ($data, $class=null, $id=null, $attlist=null) {
	return rt3h_tag1('div', $data, $class, $id, $attlist, 1,1);
}
function rt3h_p ($data, $class=null, $id=null, $attlist=null) {
	return rt3h_tag1('p', $data, $class, $id, $attlist, 0,1);
}
function rt3h_b ($data, $class=null, $id=null, $attlist=null) {
	return rt3h_tag1('strong', $data, $class, $id, $attlist, 0,0);
}
function rt3h_i ($data, $class=null, $id=null, $attlist=null) {
	return rt3h_tag1('em', $data, $class, $id, $attlist, 0,0);
}
function rt3h_span ($data, $class=null, $id=null, $attlist=null) {
	return rt3h_tag1('span', $data, $class, $id, $attlist, 0,0);
}
function rt3h_h ($level, $data, $class=null, $id=null, $attlist=null) {
	if ($level<1 || $level>6) $level=1;
	return rt3h_tag1("h$level", $data, $class, $id, $attlist, 0,1);
}
function rt3h_url($linkname, $loc="#", $class=null, $id=null, $attlist=null) {
	$attlist['href']=$loc;
	return rt3h_tag1("a", $linkname, $class, $id, $attlist, 0,0);
}
function rt3h_img($url, $alt, $class=null, $id=null, $attlist=null) {
	$attlist['src']=$url;
	$attlist['alt']=$alt;
	return rt3h_tag2('img',$class, $id, $attlist,0);
}
/*******************************************************************************
 * Now the form formatting
 ******************************************************************************/
//function rt3h_input ($type, $name, $value, $class=null, $id=null, $att=null){
// to determine if in a form (field/input)
// field first, record next, field class/id/att, record class/id/att
function rt3h_formline($field, $record, $fclass=null, $fid=null, $fatt=null, $class=null, $id=null, $att=null) {
	$t=rt3h_div($field, "fieldname $fclass", $fid, $fatt,0,1);
	$t.=rt3h_div($record, "record $class", $id, $att,1,1);
	return rt3h_div($t, "formline",null,null, 1,1);
}
// label maker
function rt3h_label($name, $text) {
	$att['for']=$name;
	return rt3h_tag1('label', $text, null, null, $att, 0,0);
}
function rt3h_text($name, $value=null, $class=null, $id=null, $att=null) {
	return rt3h_input('text',$name, $value, $class, $id, $att);
}
function rt3h_file($name, $type=null, $class=null, $id=null, $att=null) {
	if ($type) $att['accept']=$type;
	return rt3h_input('file',$name, null, $class, $id, $att);
}
function rt3h_urltext($name, $value=null, $class=null, $id=null, $att=null) {
	return rt3h_input('url',$name, $value, $class, $id, $att);
}
function rt3h_password($name, $class=null, $id=null, $att=null) {
	return rt3h_input('password',$name, null, $class, $id, $att);
}
function rt3h_email($name, $value=null, $class=null, $id=null, $att=null) {
	return rt3h_input('email',$name, $value, $class, $id, $att);
}
function rt3h_button($name, $value=null, $class=null, $id=null, $att=null) {
	return rt3h_input('submit',$name, $value, $class, $id, $att);
}
function rt3h_image($name, $url, $alt, $class=null, $id=null, $attlist=null){
	$attlist['src']=$url;
	$attlist['alt']=$alt;
	return rt3h_input('image',$name, null, $class, $id, $attlist);
}
function rt3h_hidden($name, $value, $class=null, $id=null, $att=null) {
	return rt3h_input('hidden',$name, $value, $class, $id, $att);
}
function rt3h_check($name, $value, $label=null, $checked=0, $class=null, $id=null, $att=null) {
	if ($label) $t=rt3h_label($name, $label);
	if ($checked>0) $att['checked']='checked';
	else if ($checked < 0) $att['disbled']='disabled';
	return rt3h_input('checkbox',$name, $value, $class, $id, $att) . $t;
}
function rt3h_radio($name, $value, $label=null, $checked=0, $class=null, $id=null, $att=null) {
	if ($label) $t=rt3h_label($name, $label);
	if ($checked>0) $att['checked']='checked';
	else if ($checked < 0) $att['disbled']='disabled';
	return rt3h_input('radio',$name, $value, $class, $id, $att) . $t;
}
function rt3h_number($name, $value=null, $label=null, $min=null, $max=null, $step=null, $class=null, $id=null, $att=null) {
	if (!is_null($min)) $att['min']=$min;
	if (!is_null($max)) $att['max']=$max;
	if (!is_null($step)) $att['step']=$step;
	if ($label) $t=rt3h_label($nam3, $label);
	return rt3h_input('number',$name, $value, $class, $id, $att) . $t;
}
function rt3h_date($name, $value=null, $label=null, $class=null, $id=null, $att=null) {
	if ($label) $t=rt3h_label($nam3, $label);
	return rt3h_input('date',$name, $value, $class, $id, $att) . $t;
}
function rt3h_time($name, $value=null, $label=null, $class=null, $id=null, $att=null) {
	if ($label) $t=rt3h_label($nam3, $label);
	return rt3h_input('time',$name, $value, $class, $id, $att) . $t;
}
function rt3h_select($name, $optlist, $label=null, $defval=null, $class=null, $id=null, $att=null) {
	if ($label) $t=rt3h_label($nam3, $label);
	foreach ($optlist as $k=>$v) {
		if ($defval==$k) $a['selected']='selected';
		$a['value']=$k;
		$ctl=$ctl . rt3h_tag1('option',$v,null,null,$a,0,1);
		unset ($a);
	}
	$att['name']=$name;
	return $t. rt3h_tag1('select',$ctl, $class, $id, $att, 1,1);
}	
function rt3h_textarea($name, $value, $rows=4, $cols=20, $class=null, $id=null, $att=null) {
	$att['rows']=$rows;
	$att['cols']=$cols;
	$att['name']=$name;
	return rt3h_tag1('textarea', $value, $class, $id, $att, 1,1);
}
// create actual form
function rt3h_form($data, $method="POST", $action=".", $att=null) {
	$att['method']=$method;
	$att['action']=$action;
	return rt3h_tag1('form', $data,null,null, $att, 1,1);
}
/*******************************************************************************
 * rt3h_inpline
 * *****************************************************************************
 * General function for creating a form field/data line
 * -----------------------------------------------------------------------------
 * Passed in var: $parm is an array containing following keys:
 * - type. none|text|number|radio|check|select|hidden|...
 * - name. required. Name of control
 * - option: used for select|radio|check: array of controls
 * - default: default value
 * - before | after: text before or after control
 * - info :	optional infotips 
 * - field: Field name
 * - class: class name
 * - id: id name
 * - att: attribute list
 * - dis: disable check
 ******************************************************************************/
function rt3h_inpline($parm) {
	extract ($parm);
	if ($dis) {
		global $rt3pref_disp;
		if ($rt3pref_disp['input']) $type='none';
		else $att['disabled']='disabled';
	}
	if ($class) $att['class']=$class;
	if ($id) $att['id']=$id;
	if ($name) $att['name']=$name;
	switch ($type) {
		case 'none': 
			$rt3l_field=$data;
			break;
		case 'text':
		case 'password':
		case 'number':
		case 'hidden':
		case 'date':
		case 'time':
		case 'url':
		case 'email':
		case 'submit':
			$rt3l_ctl=new rt3cl_htmltag('input',1);
			$rt3l_ctl->setatt('type',$type);
			$rt3l_ctl->setatt('value',$data);
			if (!is_null($att))	$rt3l_ctl->setattlist($att);
			$rt3l_field=$rt3l_ctl->get();
			break;
		case 'radio':
			$rt3l_ctl[0]=new rt3cl_htmltag('input',1);
			$rt3l_ctl[1]=new rt3cl_htmltag('label',0);
			$rt3l_ctl[2]=new rt3cl_htmltag('span',0);
			$rt3l_ctl[0]->setatt('type',$type);
			$rt3l_ctl[0]->setatt('name',$name);
			if (!is_null($att))	$rt3l_ctl[0]->setattlist($att);
			foreach ($data as $k=>$v) {
				$rt3l_ctl[0]->setatt('value',$k);
				$rt3l_ctl[1]->setatt('for',$k);
				$rt3l_ctl[1]->adddata($v);
				if (isset($disabled[$k])) $rt3l_ctl[0]->setatt('disabled','disabled');
				if ($selected==$k) $rt3l_ctl[0]->setatt('checked','checked');
				$rt3l_ctl[2]->adddata(($rt3l_ctl[0]->get())." ".($rt3l_ctl[1]->get()));
				$rt3l_field.=$rt3l_ctl[2]->get();
				$rt3l_ctl[0]->unsetatt('disabled');
				$rt3l_ctl[0]->unsetatt('checked');
			}
			break;
		
		// get other cases done select, radio, checkbox, textarea
	}
	$rt3l_field=$before .' '. $rt3l_field .' '.$after;
	if ($info) $rt3l_field.=rt3f_infotip($info);
	return rt3h_formline($field,$rt3l_field);
}
// clean up HTML. for now this will strip ALL codes, but in future, will allow some codes
function rt3h_cleaner($text) {
	$txt=preg_replace("/(<[^<>]+>)/",'',$text);
	return $txt;
}
// special constant for BR
$b=rt3h_tags('br',null,1);
define ('BR', "$b");
unset ($b);
// *** new code to write tags **************************************************
function rt3h2_conv(&$att, $class=null, $id=null) {
	if ($class) $att['class']=$class;
	if ($id) $att['id']=$id;
}
function rt3h2_gettag($name, $data=null, $spectag=0, $att=null, $br=null, $sp=null) {
	$tag=new rt3cl_htmltag($name, $spectag);
	$tag->adddata($data);
	$tag->setattlist($att);
	// br (break) and sp (spacing) needs to be dealt with later
	return $tag->get();
}
function rt3h2_input($type, $name, $value=null, $disabled=0, $att=null) {
	if ($disabled==1) $att['disabled']='disabled';
	if ($disabled==2) $att['readonly']='readonly';
	if ($value) $att['value']=$value;
	$att['type']=$type;
	$att['name']=$name;
	return rt3h2_gettag('input',null,4,$att,array(0=>0,1=>1));
}
/*
function rt3h2_inpchoose($type, $name, $values, $def=null, $disabled=0, $att=null) {
	if ($type=='select') {
		foreach ($values as $k=>$v) {
			$a2['value']=$k;
			if ($k==$def) $a2['selected']='selected';
			$val.=rt3h2_gettag('option',$v,0,$a2,array(0=>0,1=>1));
			unset ($a2['selected']);
		}
		if ($disabled==1) $att['disabled']='disabled';
		if ($disabled==2) $att['readonly']='readonly';
		$att['name']=$name;
		$v=rt3h2_gettag('select',$val,0,$att,array(0=>1, 1=>1));
		return $v;
	} else {
		foreach ($values as $k=>$v) {
			if (
	}
}
*/
?>