<?php
/*******************************************************************************
 * dbfn.php
 * -----------------------------------------------------------------------------
 * get the master list down
 ******************************************************************************/
// list of accounts. if acct is given, just the account info.
// otherwise, active flag, rank (to show both grank/rtrank) and min level requirement
function rt3f_masterlist($acct=0, $active=1, $rank=1, $level=0) {
	global $rt3db_table;
	$tbl=db_acct.", ".db_char. ", ".db_accts;
	$cond=db_acct.".main=".db_char.".cid AND ".db_acct.".aid=".db_accts.".aid";
	$other="ORDER BY UCASE(`name`)";
	if ($acct) {
		$field=db_char.".*, ".db_accts.".*";
		$cond.=" AND ".db_acct.".aid=$acct";
	} else {
		$field=db_char.'.aid, '.db_char.'.cid, '.db_char.'.name, '.db_char.'.role, '
		.db_char.'.`class`, '.db_char.'.note ';
		if ($rank) $field.=", ".db_accts.'.grank, '.db_accts.'.rtrank ';
		$cond.=" AND ".db_accts.".active=$active AND ".db_char.".level >=$level";
	}
	$lst=$rt3db_table[0]->select($tbl,$field,$cond,$other);
	for ($i=0; $i<count($lst); $i++) {
		$lst[$i]['fullname']=rt3f_classname($lst[$i]['class'],$lst[$i]['name']);
		$lst[$i]['linkname']=rt3f_classlink($lst[$i]['class'],$lst[$i]['name'],$lst[$i]['aid']);
	}
	if ($acct) return $lst[0];
	return $lst;
}
// list of characters. If acct given, all for an account. if not, entire list
function rt3f_charlist($acct=0, $level=0) {
	global $rt3db_table;
	$tbl=db_char;
	$field="*";
	$other="ORDER BY UCASE(`name`)";
		$cond=null;
	if ($acct) $cond.=db_char.".aid=$acct";
	if ($level) $cond.=" AND ".db_char.".level >= $level";
	$lst=$rt3db_table[0]->select($tbl,$field,$cond,$other);
	for ($i=0; $i<count ($lst); $i++) 														// generate class/name icons
		$lst[$i]['fullname']=rt3f_classname($lst[$i]['class'], $lst[$i]['name']);
	return $lst;
}
// returns list of subscribers
function rt3f_subscriptionlist($eid, $acct=0, $active=1, $status=0) {
	global $rt3db_table, $rt3pref_track;
	$tbl=db_sub.", ".db_char.", ".db_accts;
	$field=db_sub.".*, ".db_char.".`name`, ".db_char.".`class`";
	$cond=db_sub.".eid=$eid AND ".db_char.".cid=".db_sub.".cid AND ".db_char.".aid=".db_accts.".aid";
	if ($acct) {
		$cond.=" AND ".db_sub.".aid=$acct";
	} else {																							// multiple accounts, fix sort
		if ($active) $cond.=" AND ".db_accts.".active=1";								// show active only
		if ($status) {
			if (is_array ($status)) {
				$cond.=" AND (";
				for ($i=0; $i<count($status); $i++) {
					if ($i>0) $cond.=" OR ";
					$cond.=db_sub.".status=$status[$i]";
				}
				$cond.=")";
			}
			else if ($status==10) 	$cond.=" AND ".db_sub.".status>9";						// shows certain status
			else 	$cond.=" AND ".db_sub.".status=$status";								// shows certain status
		}
		$other="ORDER BY `role`, ";															// ALWAYS sort role first
		if (!$rt3pref_track['sort']) $other.="`class`, UCASE(`name`)";						// class & name if pref set
		else $other.="sid";																		// SID if not set. that's incremental
	}
	$lst=$rt3db_table[0]->select($tbl,$field,$cond,$other);
	for ($i=0; $i<count ($lst); $i++) 														// generate class/name icons
		$lst[$i]['fullname']=rt3f_classname($lst[$i]['class'], $lst[$i]['name']);
	return $lst;
}
function rt3f_notinsub($eid, $active=1) {
	global $rt3db_table;
	$tbl=db_char.", ".db_acct.", ".db_accts;
	$field=db_char.".*";
	$cond=db_acct.".main=".db_char.".cid";
	if ($active)
		$cond.=" AND ".db_acct.".aid=".db_accts.".aid AND ".db_accts.".active=1";
	$cond.=" AND ".db_acct.".aid NOT IN (SELECT aid FROM ".db_sub." WHERE eid=$eid)";
	$other="ORDER BY `name`";
	$lst=$rt3db_table[0]->select($tbl,$field,$cond,$other);
//	var_dump ($lst);
//	exit();
	for ($i=0; $i<count ($lst); $i++) 														// generate class/name icons
		$lst[$i]['fullname']=rt3f_classname($lst[$i]['class'], $lst[$i]['name']);
	return $lst;
}
// convert times to unix
function rt3f_timeconvert ($list, $status=null) {
	if (is_null($status)) {
		$s=array('cw','cs','i','s','e');
		for ($i=0; $i<5; $i++)
			$l[$i]=rt3f_timeconvert($list,$s[$i]);
		return $l;
	}
	$v="t$status";
	return strtotime($list[$v]);
}
// takes time list (look above) and gives status
function rt3f_eventstatus($list) {
	global $rt3time;
	for ($i=0; $i<5; $i++) $l[$i]=$rt3time->compare ($list[$i]);
	$status=0;
	$m=0;
	while ($status<6) {																			// if event is not ended, check times
		if ($status<3) {																			// not past both close times
			if ($l[0]>0) {																			// subscription time is later, check withdrawl
				if ($l[1]>0) {
					$m=min($l[0],$l[1]); 
					break;
				}
				$status=2;
				$m=$l[0];
				break;
			}
			if ($l[1]>0) {
				$status=1;
				$m=$l[1];
				break;
			}
			$status=3;
		}
		if ($l[($status-1)] >0) {
			$m=$l[($status-1)];
			break;
		}
		$status++;
	}
	$arr[0]=$status;																				// main status to array
	if ($status<6) {																				// convert time left into minutes if not over
		if ($m<60*5) $m=4	;																		// if less than 5 min, set to 4 (less than 5 min)
		else $m=floor($m/60);																	// seconds to minutes
	}
	$arr[1]=$m;
	return $arr;
}
function rt3f_eventlist($type, $from=null, $to=null) {
	global $rt3db_table;
	$tbl=db_event;
	$field=db_event."*";
	switch ($type) {
		case 'o': $cond="eid=$from"; break;
		case 'l': $cond=''; $other="LIMIT $from, $to";  break;
		case ($type>0): 
			$tbl.=", ".db_sub;
			$cond=db_event.".eid=".db_sub.".eid AND ".db_sub.".aid=$type AND ";
		case 'd': 
			$cond.=db_event.".ts>'$from' AND ".db_event.".ts<'$to'";
	}
	$lst=$rt3db_table[0]->select($tbl, $field,$cond,$other);
	var_dump ($lst);
	return $lst;
}
/*
SELECT ts_character.* FROM ts_account, ts_character, tl_locset 
WHERE ts_account.main=ts_character.cid AND ts_account.aid=tl_locset.aid AND tl_locset.active=1 AND ts_account.aid NOT IN (SELECT aid FROM tl_sub WHERE eid=167) 

ORDER BY ts_character.`name`

SELECT ts_character.* FROM ts_account, ts_character, tl_locset WHERE ts_account.main=ts_character.cid AND ts_account.aid=tl_locset.aid AND tl_locset.active=1 AND ts_account.aid NOT IN (SELECT aid FROM tl_sub WHERE eid=167) ORDER BY ts_character.`name`

		aid, cid, name, level, role, class, note, 
		rtrank, grank

$active=1, $rank=0, $expand=0)

$rt3sys_grouplist=$rt3db_table[0]->select(db_char.".*, ".db_loc.".*",
db_acct.", ".db_char.", "db_loc, "ts_account.main=ts_character.cid AND ts_account.aid=tl_locset.aid",
"ORDER BY `name`");

$rt3mod_a_main=$rt3db_table[0]->select(db_acct,'*',"aid='$rt3sys_acctview'");

SELECT ts_character.*, tl_locset.* FROM ts_account, ts_character, tl_locset WHERE ts_account.main=ts_character.cid AND ts_account.aid=tl_locset.aid ORDER BY `name`
*/
?>