<?php
/*******************************************************************************
 * corelib.php
 * -----------------------------------------------------------------------------
 * The place where all core functions are stored. These are used in virtually
 * every page
 ******************************************************************************/
/*******************************************************************************
 * rt3f_tabs
 *******************************************************************************
 * version 2 of the tab bar. It will return a tab bar in html <div id="tabbar">
 * -----------------------------------------------------------------------------
 * Passed in:
 * $category -- category
 * $active   -- active tab. starts with 1
 * $inactive -- any inactive tabs if any (array) (tabs start with 1)
 * $id       -- optional id if used for acct or event
 ******************************************************************************/
function rt3f_tabs($category, $active=1, $inactive=null, $id=null) {
	// get tab localization
	$field="rt3loc_tab_$category";
	global $$field;
	global $rt3sys_page, $rt3sys_tab;
	$active=$rt3sys_tab;
	$tablist=$$field;
	//do tab analysis
	$tabct=count($tablist);
	if ($active<1 || $active>$tabct)											// active tab out of range
		rt3f_criticalerror(1022,"$active | ".count($tabct));
	if (is_array($inactive)) {
		foreach ($inactive as $v) {
			if ($v<1 || $v>$tabct) 												// inactive tab out of range
				rt3f_criticalerror(1021,"$active | ".count($tabct));
			if ($v==$active) 													// inactive tab same as active tab
				rt3f_criticalerror(1020, $v);
			$rt3l_inactive[$v]=1;
		}
	}
	// url link
	$url="./?view=$category&amp;";
	if ($category=='event'|| $category=='account') $url.="id=$id"."&amp;";
	$url.="tab=";
	// make tabs
	for ($i=0; $i<$tabct; $i++) {
		if (isset($rt3l_inactive[$i+1])) {
			$u="#";
			$c="inactive";
		} else if ($i+1==$active) {
			$u="#";
			$c="select";
		} else {
			$u=$url.($i+1);
			$c=null;
		}
		$tabbar.=rt3h_url($tablist[$i],$u,$c)."&nbsp;";
	}
	$mod_tab=rt3h_div($tabbar,null,'tabbar');
	$rt3sys_page['tab']=$mod_tab;
	return $mod_tab;
}

/*********************
 * Typical tooltip
 ********************/
function rt3f_tooltip ($anchor, $text, $move=0) {
	$t=rt3h_div($text, 'tooltip');
	return rt3h_div ($anchor . $t, 'info');
}
/********************
 * Info tooltip
 *******************/
function rt3f_infotip ($text) {
	$file='system/quest.png';     // for later themeing
	$a=rt3h_img(RT_WI . $file, loc_moreinfotip);
	return rt3f_tooltip($a, $text);
}
/********************
 * icons
 * basic class to show icons
 ********************/
function rt3f_icons ($family, $icon, $alt) {
	return rt3h_img( RT_WI. "$family/$icon.png", $alt);
}
/*******************************************************************************
 * rt3f_forms
 * -----------------------------------------------------------------------------
 * wrapper to make forms complete
 ******************************************************************************/
function rt3f_forms($data) {
	// make use of global variables
	global $rt3sys_system; 													// to be used for system values
	global $rt3sys_view, $rt3sys_tab;											// current tab
	global $rt3sys_event, $rt3sys_account;										// for event and account
	global $rt3sys_addon;														// for addon
	// include theme, mode (for mobile/xml, etc)
	// for old-style variables
	if (!is_null($rt3sys_event)) $rt3sys_system['event']=$rt3sys_event;
	if (!is_null($rt3sys_account)) $rt3sys_system['account']=$rt3sys_account;
	if (!is_null($rt3sys_view)) $rt3sys_system['view']=$rt3sys_view;
	if (!is_null($rt3sys_tab)) $rt3sys_system['tabno']=$rt3sys_tab;
	if (!is_null($rt3sys_addon)) $rt3sys_system['addon']=$rt3sys_addon;
	foreach ($rt3sys_system as $k=>$v)
		$data.=rt3h_hidden("system[".$k."]", $v);
	return rt3h_form($data);
}
function rt3f_logdata($code, $desc, $ref=null) {
	global $rt3time, $rt3user;
	global $rt3db_table;
	$rt3l_arr['date']=$rt3time->get_DBtime();
	if ($rt3user) $rt3l_arr['acct']=$rt3user;
	else $rt3l_arr['acct']=$_SERVER['REMOTE_ADDR'];
	$rt3l_arr['code']=$code;
	$rt3l_arr['desc']=$desc;
	if ($ref) $rt3l_arr['ref']=$ref;
	$rt3db_table[0]->insert(db_log, $rt3l_arr);
}
// *** takes the array and gets the key listed *********************************
function rt3f_getkey($arr) {
	$temp=array_keys($arr);																		// put array keys in array
	return $temp[0];																				// get the 1st value
}

?>