<?php
/*******************************************************************************
 * subscriptions.php 
 * -----------------------------------------------------------------------------
 * makes or modifies subscriptions
 ******************************************************************************/
// =============================================================== FUNCTIONS ===
// *** function retrieves the array key when the key means more than value *****
// *** function retrieves subscription id, or 0 if not subscribed **************
function rt3f_substatus($eid, $aid) {
	global $rt3db_table;														// need this to access db
	$temp=$rt3db_table[0]->select(db_sub,'sid',"aid=$aid AND eid=$eid");
	if (is_null($temp)) return 0;
	return $temp[0]['sid'];
}
// *** function returns 1 if event is open, -1 for override only, 0 if closed **
function rt3f_eventopen($eid) {
	global $rt3db_table;
	$temp=$rt3db_table[0]->select(db_event,'*',"eid=$eid");						// get event info
	$temp2=rt3f_timeconvert($temp[0]);
	$stat=rt3f_eventstatus($temp2);												// get status now
	if ($stat[0]>4) return 0;													// event has started: closed for sub
	if ($stat[0]==0 || $stat[0]==2) return 1;									// open for all
	return -1;																	// requires override here
}
function rt3f_charinfo($cid) {
	global $rt3db_table;
	$temp=$rt3db_table[1]->select(db_char,'*',"cid=$cid");						// get character info
	return $temp[0];
}
// ==================================================================== CODE ===
// *** determines if logged in first *******************************************
if (!$rt3user) {																// no user is error
	rt3f_error(1100);
	$rt3sys_view="main";
	return;
}
// *** get info about account/event ID *****************************************
$rt3form_sub['aid']=$rt3user;													// get account ID
if ($rt3form_qsub) {															// if One-Click from main page
	$rt3form_sub['eid']=rt3f_getkey($rt3form_qsub);								// get event ID
} else {																		// on event page
	$rt3sys_event=$rt3form_system['event'];										// get event ID
	$rt3form_sub['eid']=$rt3sys_event;											// event ID to return to
}
$rt3sys_view=$rt3form_system['view'];											// view name
$rt3sys_tab=$rt3form_system['tabno'];											// tab number
$rt3form_sid=rt3f_substatus($rt3form_sub['eid'], $rt3form_sub['aid']);			// get sub ID (if exists)
$rt3form_estatus=rt3f_eventopen($rt3form_sub['eid']);							// check if event is open
if ($rt3form_estatus<0) $rt3form_estatus=rt3f_checkpriv('event','time');		// if in override, check if one can (add to function?)
if ($rt3form_qsub || $rt3form_quick) $rt3form_oc=1; 							// if One-Click, quick sub flag set on
// *** check important data is correct **************************************
if (!$rt3form_estatus) {														// event time has lapsed to subscribe
	rt3f_error(1104);
	return;
}
if ($rt3form_oc) {																// if one-click
	if ($rt3form_sid) {															// quick sub when already subscribed: error
		rt3f_error(1101);
		return;
	}
	$rt3form_sub['status']=2;													// set status
	$rt3form_sub['cid']=$rt3user_info['cid'];									// get main char ID
	$rt3form_sub['role']=$rt3user_info['role'];									// character role
	$rt3form_charlevel=$rt3user_info['level'];									// level to check if high enough
	$rt3form_log['code']=410;													// code is 410 for quick sub
	$rt3form_log['desc']=null; 													// description : tbd what the message is
	$rt3form_add=1;																// turn on add flag
} else {																		// used full form
	if (!isset($rt3form_eventsub['status'])) {									// no status given
			rt3f_error(1103);
			return;
		} else $rt3form_sub['status']=$rt3form_eventsub['status'];				// assigns status from form		
	if (!isset($rt3form_eventsub['cid'])) {										// no character given: needs temp flag to see if character sel is disabled
			rt3f_error(1102);
			return;
		} else $rt3form_sub['cid']=$rt3form_eventsub['cid'];					// assigns cid from form
	if (isset($rt3form_eventsub['vn']))											// if visual note DOES exist
		$rt3form_sub['vn']=$rt3form_eventsub['vn'];								// assign it to note
	if ($rt3form_sid) {															// if subscription exists, check for modifications
		$rt3form_chardetail=rt3f_charinfo($rt3form_sub['cid']);
		$rt3form_subdetail2=$rt3db_table[0]->select(db_sub,'*',"sid=$rt3form_sid");
		$rt3form_subdetail=$rt3form_subdetail2[0];
		if ($rt3form_subdetail['status']==$rt3form_sub['status'])				// comparing: status is equal
			unset ($rt3form_sub['status']);
		else {
			$rt3form_log[0]['code']=420+$rt3form_sub['status'];
			$rt3form_log[0]['desc']="Changed from <status id=\"".$rt3form_subdetail['status']."\" />";
		}
		if ($rt3form_subdetail['cid']==$rt3form_sub['cid'])						// comparing: cid is equal
			unset ($rt3form_sub['cid']);
		else {
			$rt3form_sub['role']=$rt3form_chardetail['role'];
			$rt3form_log[1]['code']=431;
			$rt3form_log[1]['desc']="Changed from <char id=\"".$rt3form_chardetail['cid']."\" />"
			. " to <char id=\"".$rt3form_sub['cid']."\" />";
		}
		if ($rt3form_subdetail['vn']==$rt3form_sub['vn'])						// comparing: cid is equal
			unset ($rt3form_sub['vn']);
		else {
			echo "vn change : ";
			$rt3form_log[2]['code']=433;
			$rt3form_log[2]['desc']="Changed from '".$rt3form_chardetail['vn']."'"
			. " to '".$rt3form_sub['vn']."'";
		}
		// *** change the subscription *******************************************
		if (isset($rt3form_log)) {
			$rt3db_table[0]->update (db_sub, $rt3form_sub,"sid=$rt3form_sid");
			foreach ($rt3form_log as $v)
				rt3f_logdata($v['code'],"<sub id=\"$rt3form_sid\" />".$v['desc'],$rt3form_sub['eid']);
			rt3f_success(2);
		} else 
			rt3f_success(3);
		return;
	}
	$rt3form_char=rt3f_charinfo($rt3form_sub['cid']);
	$rt3form_charlevel=$rt3form_char['level'];
	$rt3form_sub['role']=$rt3form_char['role'];
}	
// *** get event to compare ****************************************************
$rt3form_subdetail2=$rt3db_table[0]->select(db_sub,'*',"eid=$rt3form_sub[eid]");
$rt3form_subdetail=$rt3form_subdetail2[0];
if ($rt3form_subdetail['level'] > $rt3form_charlevel) {
	rt3f_error(1105);
	return;
}
// *** add subscription ********************************************************
$rt3db_table[0]->insert(db_sub, $rt3form_sub);
$rt3l_subcheck=$rt3db_table[0]->select(db_sub, 'sid',"aid=$rt3form_sub[aid] AND eid=$rt3form_sub[eid]");
$rt3l_subid=$rt3l_subcheck[0]['sid'];														//
$rt3form_log['desc']="<sub id=\"${rt3l_subid}\" /> ".$rt3form_log['desc'];
rt3f_logdata($rt3form_log['code'],$rt3form_log['desc'], $rt3form_sub['eid']);
//echo "Success: id: $rt3l_subid";
rt3f_success(1);
?>