<?php 
/*******************************************************************************
 * sublist.php
 * *****************************************************************************
 * processes all subscription list changes
 ******************************************************************************/
// *** system-wide settings: event, tab, etc ***********************************
$rt3sys_view='event';
$rt3sys_tab=$rt3form_system['tabno'];
$rt3sys_event=$rt3form_system['event'];
$rt3form_evt=$rt3db_table[0]->selectrec(db_event,'*',"eid=$rt3sys_event");
// *** process one-click changes (swap, status, etc) ***************************
if ($rt3form_status) {
	$rt3form_st='status';
	$rt3form_btn=$rt3form_status;
} else if ($rt3form_role) {
	$rt3form_st='role';
	$rt3form_btn=$rt3form_role;
} else if ($rt3form_swap) {
	$rt3form_st='swap';
	$rt3form_btn=$rt3form_swap;
} else if ($rt3form_add) {
	$rt3form_st='add';
	$rt3form_btn=$rt3form_add;
}
// *** special button, not batch mode ******************************************
if (isset($rt3form_st)) {
	$rt3form_sid=rt3f_getkey($rt3form_btn);												// get sid (or aid for add)
	// *** add a subscription ***************************************************
	if ($rt3form_st=='add') {
		$rt3form_aid=$rt3form_sid;												// so I don't confuse sub ID with acct ID
		$rt3form_acct=rt3f_masterlist($rt3form_aid);							// get acct list
		if ($rt3form_acct['level']<$rt3form_evt['level']) {						// account level is less than event level
			rt3f_error(1110);
		} else {																// create info for sub table
			$rt3form_addsub['eid']=$rt3sys_event;
			$rt3form_addsub['aid']=$rt3form_aid;
			$rt3form_addsub['cid']=$rt3form_acct['cid'];
			$rt3form_addsub['role']=$rt3form_acct['role'];
			$rt3form_addsub['status']=2;
			$rt3form_subid=$rt3db_table[0]->insone (db_sub, $rt3form_addsub, 'sid',"aid=$rt3form_aid AND eid=$rt3sys_event"); // insert
			rt3f_logdata(510,"[sub id: $rt3form_Subid] Added [acct: $rt3form_aid]", $rt3sys_event);
			rt3f_success(10);
		}
		return;
	// *** else edit a subscription *********************************************
	} else {
		$rt3form_substat=$rt3db_table[0]->selectrec(db_sub,'*',"sid=$rt3form_sid"); //get sub record
		$rt3form_tostat=rt3f_getkey($rt3form_btn[$rt3form_sid]);				// get the to status (status, role or char id)
		// *** status change *****************************************************
		if ($rt3form_st=='status') {
			if ($rt3form_evt['leader']==$rt3form_substat['aid']) {				// if leader, this is an error
				rt3f_error(1111);
				return;
			}
			if ($rt3form_tostat=='delete') {									// if delete button pressed
				$rt3db_table[0]->delete(db_sub,"sid=$rt3form_sid");
				rt3f_logdata(516,"[sub id: $rt3form_sid][acct: ".$rt3form_substat['aid']."]",$rt3sys_event);
				rt3f_success(9);
				return;
			}
			if ($rt3form_tostat=='wb') {
				$rt3form_tostat=($rt3form_substat['status']+10) % 20;			// makes sure it's between 10-19. Need better system for flag
				$rt3form_code=517;												// code for add to wb
			} else $rt3form_code=510+$rt3form_tostat;							// code for change
			$rt3form_update['status']=$rt3form_tostat;
			$rt3form_success=8;													// success code
			$rt3form_logdesc="[sub id: $rt3form_sid][acct ".$rt3form_substat['aid']."]";
		}
		if ($rt3form_st=='role') {
			$rt3form_update['role']=$rt3form_tostat;
			$rt3form_success=11;
			$rt3form_code=522;
			$rt3form_logdesc="[sub id: $rt3form_sid] Changed role from [role ".$rt3form_substat['role']."] to [role $rt3form_tostat]";
		}
		if ($rt3form_st=='swap') {
			$rt3form_charlink=$rt3db_table[1]->selectone('level',db_char,'*',"cid=$rt3form_tostat"); // get level
			if ($rt3form_charlink<$rt3form_evt['level'] && $rt3pref_event['min']['r']) { // if level is too low and required
				rt3f_error(1112);												// error
				return;
			}
			$rt3form_update['cid']=$rt3form_tostat;
			$rt3form_success=12;
			$rt3form_code=521;
			$rt3form_logdesc="[sub id: $rt3form_sid] Changed character from [char ".$rt3form_substat['cid']."] to [char $rt3form_tostat]";
		}
	}
	$rt3db_table[0]->update(db_sub, $rt3form_update,"sid=$rt3form_sid");
	rt3f_logdata($rt3form_code,$rt3form_logdesc,$rt3sys_event);
	rt3f_success($rt3form_success);
	return;																							// exits module
// *** whiteboard settings *****************************************************
} 
else if ($rt3form_wbapprove) {
	$rt3db_table[0]->update(db_sub,array('status'=>1),"eid=$rt3sys_event AND `status`>9");
	rt3f_logdata(531,"", $rt3sys_event);
	rt3f_success(13);
	return;
} 
else if ($rt3form_wbclear) {
	$rt3db_table[0]->update(db_sub,"`status` = `status` - 10","eid=$rt3sys_event AND `status`>9");
	rt3f_logdata(532,"", $rt3sys_event);
	rt3f_success(14);
	return;
// *** batch mode processing ***************************************************
} 
else {
	if (!isset($rt3form_batch['list'])) {													// no list set?
		rt3f_error(1113);																			// error
		return;
	}
	$rt3form_sidlist=$rt3form_batch['list'];												// get list
	$rt3form_slist2=implode(', ',$rt3form_sidlist);										// implode. next line gets accounts affected.
	$rt3form_acctlist=$rt3db_table[0]->select(db_sub, 'aid', "sid IN ($rt3form_slist2)"); 
	for ($i=1; $i<count($rt3form_acctlist); $i++)
		$rt3form_al.=($i>0?", ":"").$rt3form_acctlist[$i]['aid'];
	// *** move is selected *****************************************************
	if ($rt3form_batch['move']!=='00') {													// batch move
		if ($rt3form_evt['leader']) {															// check if leader is chosen for moves
			for ($i=0; $i<count($rt3form_acctlist); $i++) {								// go thru list, make sure leader is not one
				if ($rt3form_acctlist[$i]['aid']==$rt3form_evt['leader']) {			// leader? error
					rt3f_error(1114);
					return;
				}
			}
		}
		if ($rt3form_batch['move']=='delete') {											// if delete
			$rt3db_table[0]->delete(db_sub,"sid IN ($rt3form_slist2)");				// delete rows
			rt3f_logdata(548,"Deleted [acct $rt3form_al]",$rt3sys_event);
			rt3f_success(15);																		// success message
			return;																					// exit
		}
		if ($rt3form_batch['move']=='wb') {													// if whiteboard
			$rt3db_table[0]->update(db_sub, "`status` = `status` +10", "sid IN ($rt3form_slist2) AND `status`<10");
			rt3f_logdata(546,"Moved to whiteboard [acct $rt3form_al]",$rt3sys_event);
			rt3f_success(16);																		// success message
		} else {
			$rt3form_upd['status']=$rt3form_batch['move'];
			$rt3form_lg[]=array('code'=>540+$rt3form_batch['move'],'msg'=>"Moved [acct $rt3form_al]");
		}
	}
	if ($rt3form_batch['vn']['del']) {
		$rt3form_upd['vn']=null;
		$rt3form_lg[]=array('code'=>532,'msg'=>"[acct $rt3form_al]");
	} else if ($rt3form_batch['vn']['note']) {
		$rt3form_upd['vn']=$rt3form_batch['vn']['note'];
		$rt3form_lg[]=array('code'=>531,'msg'=>"New note: $rt3form_upd[vn]: [acct $rt3form_al]");
	}
	if ($rt3form_batch['pn']['del']) {
		$rt3form_upd['pn']=null;
		$rt3form_lg[]=array('code'=>534,'msg'=>"[acct $rt3form_al]");
	} else if ($rt3form_batch['pn']['note']) {
		$rt3form_upd['pn']=$rt3form_batch['pn']['note'];
		$rt3form_lg[]=array('code'=>533,'msg'=>"New note: $rt3form_upd[pn]: [acct $rt3form_al]");
	}
	if ($rt3form_upd) {
		$rt3db_table[0]->update (db_sub, $rt3form_upd, "sid IN ($rt3form_slist2)");
		foreach ($rt3form_lg as $v)
			rt3f_logdata($v['code'],$v['msg'],$rt3sys_event);
		rt3f_success(17);
	}
}
?>