<?php
/*******************************************************************************
 * rtpref.php
 *******************************************************************************
 * To set rt.php prefs
 ******************************************************************************/
// *************************************************************** FUNCTIONS ***
// recursive function to create all prefs into one written file
function rt3f_recpref($var, $l=null) {
	if (is_array($var)) {														// if var is array,
		foreach ($var as $k=>$v) {												// go thru each array element
			$lst.=rt3f_recpref($v,$l."['$k']");												
		}
	} else {
		if (!is_numeric($var)) {												// if v is not numeric
			if ($var=='') $var='null';											// if v is not set, v retains null
			else $var="'".addslashes($var)."'";									// sets v to have quotes around it
		}
		$lst.="$".$l."=$var;".NL;
	}
	return $lst;
}
// ******************************************************************** CODE ***
// *** exceptions first ********************************************************
if ($rt3sys_tab==5) {															// events tab
	if ($rt3form_pref['event']['start']!=='') {									// if start time is set
		$rt3l_st=strtotime(date('Y-m-d').$rt3form_pref['event']['start']);		// Add today's date and convert to unix
		$rt3l_st=$rt3time->loc2sys($rt3l_st);									// convert to system time
		$rt3form_pref['event']['start']=date("H:i",$rt3l_st);					// convert back to HH:mm format for pref
	} else $rt3form_pref['event']['start']=null;
	if ($rt3form_pref['event']['dur']['val']!=='') {							// if a value is set in event duration
		if ($rt3form_pref['event']['dur']['unit']=='h')							// if hour is set
			$rt3form_pref['event']['dur']['val']*=60;							// multiply by 60 min
		$rt3l_temp=$rt3form_pref['event']['dur']['val']*60;						// multiply by 60 sec
		unset ($rt3form_pref['event']['dur']);									// unset the whole pref
		$rt3form_pref['event']['dur']=$rt3l_temp;								// reset just the attribute with time
	} else {
		unset ($rt3form_pref['event']['dur']['val'],$rt3form_pref['event']['dur']['unit']);
		$rt3form_pref['event']['dur']=null;
	}
	if ($rt3form_pref['event']['invite']['val']!=='') {							// if a value is set in event invite
		if ($rt3form_pref['event']['invite']['unit']=='h')						// if hour is set
			$rt3form_pref['event']['invite']['val']*=60;						// multiply by 60 min
		$rt3l_temp=$rt3form_pref['event']['invite']['val']*60;					// multiply by 60 sec
		unset ($rt3form_pref['event']['invite']);								// unset the whole pref
		$rt3form_pref['event']['invite']=$rt3l_temp;							// reset just the attribute with time
	} else {
		unset ($rt3form_pref['event']['invite']['val'],$rt3form_pref['event']['invite']['unit']);
		$rt3form_pref['event']['invite']=null;
	}
	if ($rt3form_pref['event']['sub']['val']!=='') {							// if a value is set in event subscription
		if ($rt3form_pref['event']['sub']['unit']=='h')							// if hour is set
			$rt3form_pref['event']['sub']['val']*=60;							// multiply by 60 min
		$rt3l_temp=$rt3form_pref['event']['sub']['val']*60;						// multiply by 60 sec
		unset ($rt3form_pref['event']['sub']);									// unset the whole pref
		$rt3form_pref['event']['sub']=$rt3l_temp;								// reset just the attribute with time
	} else {
		unset ($rt3form_pref['event']['sub']['val'],$rt3form_pref['event']['sub']['unit']);
		$rt3form_pref['event']['sub']=null;
	}
	if ($rt3form_pref['event']['with']['val']!=='') {							// if a value is set in event withdrawl
		if ($rt3form_pref['event']['with']['unit']=='h')						// if hour is set
			$rt3form_pref['event']['with']['val']*=60;							// multiply by 60 min
		$rt3l_temp=$rt3form_pref['event']['with']['val']*60;					// multiply by 60 sec
		unset ($rt3form_pref['event']['with']);									// unset the whole pref
		$rt3form_pref['event']['with']=$rt3l_temp;								// reset just the attribute with time
	} else {
		unset ($rt3form_pref['event']['with']['val'],$rt3form_pref['event']['with']['unit']);
		$rt3form_pref['event']['with']=null;
	}
	// add checks for time
}
// *** move form to variables **************************************************
foreach ($rt3form_pref as $k=>$v) {
	$rt3l_var="rt3pref_$k";
	$$rt3l_var=$v;
}
// *** move variables to file **************************************************
$rt3form_prefixes=array('news','TOS','disp','format','track','view','group','system','menu','event','dkp','acct','log');
$rt3form_file="<?php".NL;
$rt3form_file.="// *** rt.php is auto generated. do not modify *** ".NL;
$rt3form_file.="define('rt3pref_ver','". RT_VERSION_INT ."');".NL;
foreach ($rt3form_prefixes as $v) {
	$rt3form_fix="rt3pref_$v";
	$rt3form_file.=rt3f_recpref($$rt3form_fix,$rt3form_fix);
}
$rt3form_file.="?>";
// *** write file to rt.php ****************************************************
if (!$rt3l_file=fopen(RT_LU."rt.php",'w'))
	rt3f_criticalerror(1006);
if (fwrite($rt3l_file,$rt3form_file)===FALSE) 
	rt3f_criticalerror(1006);
fclose($rt3l_file);
rt3f_success(39);
?>