<?php 
/*******************************************************************************
 * localset.php
 * *****************************************************************************
 * Adjusts localized settings
 ******************************************************************************/
// *** set up vars for processing **********************************************
$rt3form_cat=rt3f_getkey($rt3form_local);													// category for lookup
if (isset($rt3form_local[$rt3form_cat]['new']))											// if new is sent
	$rt3form_new=$rt3form_local[$rt3form_cat]['new'];									// all the new data
if (isset($rt3form_local[$rt3form_cat]['delete']))										// if delete is sent
	$rt3form_del=$rt3form_local[$rt3form_cat]['delete'];								// all the delete arrays
$rt3form_list=$rt3form_local[$rt3form_cat]['list'];									// list of keys
$rt3form_ctlist=count($rt3form_list);														// count for delete 
switch ($rt3form_cat) {																		// go thru category, set appropriate table
	case 'status':
	case 'location':
	case 'group':
	case 'rt':
		$rt3form_tbl=0;
		$rt3form_tn=db_loc;
		break;
	case 'class':
	case 'role':
		$rt3form_tbl=1;
		$rt3form_tn=db_acctk;
		break;
}
// *** see about new keys ******************************************************
if (isset($rt3form_new)) {
	if ($rt3form_new['sn']!='' && $rt3form_new['ln']!='') {							// both are valid
		if ($rt3form_cat!='group' && $rt3form_cat!='rt') {								// not group or RT
			// *** check if is a duplicate ****************************************
			if ($rt3db_table[$rt3form_tbl]->selectrec($rt3form_tn,'*',"`cat`='$rt3form_cat' 
			AND `sn`='".$rt3form_new['sn']."'")) {											// if exists error
				rt3f_error(1401);
				return;
			}
			$rt3form_list[($rt3form_new['sn'])]['sn']=$rt3form_new['sn'];
			$rt3form_list[($rt3form_new['sn'])]['ln']=$rt3form_new['ln'];
		} else {
			$rt3form_list['100']['sn']=$rt3form_new['sn'];								// set this for sort later
			$rt3form_list['100']['ln']=$rt3form_new['ln'];
			$rt3form_new['sn']='100';															// temporary put in rank 100 
		}
		$rt3form_new['cat']=$rt3form_cat;													// set into cat
		$rt3db_table[$rt3form_tbl]->insert($rt3form_tn,$rt3form_new);				// add into table.
		rt3f_logdata(112,"Insert $rt3form_new[ln] in $rt3form_cat");				// log it
		$rt3form_dirty=1;																			// set dirty flag to new
		$rt3form_ctlist++;
	} else if ( !(!$rt3form_new['sn'] && !$rt3form_new['ln'])) {					// else if one is set
		rt3f_error(1402);																				// error
		return;
	}
}
// *** check for delete ********************************************************
if (isset($rt3form_del)) {																		// delete is set
	if (count ($rt3form_del) == $rt3form_ctlist) {										// if count is same as status
		rt3f_error(1403);																				// error
		return;
	}
	for ($i=0; $i<count($rt3form_del); $i++) {											// go thru array
		unset($rt3form_list[($rt3form_del[$i])]);											// unset it from list	
		$rt3form_del[$i]="'".$rt3form_del[$i]."'";										// put it in single quotes
	}
	$rt3form_dellist=implode(', ',$rt3form_del);											// make a list of , 
	$rt3db_table[$rt3form_tbl]->delete($rt3form_tn,"`cat`='$rt3form_cat' AND `sn` IN (".$rt3form_dellist.")");
	rt3f_logdata(114,"Deleted $rt3form_cat : $rt3form_dellist");					// log data
	$rt3form_dirty+=2;																			// set dirty flag
	// *** check if statuses are affected (rank, etc)
}
// *** check for update ********************************************************
// *** check if there is a dup short name ***
if ($rt3form_cat !='status') {																// if this is status, skip
	foreach ($rt3form_list as $k=>$v) {													// go thru each list as key and elem
		if (!$v['sn'] || !$v['ln']) {
			rt3f_error(1406);
			return;
		}
		if ($v['sn']!= $k) {																		// if the sn (key) changed names
			$rt3l_tk=$v['sn'];																	// get key name it points to
			if (isset($rt3form_list[$rt3l_tk]) && $rt3form_list[$rt3l_tk]['sn']==$rt3l_tk) { // if key points to another one that already has same name
				rt3f_error(1404, $rt3l_tk);																		// error
				return;
			}
		}
	}
}
// *** get the master list ***
$rt3form_masterlist=$rt3db_table[$rt3form_tbl]->select($rt3form_tn,'*',"`cat`='$rt3form_cat'");
if (count($rt3form_masterlist)!=count($rt3form_list)) {								// if counts aren't the same
	rt3f_criticalerror(1405);																		// critical error out
}
// *** make comparison ***
for ($i=0; $i<count($rt3form_masterlist); $i++) {										// loop through each elem
	$rt3form_master[($rt3form_masterlist[$i]['sn'])]=$rt3form_masterlist[$i]['ln']; // make easy to see list for keys
}
// *** order the labels for rank ***
if ($rt3form_cat=='group' || $rt3form_cat=='rt') {
	foreach ($rt3form_list as $k=>$v) 														// cycle thru list
		$rt3l_temparr[$k]=$v['sn'];															// copy orig sn and new sn in temp arr
	asort($rt3l_temparr);																		// sort this temp list
	$i=0;																								// set init value to 0
	foreach ($rt3l_temparr as $k=>$v)														// cycle thru temp arr
		$rt3form_list[$k]['sn']=++$i;															// increment i, then assign to sn
}
// *** cycle thru each category see if there is a change ***
foreach ($rt3form_master as $k=>$v) {
	if ($v!=$rt3form_list[$k]['ln']){														// see if long name is different
		$rt3form_upd[1][]=$rt3form_list[$k]['ln'];										// make array for it
		$rt3form_upf[1][]=$k;
	}
	if ($k!=$rt3form_list[$k]['sn']) {														// see if short name 
		if (isset($rt3form_master[($rt3form_list[$k]['sn'])])) {						// if already set, use temp
			$rt3form_upd[2][]=$rt3form_list[$k]['sn']."00";								// temp name. *** note need error correction to make sure this is 20ch or less
			$rt3form_upd[3][]=$rt3form_list[$k]['sn'];
			$rt3form_upf[2][]=$k;
			$rt3form_upf[3][]=$rt3form_list[$k]['sn']."00";
		}
		else {																						// set it directly
			$rt3form_upf[2][]=$k;
			$rt3form_upd[2][]=$rt3form_list[$k]['sn'];
		}
	}
}
if (isset($rt3form_upd[1])) {																	// if there is 1+ desc change
	$rt3l_t=$rt3form_upd[1];																	// assign to temp var for shortcut
	for ($i=0; $i<count($rt3l_t); $i++)														// cycle thru list and update in db
		$rt3db_table[$rt3form_tbl]->update($rt3form_tn,"`ln`='".addslashes($rt3l_t[$i])."'","`cat`='$rt3form_cat' AND `sn`='".$rt3form_upf[1][$i]."'");
	$rt3form_dirty=3;
}
if (isset($rt3form_upd[2])) {																	// if 1+ short name desc
	$rt3form_dirty=3;
	$rt3l_t1a=$rt3form_upd[2];																	// assign to temp var for shortcut
	$rt3l_t1b=$rt3form_upf[2];																	// assign to temp var for shortcut
	if (isset($rt3form_upd[3])) {
		$rt3l_t2a=$rt3form_upd[3];																	// assign to temp var for shortcut
		$rt3l_t2b=$rt3form_upf[3];																	// assign to temp var for shortcut
	}
	// *** change names in other tables *****************************************
	switch ($rt3form_cat) {																	// get category
		case 'role':
			$rt3form_ta[]=array ('id'=>0, 'tbl'=>db_sub, 'col'=>'role');
			$rt3form_ta[]=array ('id'=>1, 'tbl'=>db_char, 'col'=>'role');
			break;
		case 'class':
			$rt3form_ta[]=array ('id'=>1, 'tbl'=>db_char, 'col'=>'class');
			break;
		case 'location':
			$rt3form_ta[]=array ('id'=>0, 'tbl'=>db_event, 'col'=>'loc');
			break;
		case 'group':
			$rt3form_ta[]=array ('id'=>0, 'tbl'=>db_accts, 'col'=>'grank');
			break;
		case 'rt':
			$rt3form_ta[]=array ('id'=>0, 'tbl'=>db_priv, 'col'=>'level');
			$rt3form_ta[]=array ('id'=>1, 'tbl'=>db_char, 'col'=>'rtrank');
			break;
	}
	for ($i=0; $i<count($rt3l_t1a); $i++) {												// change in current table
		$rt3db_table[$rt3form_tbl]->update($rt3form_tn,"`sn`='".$rt3l_t1a[$i]."'","`cat`='$rt3form_cat' AND `sn`='".$rt3form_upd[2][$i]."'");
		for ($j=0; $j<count($rt3form_ta); $j++) {											// change in affected tables
			$rt3db_table[($rt3form_ta[$j]['id'])]->update($rt3form_ta[$j]['tbl'],"`".$rt3form_ta[$j]['col']."`='".$rt3l_t1a[$i]."'","`".$rt3form_ta[$j]['col']."`='".$rt3form_upf[2][$i]."'");
		}
	}
	if (isset($rt3l_t2a)) {
		for ($i=0; $i<count($rt3l_t2a); $i++) {												// change in current table
			$rt3db_table[$rt3form_tbl]->update($rt3form_tn,"`sn`='".$rt3l_t2a[$i]."'","`cat`='$rt3form_cat' AND `sn`='".$rt3form_upd[3][$i]."'");
			for ($j=0; $j<count($rt3form_ta); $j++) {											// change in affected tables
				$rt3db_table[($rt3form_ta[$j]['id'])]->update($rt3form_ta[$j]['tbl'],"`".$rt3form_ta[$j]['col']."`='".$rt3l_t2a[$i]."'","`".$rt3form_ta[$j]['col']."`='".$rt3form_upf[3][$i]."'");
			}
		}
	}
}
rt3f_success ($rt3form_dirty+32);															// make success message
return;	
?>