<?php 
/*******************************************************************************
 * group.php
 * *****************************************************************************
 * processes group rank and active status changes
 ******************************************************************************/
if (!$rt3form_list) {															// no accounts selected
	rt3f_error(1250);															// error
	return;
}
// *** check if self is in list ************************************************
for ($i=0; $i<count($rt3form_list); $i++) {										// cycle thru list
	if ($rt3form_list[$i]==$rt3user) {											// if in list
		rt3f_error(1251);														// error
		return;
	}
}
$rt3form_alist=implode(", ",$rt3form_list);										// make acct list
if ($rt3form_priv['delete']) {													// if delete
	include RT_LM."deleteac.php";
	rt3f_deleteacct($rt3form_list);
} else {	
	if ($rt3form_priv['inactive']) {											// inactive button set
		$rt3form_upd['active']=0;												// set inactive
		$rt3form_log[]=array('code'=>231,'msg'=>"Deactivated [acct $rt3form_alist]");
		$rt3form_sc=19;															// set success code
	} else if ($rt3form_priv['active']) {										// active button set
		$rt3form_upd['active']=1;												// set inactive
		$rt3form_log[]=array('code'=>230,'msg'=>"Activated [acct $rt3form_alist]");
		$rt3form_sc=18;															// set success code
	} else if ($rt3form_priv['modify']) {										// Modify button set (ranks)
		if (!$rt3form_priv['grank'] && !$rt3form_priv['rtrank']){
			rt3f_error(1252);
			return;
		}
		if ($rt3form_priv['grank']) {
			$rt3form_upd['grank']=$rt3form_priv['grank'];
			$rt3form_log[]=array('code'=>234,'msg'=>"Changed rank to [grank {$rt3form_priv['grank']}] [acct $rt3form_alist]");
		}
		if ($rt3form_priv['rtrank']) {
			$rt3form_upd['rtrank']=$rt3form_priv['rtrank'];
			$rt3form_log[]=array('code'=>235,'msg'=>"Changed rank to [rtrank {$rt3form_priv['rtrank']}] [acct $rt3form_alist]");
		}
		$rt3form_sc=21;															// set success code
	}
	$rt3db_table[0]->update(db_accts, $rt3form_upd, "aid IN ($rt3form_alist)");
	foreach ($rt3form_log as $v) {
		foreach ($rt3form_list as $v2) {
			rt3f_logdata($v['code'],$v['msg'], $v2);
		}
	}
	rt3f_success($rt3form_sc);
}
?>