<?php 
/*******************************************************************************
 * events.php
 * *****************************************************************************
 * processes new and current event details
 ******************************************************************************/
// *** check if new event ******************************************************
if (isset($rt3form_event['add'])) {
	$rt3sys_view='main';														// set view to main
	if (!$rt3form_event['name']) {												// no name
		rt3f_error(1307); return;
	}
	// *** checking times *******************************************************
	if (!$rt3form_times['date']) {												// no start date
		rt3f_error(1301); return;
	}
	if (!$rt3form_times['ts']) {												// no start time set
		if (is_null($rt3pref_event['start'])){									// not in pref
			rt3f_error(1302); return;											// error
		} else {																// use pref
			$rt3form_sub['ts']=$rt3form_times['date']." ".$rt3pref_event['start'];	// use system pref
			$rt3form_sub['ts']=strtotime($rt3form_sub['ts']);					// conv to unix 
			$rt3form_sub['ts']=$rt3time->get_DBtime($rt3time->sys2loc($rt3form_sub['ts']));	// conv to DB in LOCAL time
		}
	} else {
		$rt3form_sub['ts']=$rt3form_times['date'].' '.$rt3form_times['ts'];		// parse date/time
	}
	if (!$rt3form_times['te']) {												// no end time set
		if (is_null($rt3pref_event['dur'])){									// not in pref
			rt3f_error(1303); return;											// error
		} else {
			$rt3form_sub['te']=strtotime($rt3form_sub['ts']);					// conv to unix
			$rt3form_sub['te']=$rt3time->get_DBtime($rt3time->addtime($rt3pref_event['dur'],'s',$rt3form_sub['te'])); // conv to DB in local time using pref
		}
	} else {																							
		$rt3form_sub['te']=$rt3form_times['date'].' '.$rt3form_times['te'];		// parse date/time
		if ($rt3form_sub['te']<$rt3form_sub['ts']) {							// start time is later than end?
			$rt3form_sub['te']=strtotime($rt3form_sub['te']);					// conv to unix
			$rt3form_sub['te']=$rt3time->get_DBtime($rt3time->addtime(1,'d',$rt3form_sub['te'])); // add a day to make end time later
		}
	}
	if (!$rt3form_times['ti']) {												// no end time set
		if (is_null($rt3pref_event['invite'])){									// not in pref
			rt3f_error(1304); return;											// error
		} else {
			$rt3form_sub['ti']=strtotime($rt3form_sub['ts']);					// conv to unix
			$rt3form_sub['ti']=$rt3time->get_DBtime($rt3time->addtime(-$rt3pref_event['invite'],'s',$rt3form_sub['ti'])); // conv to DB in local time using pref
		}
	} else {																							
		$rt3form_sub['ti']=$rt3form_times['date'].' '.$rt3form_times['ti'];		// parse date/time
		if ($rt3form_sub['ti']>$rt3form_sub['ts']) {							// start time is later than end?
			$rt3form_sub['ti']=strtotime($rt3form_sub['ti']);					// conv to unix
			$rt3form_sub['ti']=$rt3time->get_DBtime($rt3time->addtime(-1,'d',$rt3form_sub['ti'])); // add a day to make end time later
		}
	}
	if (!$rt3form_times['tcs']) {												// no end time set
		if (is_null($rt3pref_event['sub'])){									// not in pref
			rt3f_error(1305); return;											// error
		} else {
			$rt3form_sub['tcs']=strtotime($rt3form_sub['ts']);					// conv to unix
			$rt3form_sub['tcs']=$rt3time->get_DBtime($rt3time->addtime(-$rt3pref_event['sub'],'s',$rt3form_sub['tcs'])); // conv to DB in local time using pref
		}
	} else {																							
		$rt3form_sub['tcs']=$rt3form_times['date'].' '.$rt3form_times['tcs'];	// parse date/time
		if ($rt3form_sub['tcs']>$rt3form_sub['ts']) {							// start time is later than end?
			$rt3form_sub['tcs']=strtotime($rt3form_sub['tcs']);					// conv to unix
			$rt3form_sub['tcs']=$rt3time->get_DBtime($rt3time->addtime(-1,'d',$rt3form_sub['tcs'])); // add a day to make end time later
		}
	}
	if (!$rt3form_times['tcw']) {												// no end time set
		if (is_null($rt3pref_event['with'])){									// not in pref
			if ($rt3pref_event['close']) $rt3form_sub['tcw']=$rt3form_sub['tcs'];	// if close at same time, use tcs
			else {
				rt3f_error(1306); return;										// error
			}
		} else {
			$rt3form_sub['tcw']=strtotime($rt3form_sub['ts']);					// conv to unix
			$rt3form_sub['tcw']=$rt3time->get_DBtime($rt3time->addtime(-$rt3pref_event['with'],'s',$rt3form_sub['tcw'])); // conv to DB in local time using pref
		}
	} else {																							
		$rt3form_sub['tcw']=$rt3form_times['date'].' '.$rt3form_times['tcw'];	// parse date/time
		if ($rt3form_sub['tcw']>$rt3form_sub['ts']) {							// start time is later than end?
			$rt3form_sub['tcw']=strtotime($rt3form_sub['tcw']);					// conv to unix
			$rt3form_sub['tcw']=$rt3time->get_DBtime($rt3time->addtime(-1,'d',$rt3form_sub['tcw'])); // add a day to make end time later
		}
	}
	foreach ($rt3form_sub as $k=>$v) 											// convert times to SYSTEM time and in DB format
		$rt3form_sub[$k]=$rt3time->get_DBtime($rt3time->loc2sys(strtotime($v)));
	// *** rest of the form *****************************************************
	$arr=array('name','loc','level','vn','pn','leader');
	for ($i=0; $i<count($arr); $i++)
		$rt3form_sub[($arr[$i])]=$rt3form_event[($arr[$i])];
	$rt3form_sub['total']=$rt3form_roles[0];
	if (isset($rt3form_roles[1])) {
		for ($i=1; $i<count($rt3form_roles)+1; $i++) {
			if ($i>1) $rt3form_sub['role'].="/";
			$rt3form_sub['role'].="$rt3form_roles[$i]";
		}
		
	}
	$rt3form_eid=$rt3db_table[0]->insone(db_event,$rt3form_sub,'eid',"`ts`='$rt3form_sub[ts]' AND `name`='$rt3form_sub[name]'");
	// *** check for leader ****************************************************
	if ($rt3form_sub['leader']) {
		$rt3form_subadd['aid']=$rt3form_sub['leader'];
		$rt3form_subadd['cid']=$rt3user_info['cid'];
		$rt3form_subadd['eid']=$rt3form_eid;
		$rt3form_subadd['role']=$rt3user_info['role'];
		$rt3form_subadd['status']=1;
		$rt3db_table[0]->insert(db_sub, $rt3form_subadd);						// add leader to subscription table
	}
	// check for leader, insert if assigned
	rt3f_logdata(301,"[Event $rt3form_eid] Created $rt3form_sub[name] | $rt3form_sub[ts]",$rt3form_eid);
	rt3f_success(4);
	return;
}
// *** check for delete ********************************************************
if (isset($rt3form_event['delete'])) {
	$rt3form_delevent=$rt3form_system['event'];									// event ID to delete
	$rt3form_evt=$rt3db_table[0]->select(db_event,'*',"eid=$rt3form_delevent"); // get event details
	// delete all subscriptions first
	$rt3db_table[0]->delete(db_sub,"`eid`=$rt3form_delevent");					// delete event subscriptions
	$rt3db_table[0]->delete(db_event,"`eid`=$rt3form_delevent");				// delete event details
	$rt3db_table[0]->delete(db_log,"`ref`=$rt3form_delevent AND (`code`>309 AND `code`<610)"); // delete log entries in event
	$rt3form_desc="[Event $rt3form_delevent] Deleted ".$rt3form_evt[0]['name']." | <time db='db'>".$rt3form_evt[0]['ts']."</time>";
	rt3f_logdata(304,$rt3form_desc);
	rt3f_success(5);
	$rt3sys_view='main';														// set view to main
	return;
}
// *** set up view for event ***************************************************
$rt3sys_view=$rt3form_system['view'];
$rt3sys_event=$rt3form_system['event'];
$rt3sys_tab=$rt3form_system['tabno'];
$rt3form_evt0=$rt3db_table[0]->select(db_event,'*',"eid=$rt3sys_event");		// get event details
$rt3form_evt=$rt3form_evt0[0];
// *** Check if roles were changed *********************************************
if ($rt3form_roles) {															// if roles were changed
	$rt3form_roletot=$rt3form_roles[0];											// get form total out
	unset ($rt3form_roles[0]);													// unset it so it doesn't get confused
	unset ($rt3form_roles['submit']);											// also unset submit button
	$rt3form_rolect=implode('/',$rt3form_roles);								// implode into one string with /
	if ($rt3form_roletot!=$rt3form_evt['total']) {								// if total changed, note in book
		$rt3form_log[0]['desc']="Changed from $rt3form_evt[total] to $rt3form_roletot";
		$rt3form_log[0]['code']=330;											// code for log
		$rt3form_arr['total']=$rt3form_roletot;									// array for update
	}
	if ($rt3form_rolect!=$rt3form_evt['role']) {								// if counts changed, note in book
		$rt3form_log[1]['desc']="Changed from $rt3form_evt[role] to $rt3form_rolect";
		$rt3form_log[1]['code']=331;											// code for log
		$rt3form_arr['role']=$rt3form_rolect;									// array for update
	}
} 
// *** check if event details were changed *************************************
if ($rt3form_event) {															// if event was set (should be)
	if ($rt3form_event['name']!=$rt3form_evt['name']) {							// if name was changed, set it
		$rt3form_log[0]['desc']="Changed from $rt3form_evt[name] to $rt3form_event[name]";
		$rt3form_log[0]['code']=303;											// code for log
		$rt3form_arr['name']=$rt3form_event['name'];							// array for update
	}
	if ($rt3form_event['loc']!=$rt3form_evt['loc']) {							// if name was changed, set it
		$rt3form_log[1]['desc']="Changed from $rt3form_evt[loc] to $rt3form_event[loc]";
		$rt3form_log[1]['code']=325;											// code for log
		$rt3form_arr['loc']=$rt3form_event['loc'];								// array for update
	}
	if ($rt3form_event['level']!=$rt3form_evt['level']) {						// if name was changed, set it
		$rt3form_log[2]['desc']="Changed from $rt3form_evt[level] to $rt3form_event[level]";
		$rt3form_log[2]['code']=332;											// code for log
		$rt3form_arr['level']=$rt3form_event['level'];							// array for update
	}
	if ($rt3form_event['vn']!=$rt3form_evt['vn']) {								// if name was changed, set it
		$rt3form_log[3]['desc']="Changed from $rt3form_evt[vn] to $rt3form_event[vn]";
		$rt3form_log[3]['code']=321;											// code for log
		$rt3form_arr['vn']=$rt3form_event['vn'];								// array for update
	}
	if (isset($rt3form_event['pn'])&& $rt3form_event['pn']!=$rt3form_evt['pn']) {	// if name was changed, set it
		$rt3form_log[4]['desc']="Changed from $rt3form_evt[pn] to $rt3form_event[pn]";
		$rt3form_log[4]['code']=322;											// code for log
		$rt3form_arr['pn']=$rt3form_event['pn'];								// array for update
	}
	if ($rt3form_event['leader']!=$rt3form_evt['leader']) {						// if leader was changed, set it
		$rt3form_log[5]['desc']="Changed from $rt3form_evt[leader] to $rt3form_event[leader]";
		$rt3form_log[5]['code']=323;											// code for log
		$rt3form_arr['leader']=$rt3form_event['leader'];						// array for update
		if ($rt3form_event['leader']) {											// move leader to s1
			$rt3db_table[0]->update(db_sub,array('status'=>1),"eid=$rt3sys_event AND aid=$rt3form_event[leader]");
		}
	}
}
// *** check if times are modified *********************************************
if ($rt3form_times) {
	// *** make full times in unix form ***
	$rt3form_tm['ts']=strtotime("$rt3form_times[date] $rt3form_times[ts]");
	$rt3form_tm['te']=strtotime("$rt3form_times[date] $rt3form_times[te]");
	$rt3form_tm['ti']=strtotime("$rt3form_times[date] $rt3form_times[ti]");
	$rt3form_tm['tcs']=strtotime("$rt3form_times[date] $rt3form_times[tcs]");
	$rt3form_tm['tcw']=strtotime("$rt3form_times[date] $rt3form_times[tcw]");
	// *** check if tcw is closed same time as tcs
	if ($rt3pref_event['close']) $rt3form_tm['tcw']=$rt3form_tm['tcs'];
	// *** check if times are invalid compared to ts ***
	if ($rt3form_tm['te']<$rt3form_tm['ts'])
		$rt3form_tm['te']=$rt3time->addtime(1,'d',$rt3form_tm['te']);
	if ($rt3form_tm['ti']>$rt3form_tm['ts'])
		$rt3form_tm['ti']=$rt3time->addtime(-1,'d',$rt3form_tm['ti']);
	if ($rt3form_tm['tcs']>$rt3form_tm['ts'])
		$rt3form_tm['tcs']=$rt3time->addtime(-1,'d',$rt3form_tm['tcs']);
	if ($rt3form_tm['tcw']>$rt3form_tm['ts'])
		$rt3form_tm['tcw']=$rt3time->addtime(-1,'d',$rt3form_tm['tcw']);
	// *** convert times to system in DB format ***
	foreach ($rt3form_tm as $k=>$v) 
		$rt3form_tm[$k]=$rt3time->get_DBtime($rt3time->loc2sys($v));
	// *** compare to DB times ***
	if ($rt3form_tm['ts']!=$rt3form_evt['ts']) {								// start time not same?
		$rt3form_log[10]['desc']="Changed from $rt3form_evt[ts] to $rt3form_tm[ts]";
		$rt3form_log[10]['code']=311;											// code for log
		$rt3form_arr['ts']=$rt3form_tm['ts'];									// array for update
	}
	if ($rt3form_tm['te']!=$rt3form_evt['te']) {								// start time not same?
		$rt3form_log[11]['desc']="Changed from $rt3form_evt[te] to $rt3form_tm[te]";
		$rt3form_log[11]['code']=312;											// code for log
		$rt3form_arr['te']=$rt3form_tm['te'];									// array for update
	}
	if ($rt3form_tm['ti']!=$rt3form_evt['ti']) {								// start time not same?
		$rt3form_log[12]['desc']="Changed from $rt3form_evt[ti] to $rt3form_tm[ti]";
		$rt3form_log[12]['code']=313;											// code for log
		$rt3form_arr['ti']=$rt3form_tm['ti'];									// array for update
	}
	if ($rt3form_tm['tcs']!=$rt3form_evt['tcs']) {								// start time not same?
		$rt3form_log[13]['desc']="Changed from $rt3form_evt[tcs] to $rt3form_tm[tcs]";
		$rt3form_log[13]['code']=314;											// code for log
		$rt3form_arr['tcs']=$rt3form_tm['tcs'];									// array for update
	}
	if ($rt3form_tm['tcw']!=$rt3form_evt['tcw']) {								// start time not same?
		if ($rt3form_evt['tcw']!=$rt3form_evt['tcs'] || $rt3form_tm['tcw']!=$rt3form_tm['tcs']) { // if times were not both changed same time
		$rt3form_log[14]['desc']="Changed from $rt3form_evt[tcw] to $rt3form_tm[tcw]";
		$rt3form_log[14]['code']=315;											// code for log
		}
		$rt3form_arr['tcw']=$rt3form_tm['tcw'];									// array for update
	}
}
// *** check if times are changed **********************************************
//if 
// *** update form and log event ***********************************************
if ($rt3form_arr) {																// if something to update
	$rt3db_table[0]->update(db_event,$rt3form_arr,"eid=$rt3sys_event");			// update event table
	foreach ($rt3form_log as $v) 												// going through status/change
		rt3f_logdata($v['code'],$v['desc'],$rt3sys_event);						// add in log
	$rt3l_sc=6;																	// set success code to 6
} else $rt3l_sc=7;																// nothing to update, set success code
rt3f_success($rt3l_sc);															// put success on screen
?>