<?php
/*******************************************************************************
 * time.php
 *******************************************************************************
 * generates time for RT
 ******************************************************************************/
class rt3cl_time {
	private $ts;
	private $sys_offset;
	private $user_offset;
	private $datef;
	private $timef;
	
	// constructor. sets up system time
	public function __construct() {
// test only
		$this->ts=time();
		$this->datef="Y-m-d";
		$this->timef="H:i";
		$this->sys_offset=0;
		$this->user_offset=0;
	}
	// set variables
	public function setSTime($tm) {$this->ts=strtotime($tm);}
	public function set_soffset($i) {$this->sys_offset=$i;}
	public function set_loffset($i) {$this->user_offset=$i;}
	public function set_datef($i) {$this->datef=$i;}
	public function set_timef($i) {$this->timef=$i;}
	// simple conversion times. in: unix, out: unix
	public function loc2sys($tm){return $tm-($this->user_offset)*3600;}
	public function sys2loc($tm){return $tm+($this->user_offset)*3600;}
	// get timestamps (unix)
	public function get_systs() {
		return (($this->ts)+($this->sys_offset)*3600);
	}
	public function get_locts() {
		return (($this->get_systs())+($this->user_offset)*3600);
	}
	// get time format functions. format used 
	public function get_sysdate($format=null) {
		if (is_null($format)) $format=$this->datef;
		$tm=$this->get_systs();
		return date($format,$tm);
	}
	public function get_systime($format=null) {
		if (is_null($format)) $format=$this->timef;
		return $this->get_sysdate($format);
	}
	public function get_locdate($format=null) {
		if (is_null($format)) $format=$this->datef;
		$tm=$this->get_locts();
		return date($format,$tm);
	}
	public function get_loctime($format=null) {
		if (is_null($format)) $format=$this->timef;
		return $this->get_locdate($format);
	}
	// gets DB time
	public function get_DBtime($ts=null) {
		$str="Y-m-d H:i:s";
		if (is_null($ts)) return $this->get_sysdate($str);
		return date($str, $ts);
	}
	// format a unix time stamp to date/time
	public function fudate($ts) {return date ($this->datef, $ts);}
	public function futime($ts) {return date ($this->timef, $ts);}
	// format a time based on date str
	public function fdate($ts) {return date ($this->datef, strtotime($ts));}
	public function ftime($ts) {return date ($this->timef, strtotime($ts));}
	// format a time to local based on date str
	public function fldate($ts) {return date($this->datef, $this->sys2loc($ts));}
	public function fltime($ts) {return date($this->timef, $this->sys2loc($ts));}
	// compare times. Takes unix timestamp. If 2nd is null, it uses system time
	// 0: same, positive means TS1 is later
	public function compare ($ts1, $ts2=null) {
		if (is_null($ts2)) $ts2=$this->get_systs();
		return $ts1-$ts2;
	}
	// add time. time unit is s/m/h/d
	public function addtime ($timeamt, $timeunit='s', $timestamp=null) {
		if (is_null($timestamp)) $timestamp=$this->get_systs();
		switch ($timeunit) {
			case 'd':
				$timeamt*=24;
			case 'h':
				$timeamt*=60;
			case 'm':
				$timeamt*=60;
			case 's':
				$timeamt*=1;
		}
		$timestamp+=$timeamt;
		return $timestamp;
	}
	// *** version 3.1 functions ***********************************************
	// *** basic functions *****************************************************
	// retrieves time based on mode 0/sys 1/loc 2/sys
	public function r_time($mode=0){
		return $this->m_conv($this->ts, $mode);								// uses server time, puts it in conversion and returns it
	}
	// *** convert times. $time: unix, $ft: from $tt: to.  ft/tt: 0/system 1/local 2/server
	public function m_conv($time, $ft=0, $tt=0) {
		if ($ft!=$tt) {															// not same time
			if ($ft==2) $time+=(3600*$this->sys_offset);						// server to sys
			if ($tt==1) $time+=(3600*$this->user_offset);						// sys or server to local
			if ($ft==1) $time-=(3600*$this->user_offset);						// local to sys
			if ($tt==2) $time-=(3600*$this->sys_offset);						// local or sys to server
		}
		return $time;
	}
	// gives the time or date format string (date if t=0, otherwise time)
	public function r_format($t=0) {
		if ($t) return $this->timef;
		else return $this->datef;
	}
	// *** retrieve functions **************************************************
	public function r_server() {return $this->r_time(2);}						// returns server time
	public function r_sys() {return $this->r_time(0);}						// returns system time
	public function r_local() {return $this->r_time(1);}						// returns local time
	public function r_fdate() {return $this->r_format(0);}					// returns date format
	public function r_ftime() {return $this->r_format(1);}					// returns time format
	public function r_fdb() {return "Y-m-d H:i";}								// returns DB format
	public function r_fdbd() {return "Y-m-d";}								// returns DB (HTML5) date
	public function r_fdbt() {return "H:i";}									// returns DB (HTML5) time
	// *** set functions *******************************************************
	// *** set base time (or use server time if null)
	public function s_time($tm=null) {	
		if (is_null($tm)) $tm=time();											// if not passed in, use server time
		elseif (!is_numeric($tm)) $tm=$this->m_unix($tm);						// if not unix timestamp, convert first
		$this->ts=$tm;															// set server time
	}
	// *** sets offset.  amt: amount of offset. local-0:system offset 1: local offset
	public function s_offset($amt=0, $local=0){
		if ($local) $this->user_offset=$amt;
		else $this->sys_offset=$amt;
	}
	// *** sets format: $st is string, t 0: date t 1: time
	public function s_format($st, $t=0){
		if ($t) $this->timef=$st;
		else $this->datef=$st;
	}
	// *** format functions ****************************************************
	// *** formats time $st is format string (or loc date/time), ts is timestamp, or sys time in unix
	// *** ts also takes in 0/system 1/local 2/server time
	public function f_dt($st=null, $ts=null){
		if (is_null($ts) || $ts==0) $ts=$this->r_sys();
		if ($ts==1) $ts=$this->r_local();
		if ($ts==2) $ts=$this->r_server();
		if (is_null($st)) $st=$this->r_fdate()." ".$this->r_ftime();
		if (!is_numeric($ts)) $ts=$this->m_unix($ts);
		return date($st, $ts);
	}
	// *** formats date   $ts takes on 0/sys 1/local 2/server 
	public function f_date($st=null, $ts=null) {
		if (is_null($st)) $st=$this->r_fdate();
		if (is_null($ts)) $ts=$this->r_sys();
		return $this->f_dt($st, $ts);
	}
	// *** formats time   $ts takes on 0/sys 1/local 2/server 
	public function f_time($st=null, $ts=null) {
		if (is_null($st)) $st=$this->r_ftime();
		if (is_null($ts)) $ts=$this->r_sys();
		return $this->f_dt($st, $ts);
	}
	public function m_unix($tm){return strtotime($tm);}
	public function m_tosys($tm=null) {
		// test
	}
}
$rt3time=new rt3cl_time;
if ($rt3sys_demo)
	$rt3time->setSTime('2009-07-12 22:05:00');
$rt3time->set_soffset($rt3pref_event['offset']);
?>