<?php
/*******************************************************************************
 * pageinfo.php
 *******************************************************************************
 * Contains the information for generating HTML pages.
 * DO NOT ALTER THIS PAGE!
 ******************************************************************************/
// *** to get title correct ****************************************************
$rt3sys_grouploc="$rt3pref_group[name]";										// picks up group name
if ($rt3pref_group[loc]) $rt3sys_grouploc.=" - $rt3pref_group[loc]";			// picks up group loc if used
if ($rt3sys_titletest) $rt3l_t="$rt3sys_titletest | ";							// if test is listed, add to title
if ($rt3sys_grouploc) $rt3l_t.="$rt3sys_grouploc | ";							// adds group name/loc to title (if set)
$rt3l_t.="$rt3sys_viewname | RaidTracker version ".RT_VERSION;					// view and RT name/ver to title
if (!file_exists(RT_LT."$rt3sys_theme/rt-style.css")) {							// checks if theme is available
	$rt3sys_theme="bluesocial";													// sets default to bluesocial if not
	if (!file_exists(RT_LT."$rt3sys_theme/rt-style.css"))						// checks if bluesocial exists
		rt3f_criticalerror(1030);												// critical error if not
}
// *** sets up HTML head section ***********************************************
$rt3sys_page['headers']=<<<MAIN
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<meta http-equiv="X-UA-Compatible" content="IE=Edge" /> <!-- to force IE to use latest settings -->
<meta http-equiv="content-type" content="text/html;charset=iso-8859-1" />
${rt3sys_page['jshead']}
<title>$rt3l_t</title>
<!-- favicon -->
<link rel="shortcut icon"  href="./images/system/favicon.ico" />
<!-- RT3 stylesheets -->
<link rel="stylesheet" type="text/css" href="theme/$rt3sys_theme/rt-style.css" media="screen" />
<link rel="stylesheet" type="text/css" href="theme/$rt3sys_theme/rt-style-p.css" media="print" />
<!-- IE/non IE specific stylesheets --> 
<![if !IE]>
<link media="only screen and (max-device-width: 480px)"
   href="theme/$rt3sys_theme/rt-style-m1.css" type="text/css" rel="stylesheet" />
<link media="only screen and (max-device-width: 800px)"
   href="theme/$rt3sys_theme/rt-style-m2.css" type="text/css" rel="stylesheet" />
<![endif]>
<!--[if IE 8]>
<link rel="stylesheet" type="text/css" href="theme/$rt3sys_theme/rt-style-ie.css" media="all" />
<![endif]-->
<!--[if IE lt 8]>
<link rel="stylesheet" type="text/css" href="theme/$rt3sys_theme/rt-style-ie7.css" media="all" />
<![endif]-->
<!-- end IE/non IE specific -->
</head>
<body>
MAIN;
// *** sets up HTML foot section ***********************************************
$rt3sys_page['foot']="RaidTracker version ".RT_VERSION." -- &copy;2007-2014 Frank Spychaj. ".
rt3h_url("About RaidTracker","http://raidtracker.druidlove.com");
$rt3sys_page['foot']=rt3h_div($rt3sys_page['foot'],null,'pagefooter');
$rt3sys_page['footer']="</body>\n</html>";
?>