<?php 
/*******************************************************************************
 * login.php
 * *****************************************************************************
 * RT 3 check for log in details
 ******************************************************************************/
// *************************************************************** FUNCTIONS ***
function rt3f_checkpriv($cat, $name=null) {
	global $rt3user_status, $rt3user;
	global $rt3db_table;
	if (!$rt3user || $rt3user_status<0)
		$stat=0;
	else $stat=$rt3user_status;
	if (is_array($name)) {
		for ($i=0; $i<count($name); $i++)
			$name[$i]="'".$name[$i]."'";
		$name=implode(', ',$name);
		$rt3rank=$rt3db_table[0]->select(db_priv,'*',"`cat`='$cat' AND `name` IN ($name)");
		for ($i=0; $i<count ($rt3rank); $i++) {
			$rt3l_n=$rt3rank[$i]['name'];
			$rt3l_list[$rt3l_n]=(($stat) ? (bool)(($rt3rank[$i]['level']) >= $stat) : false);
		}
		return $rt3l_list;
	}
	if ($name) {
		if (!$stat) return 0;
		$rt3rank=$rt3db_table[0]->select(db_priv,'*',"`cat`='$cat' AND `name`='$name'");
		$rt3l_rank=$rt3rank[0]['level'];
		return ($stat?$rt3l_rank >= $stat:0);
	}
	$rt3rank=$rt3db_table[0]->select(db_priv,'*',"`cat`='$cat'");
	for ($i=0; $i<count ($rt3rank); $i++) {
		$rt3l_n=$rt3rank[$i]['name'];
		$rt3l_list[$rt3l_n]=($stat ? (bool)(($rt3rank[$i]['level']) >= $stat) : 0);
	}
	return $rt3l_list;
}
function rt3f_cookie($name, $value, $expire='', $path='/') {
	if (!$expire) $expire=time()+3600;
	setcookie($name,$value,$expire,$path);
}
function rt3f_pwdcomp($main, $verify, $match=1){
	if ($main==$verify) {
		if ($match) $c=0;
		else $c=1260;  															// error code
	}else{
		if ($match) $c=1261;  													// error code
		else $c=0;
	}
	if ($c) {
		rt3f_error($c);
		return false;
	}
	return true;
}
function rt3f_pwdvalid($pwd) {
	if (strlen($pwd)>7) {
		$rt3l_arr=array('/[A-Z]/','/[a-z]/','/\d/');							// array of required characters in pwd
		for ($i=0; $i<count($rt3l_arr); $i++) {
			if (!preg_match($rt3l_arr[$i],$pwd)) {								// missing a required character
				rt3f_error(1264);
				return false;
			}
			return true;
		}
	}
	rt3f_error(1264);
	return false;
}
// ***************************************************************** CODE ******
include_once RT_LL."dbfn.php";
// *** check for cookies and logout here ***************************************
if ($_COOKIE[($rt3pref_system['cookie'])]) {									// check if cookie exists
	include RT_LS."login-c.php";
	if (!$rt3user) {															// no user
		unset ($_GET, $_POST);													// unset all get/post vars, so they don't get used
		rt3f_cookie($rt3pref_system['cookie'],false,time()-3600,'/');			// delete any cookie here
	}
// *** log in or create account ************************************************
} elseif (isset($_POST['login'])) {											// to log in
	include RT_LS."login-f.php";
	if (!$rt3user) {															// if login failed
		$rt3sys_view='login';													// set view to login
		if ($_POST['system']['tabno']>1 && $_POST['system']['view']=='login')	// if was in login, get tab no
			$rt3sys_tab=$_POST['system']['tabno'];
	}
	unset ($_GET, $_POST);
} else {
	$rt3user=0;
}
function rt3f_getloginsettings() {
	global $rt3user, $rt3time, $rt3user_name, $rt3user_info, $rt3user_status;
	$rt3user_info=rt3f_masterlist($rt3user);
	$rt3user_name=$rt3user_info['fullname'];
	$rt3user_status=($rt3user_info['active']==0?-1:$rt3user_info['rtrank']);
	
	$rt3time->set_loffset((float) $rt3user_info['offset']);
	$rt3time->set_datef($rt3user_info['fdate']);
	$rt3time->set_timef($rt3user_info['ftime']);
}
if ($rt3user) {
	rt3f_getloginsettings();
} else {
	$rt3time->set_datef($rt3pref_format['date'][0]);
	$rt3time->set_timef($rt3pref_format['time']);
	$rt3user_status=0;
}	
?>