<?php
/*******************************************************************************
 * login-f.php
 *******************************************************************************
 * form based log in (when logging in or creating account)
 ******************************************************************************/
// *** normal log in ***********************************************************
function rt3f_lnorm() {
	global $rt3pref_system, $rt3db_table;
	$user=$_POST['login']['name'];												// get char name
	$pass=$_POST['login']['pwd']['curr'];										// get password
	$charinfo=$rt3db_table[1]->selectrec(db_char,'*',"`name`='$user'"); 		// get rec
	if (!$charinfo) {															// no character on file
		rt3f_error(1010);														// error
		return 0;
	}
	$acctid=$charinfo['aid'];													// get acct id
	$acctinfo=$rt3db_table[1]->selectrec(db_acct,'*',"`aid`=$acctid");			// get acct info
	$acctpwd=$acctinfo['pass'];													// get password
	if (!$acctpwd || $acctpwd=='masterreset') {
		rt3f_error(1012);														// error
		return 0;
	}
	if (crypt($pass, $acctpwd)!=$acctpwd) {										// password does not match
		rt3f_error(1013);														// error
		return 0;
	}
	if (!$rt3db_table[0]->selectrec(db_accts,"*","aid=$acctid")) {				// if not in system already
		$locarr=array(
			'aid'=>$acctid,
			'grank'=>$GLOBALS['rt3pref_acct']['rank']['g'],
			'rtrank'=>$GLOBALS['rt3pref_acct']['rank']['r'],
			'fdate'=>$GLOBALS['rt3pref_format']['date'][0],
			'ftime'=>$GLOBALS['rt3pref_format']['time'],
			'view'=>$GLOBALS['rt3pref_view']['home']['d'],
			'offset'=>'0.00',
			'active'=>($GLOBALS['rt3pref_acct']['active']<1?1:0)				// 0 is yes, 1, 2 is no
		);
		$rt3db_table[0]->insert(db_accts,$locarr);								// insert into local setting tbl
		$rt3l_code=220+$locarr['active'];										// code for log
	} else $rt3l_code=222;														// code for log (normal)
	rt3f_logdata($rt3l_code,"IP address: ".$_SERVER['REMOTE_ADDR'],$acctid);	// log transaction
	$cookiename=RT_VERSION_INT."|$acctid|$acctpwd";								// set cookie name
	rt3f_cookie($rt3pref_system['cookie'],$cookiename,time()+(3600*24*30),'/');	// set cookie for user
	rt3f_success(43);
	return $acctid;
}
// *** forgot log in ***********************************************************
function rt3f_lforgot() {
	global $rt3pref_system, $rt3db_table;
	if ($rt3pref_system['maint']) {												// maintenance mode
		rt3f_error(1028);
		return 0;
	}
	$user=$_POST['login']['name'];												// get char name
	$email=$_POST['login']['email'];											// get char name
	$pass=$_POST['login']['pwd']['new'];										// get password
	if ($pass !=$_POST['login']['pwd']['r']) {									// if password does not match
		rt3f_error(1261);														// error
		return 0;
	}
	if (!rt3f_pwdvalid($pass)) return 0;										// if pass not valid return false
	$charinfo=$rt3db_table[1]->selectrec(db_char,'*',"`name`='$user'"); 		// get rec
	if (!$charinfo) {															// no character on file
		rt3f_error(1010);														// error
		return 0;
	}
	$acctid=$charinfo['aid'];													// get acct id
	$acctinfo=$rt3db_table[1]->selectrec(db_acct,'*',"`aid`=$acctid");			// get acct info
	if ($acctinfo['main']!=$charinfo['cid']) {									// not main character?
		rt3f_error(1011);														// error
		return 0;
	}
	$acctpwd=$acctinfo['pass'];													// get password
	if ($acctpwd && $acctpwd!='masterreset') {									// not blank/reset acct
		if ($acctinfo['email']!=$email) {										// if e-mail does not match
			rt3f_error(1012);													// error
			return 0;
		}
	}
	if (!$rt3db_table[0]->selectrec(db_accts,"*","aid=$acctid")) {				// if not in system already
		$locarr=array(
			'aid'=>$acctid,
			'grank'=>$GLOBALS['rt3pref_acct']['rank']['g'],
			'rtrank'=>$GLOBALS['rt3pref_acct']['rank']['r'],
			'fdate'=>$GLOBALS['rt3pref_format']['date'][0],
			'ftime'=>$GLOBALS['rt3pref_format']['time'],
			'view'=>$GLOBALS['rt3pref_view']['home']['d'],
			'offset'=>'0.00',
			'active'=>($GLOBALS['rt3pref_acct']['active']<1?1:0)				// 0 is yes, 1, 2 is no
		);
		$rt3db_table[0]->insert(db_accts,$locarr);								// insert into local setting tbl
		$rt3l_code=253+$locarr['active'];										// code for log
	} else $rt3l_code=252;														// code for log (normal)
	rt3f_logdata($rt3l_code,"IP address: ".$_SERVER['REMOTE_ADDR'],$acctid);	// log transaction
	// *** set up cookie and pass back to normal *******************************
	$acctpwd=crypt($pass);
	$cookiename=RT_VERSION_INT."|$acctid|$acctpwd";								// set cookie name
	$rt3db_table[1]->update(db_acct,array('pass'=>$acctpwd),"aid=$acctid");		// update db
	rt3f_cookie($rt3pref_system['cookie'],$cookiename,time()+(3600*24*30),'/');	// set cookie for user
	rt3f_success(44);
	return $acctid;
}
// *** register log in *********************************************************
function rt3f_lregister() {
	global $rt3pref_system, $rt3db_table;
	if ($rt3pref_system['maint']) {												// maintenance mode
		rt3f_error(1029);
		return 0;
	}
	$email=$_POST['login']['email'];											// get char name
	$pass=$_POST['login']['pwd']['new'];										// get password
	$newchar=$_POST['addchar'];													// get new character
	// *** check for validity ***************************************************
	include RT_LM."checkpwd.php";
	if (!rt3f_vnewpwd($email,$pass,$_POST['login']['pwd']['r']))
		return 0;
/*	
	if ($pass !=$_POST['login']['pwd']['r']) {									// if password does not match
		rt3f_error(1261);														// error
		return 0;
	}
	if (!rt3f_pwdvalid($pass)) return 0;										// if pass not valid return false
	if (!preg_match('/^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4}$/i',$email)) { 	// not a valid e-mail
		rt3f_error(1263);														// error
		return 0;
	} 
*/
	if (!$newchar['name'] || !$newchar['level']) {								// missing name or level?
		rt3f_error(1016);
		return 0;
	}
	// *** check in DB for duplicates *******************************************
	$charinfo=$rt3db_table[1]->selectrec(db_char,'*',"`name`='$newchar[name]'");// check for character
	if ($charinfo) {															// character on file
		rt3f_error(1010);														// error
		return 0;
	}
	$acctinfo=$rt3db_table[1]->selectrec(db_acct,'*',"`email`='$email'");		// check for e-mail
	if ($acctinfo) {															// account exists?
		rt3f_error(1015);														// error
		return 0;
	}
	// *** set up for database calls ********************************************
	$acctpwd=crypt($pass);														// crypt password
	$acctarr=array('email'=>$email, 'pass'=>$acctpwd, 'main'=>0);				// set up acct id arrays
	$acctid=$rt3db_table[1]->insone (db_acct, $acctarr, 'aid',"email='$email'");// add acct to main table, get acct id
	$newchar['aid']=$acctid;													// add acct id to char table
	unset ($newchar['submit']);													// get rid of that submit
	$charid=$rt3db_table[1]->insone(db_char, $newchar, 'cid',"aid=$acctid");	// add character to char table, get char id for main
	$rt3db_table[1]->update(db_acct, "main=$charid", "aid=$acctid");			// put in main
	// *** set up for local settings table **************************************
	$locarr=array(
		'aid'=>$acctid,
		'grank'=>$GLOBALS['rt3pref_acct']['rank']['g'],
		'rtrank'=>$GLOBALS['rt3pref_acct']['rank']['r'],
		'fdate'=>$GLOBALS['rt3pref_format']['date'][0],
		'ftime'=>$GLOBALS['rt3pref_format']['time'],
		'view'=>$GLOBALS['rt3pref_view']['home']['d'],
		'offset'=>'0.00',
		'active'=>($GLOBALS['rt3pref_acct']['active']<2?1:0)					// 0,1 is yes, 2 is no
	);
	$rt3db_table[0]->insert(db_accts,$locarr);									// insert into local setting tbl
	// *** log it **************************************************************
	rt3f_logdata(210+$locarr['active'],"IP address: ".$_SERVER['REMOTE_ADDR'],$acctid);
	// *** set for log in and go ***********************************************
	$cookiename=RT_VERSION_INT."|$acctid|$acctpwd";								// set cookie name
	rt3f_cookie($rt3pref_system['cookie'],$cookiename,time()+(3600*24*30),'/');	// set cookie for user
	rt3f_success(45);
	return $acctid;
}

function rt3f_login() {
	$rt3form_log=$_POST['login'];												// get login form data
	if (isset($rt3form_log['pwd']['curr'])) return rt3f_lnorm();				// if curr pwd, strict log in
	elseif (isset($rt3form_log['name'])) return rt3f_lforgot();				// if forgot, forgot mode
	else return rt3f_lregister();												// new account
}
$rt3user=rt3f_login();
?>