<?php
/*******************************************************************************
 * error.php
 * *****************************************************************************
 * To generate all the error and news and success messages.
 ******************************************************************************/
function rt3f_errorline($type, $subj, $message) {
	global $rt3sys_page;																		// for inserting in $rt3sys_page['error']
	$ln=rt3h_div($subj,"subject");
	$ln.=rt3h_div($message,'message');
	$errmsg=rt3h_div($ln,$type."bar");
	$rt3sys_page['error'].=$errmsg;
}

function rt3f_errorpage($extra) {
	global $rt3sys_page;																		// for inserting in $rt3sys_page['main']
	$rt3sys_page['main']=rt3h_h(1,loc_error_head_fatal);
	$rt3sys_page['main'].=rt3h_div(loc_error_body_fatal);
	$rt3sys_page['main'].=rt3h_div(rt3h_url(loc_error_link_fatal,'.'));
	$rt3sys_page['main'].=rt3h_div($extra);
	return;
}

function rt3f_success($code, $extra=null) {
	if ($code<1 || $code >999) {
		rt3f_error(1000, "Code: $code");
		return;
	}
	$msg=$GLOBALS['rt3loc_error'][$code]." $extra";
	rt3f_errorline('success',loc_success, $msg);
}
function rt3f_error($code, $extra=null) {
	if ($code<999 ) {
		rt3f_error(1001, "Code: $code");
		return;
	}
	$msg=$GLOBALS['rt3loc_error'][$code]." $extra";
	rt3f_errorline('error',loc_error_name." $code", $msg);
}
function rt3f_fatalerror($code, $extra=null) {
	if ($code<999 ) {
		rt3f_fatalerror(1001, "Code: $code");
		return;
	}
	$msg=loc_error_name." $code: ".$GLOBALS['rt3loc_error'][$code];
	if ($extra) $msg.=" | $extra";
	rt3f_errorpage("$code: $msg");
}
// *** critical error is a system stop that cannot proceed *********************
function rt3f_criticalerror($code, $extra=null) {
	if ($code<999) {
		rt3f_criticalerror(1001, "Code: $code");
	}
	echo loc_criterror .BR;
	echo loc_error_name." $code: ".$GLOBALS['rt3loc_error'][$code];
	if ($extra) echo " | $extra";
	exit();
}
// also for news
?>