<?php
/*******************************************************************************
 * rtcore/db.php
 * -----------------------------------------------------------------------------
 * The core DB library
 * RaidTracker 3.0
 ******************************************************************************/
class rt3cl_db {
	private $db;		// db link
	private $res;		// resource link
	//private $result;  // result in array form
	
	function __construct($server, $user, $pass, $db) {
//		echo "Server |$server| Username |$user|, Pass |$pass|, DB |$db|";
		$this->db=mysqli_connect($server, $user, $pass, $db);
		if ($this->db->connect_errno) {
			rt3f_criticalerror(1005);
		}
	}
	public function query($sql) {
		if ($this->res && !is_bool($this->res)) mysqli_free_result($this->res);
		$this->res=mysqli_query($this->db,$sql);
	}
	private function set($arr) {
		if (!is_array($arr)) return "SET $arr";
		$t="SET";
		$i=0;
		foreach ($arr as $k=>$v) {
			$t.=($i++?",":'')." `$k`=";
			if ($v==='null') $t.="NULL";
			else $t.="'".addslashes($v)."'";
		}
		return $t;
	}
	public function insert($table, $arr) {
		$sql="INSERT INTO `$table` ".$this->set($arr);
		$this->query($sql);
		if ($this->res) return 0;
		rt3f_error(1004,"|$sql|");
		return false;
	}
	public function update ($table, $arr, $cond='') {
		$sql="UPDATE `$table` ".$this->set($arr);
		if ($cond) $sql.=" WHERE $cond";
		$this->query($sql);
		if ($this->res) return 0; 
		rt3f_error(1003,"|$sql|");
		return null;
	}
	public function select($table, $field="*", $cond=null, $other=null) {
		if (is_array($field)) {
			foreach ($field as $k=>$v) {
				$field[$k]="`$v`";
			}
			$field=implode(", ", $field);
		}
		if (is_array($table)) {
			foreach ($table as $k=>$v) {
				$table[$k]="`$v`";
			}
			$table=implode(", ", $field);
		}
		$sql="SELECT $field FROM $table";
		if ($cond) $sql.=" WHERE $cond";
		if ($other) $sql.=" $other";
		$this->query($sql);
		if (!$this->res){
			rt3f_error(1002,"|$sql|");
			return false;
		}
		$i=0;
		while ($ln=mysqli_fetch_assoc($this->res)) {
			foreach ($ln as $k=>$v) {
				$result[$i][$k] = $v;
			}
			$i++;
		}
		return $result;
	}
	public function selectone ($retfield, $table, $field="*",$cond=null,$other=null) {
		$val=$this->select($table, $field, $cond, $other);
		return $val[0][$retfield];
	}
	public function selectrec($table, $field='*', $cond=null, $other=null) {
		$val=$this->select($table, $field, $cond, $other);
		return $val[0];
	}
	// process an INSERT statement and return a value
	public function insone ($table, $arr, $column, $search) {
		if (is_array($search)) {
			foreach ($search as $v) {
				if ($i++) $sw.=" AND ";
				$sw.="`$v`='$arr[$v]'";
			}
		} else $sw=$search;
		$this->insert($table, $arr);
		$r=$this->select($table, $column, $sw, "LIMIT 1");
		return $r[0][$column];
	}
	public function delete ($table, $where) {
		if (is_array($where)) {
			foreach ($where as $v) {
				if ($i++) $sw.=" AND ";
				$sw.="`$v`='$arr[$v]'";
			}
		} else $sw=$where;
		$this->query("DELETE FROM $table WHERE $sw");
	}
}
if (!file_exists(RT_LN."index.php")) {
	include RT_LU."db.php";
	if ($rt3dbver=="3.00") {
		for ($i=0; $i<=$rt3db_share; $i++){
			$rt3db_table[$i]=new rt3cl_db($rt3db_loc[$i],$rt3db_user[$i],$rt3db_pass[$i], $rt3db_db[$i]);
		}
		if ($rt3db_share==0) $rt3db_table[1]=&$rt3db_table[0];
	}
}
define ('db_acct',$rt3db_prefix[1]."account");
define ('db_char',$rt3db_prefix[1]."character");
define ('db_acctk',$rt3db_prefix[1]."akeys");
define ('db_accts',$rt3db_prefix[0]."locset");
define ('db_event',$rt3db_prefix[0]."event");
define ('db_sub',$rt3db_prefix[0]."sub");
define ('db_priv',$rt3db_prefix[0]."privs");
define ('db_loc',$rt3db_prefix[0]."rtkeys");
define ('db_log',$rt3db_prefix[0]."log");
define ('db_dkp',$rt3db_prefix[0]."dkp");
define ('db_dkpl',$rt3db_prefix[0]."dkplist");

?>