<?php
/*******************************************************************************
 * table.php
 *******************************************************************************
 * stores and creates a table
 * -----------------------------------------------------------------------------
 * most important functions:
 * constructor (col, row, row repeat=25)
 * addhead (data, att=null)
 * addcell (data, att=null)
 * html()
 * -----------------------------------------------------------------------------
 * last edited 2013-05-11
 ******************************************************************************/
class rt3cl_table  {
	//========================================== VARIABLES
	//------------ dimensions of table
	private $row=1;
	private $col=1;
	private $fixed=false; //true if it's a dynamic table. 
	private $rowrepeat=25; //when to repeat headers
	//------------ pointers
	private $rowp=0;
	private $colp=0;
	private $headp=0;
	//------------ data
	private $tableatt; //table attributes
	private $rowatt;   // row attributes
	private $headers;  // header cols
	private $headatt;  // header attributes
	private $cells;    // cell data
	private $cellatt;  // cell attributes
	//========================================== FUNCTIONS
	/****************************************************************************
	 * Constructor
	 * --------------------------------------------------------------------------
	 * Passed in variables
	 * c: columns. r: rows rr: repeat headers after every x rows (0 is none)
	****************************************************************************/
	function __construct ($c=0, $r=0, $rr=25) {
		if ( $c xor $r) { // only one defined
			rt3f_criticalerror(1026, "Col=$c, Row=$r");
		} else if ($r && $c) {
			$this->row=$r;
			$this->col=$c;
			$this->fixed=true;
			$this->rowrepeat=$rr;
		}
	}
	// compresses attributes into a list for tags
	private function attributes ($att=null) {
		if (is_null($att)) return "";
		else if (!is_array($att)) return " $att";
		foreach ($att as $k=>$v) 
			$a.=" $k=\"$v\"";
		return $a;
	}
	// add a row. takes in optional attributes
	public function addrow($att=null) {
		$this->colp=0;
		$this->rowp++;
		if ($this->row==$this->rowp) $this->row++;
		$this->rowatt[$this->rowp]=$this->attributes($att);
	}
	// adds a cell, takes in optional data and attributes
	public function addcell($data="", $att=null){
		// if at the end of the table, check for dynamic
		if ($this->colp==$this->col) {
			if ($this->fixed) $this->addrow(); // fixed cols, so add row
			else $this->col++;
		}
		$this->cells[$this->rowp][$this->colp]=$data;
		$this->cellatt[$this->rowp][$this->colp]=$this->attributes($att);
		$this->colp++; // move col pointer over 1
	}
	// adds header cell info
	public function addhead($data='', $att=null) {
		// if at the end of headers and fixed table cols, error
		if (($this->headp +1 > $this->col) && !$this->f) {
			echo "Error 91: cannot add header--exceeds columns possible";
			exit();
		}
		$this->headers[$this->headp]=$data;
		$this->headatt[$this->headp]=$this->attributes($att);
		$this->headp++; // move col pointer over 1
	}
	// set attributes to a col/row. 
	// row 0/col 0 is table. row 0 col x is header cols
	// row x/col 0 is row. 
	public function setattributes ($row, $col, $att=null) {
		if ($row<0 || $col<0) {
			echo "Error 92: setattributes has invalid data: row=$row col=$col";
			exit();
		}
		$a=$this->attributes($att);
		if ($row>0 && $col>0) $this->cellatt[$row-1][$col-1]=$a;
		else if ($row==0) {
			if ($col==0) $this->tableatt=$a;
			else $this->headatt[$col-1]=$a;
		}
		else $this->rowatt[$row-1]=$a;
	}
	// set data in a table.
	// if row =0, then it's header. 
	// col CANNOT be 0.
	public function setdata($row, $col, $data, $att=null) {
		if ($row<0 || $col<1) {
			echo "Error 93: setdata has invalid data: row=$row col=$col";
			exit();
		}
		$this->setattributes($row, $col, $att);
		if ($row>0) $this->cells[$row-1][$col-1]=$data;
		else $this->headers[$col-1]=$data;
	}
	// make table HTML here
	public function html() {
		// make header here 
		for ($i=0; $i<$this->col; $i++) {
			$hc=(isset($this->headers[$i])?$this->headers[$i]:null);
			$ha=(isset($this->headatt[$i])?$this->headatt[$i]:null);
			$heading.=rt3h_tagr('th',$hc,$ha,0,1);
		}
		$heading=rt3h_tagr('tr',$heading,null,1,1);
		// make each row
		for ($i=0; $i<$this->row; $i++) {
			// put heading up on 0 and every row repeat row
			if ($this->rowrepeat !=0) {  // protect div by 0, 0 also means no repeat 
				if (($i % abs($this->rowrepeat))==0) $tbl.=$heading;
			} else if ($i==0) $tbl.=$heading;
			$rd='';
			$ra=(isset($this->rowatt[$i])?$this->rowatt[$i]:null);
			//make each col in row
			for ($j=0; $j<$this->col; $j++) {
				$dc=(isset($this->cells[$i][$j])?($this->cells[$i][$j]):null);
				$da=(isset($this->cellatt[$i][$j])?($this->cellatt[$i][$j]):null);
				$rd.=rt3h_tagr('td',$dc,$da,0,1);
			}
			$tbl.=rt3h_tagr('tr',$rd,$ra,1,1);
		}
		if ($this->rowrepeat >0)
			$tbl.=$heading;
		$tbl=rt3h_tagr('table',$tbl,$this->tableatt,1,1);
		return $tbl;
	}
}
	

/* old data below ? */


//-------------- managing a table here
class rtTable {
	// dimensions of the table here
	private $r=0;       // total rows
	private $c=0;       // total cols
	private $f=false;  // fixed? 
	// cell data
	private $th;        // head  col#
	private $tc;        // cells col# row #
	// att data
	private $at;        // table attribs
	private $ad;        // cell attrib (col#, h or row#)
	private $ar;        // row attrib (h or row#)
	private $ac;        // col attrib (Col#)
	// pointers
	private $lh=0;      // head col#
	private $lc=0;      // col#
	private $lr=0;      // row#
	
	// functions
	// construct
	function __construct($col=0, $row=0) {
		if ($row && $col) {
			$this->r=$row;
			$this->c=$col;
			$this->f=true;
		}
	}
	// sets attributes
	public function setatt($value, $name="class", $x=null, $y=null) {
		if ($y==='a') {
			if ($x==='a'|| is_null($x)) {
				$this->at[$name]=$value;
			} else {
				$this->ar[$y][$name]=$value;
			}
		} else if ($x==='a') {
			if (is_null($y)) $y=$this->lh;
			$this->ac[$y][$name]=$value;
		} else {
			if (is_null($y)) 
				if($x==='h') $y=$this->lh;
				else $y=$this->lc;
			if (is_null($x)) $x=$this->lc;
			$this->ad[$x][$y][$name]=$value;
		}
	}
	// sets data
	public function setdata($value, $x=null, $y=null) {
		if ($y==='h') {
			if (is_null($x)) $x=$this->lh;
			$this->th[$x]=$value;
		} else {
			if (is_null($y)) $y=$this->lr;
			if (is_null($x)) $x=$this->lc;
			$this->tc[$x][$y]=$value;
		}
	}
	//output table
	public function get() {
		$table=null;
		// extract all attrib for the cols:
		for ($i=0; $i<$this->c;$i++) {
			$attrib[$i]=html_att($this->ac[$i]);
		}
		// go through header row
		for ($i=0; $i<$this->c; $i++) {
			$a2='';
			if (is_array($this->ad[$i]['h'])) $a2=html_att($this->ad[$i]['h']);
			$trow.=html_tag('th',$this->th[$i],null,null,"$a2 ".$attrib[$i]).NL;
		}
		$table.=html_tag('tr',$trow,null,null,$this->ar['h']).NL;
		// goes through each row
		for ($j=0; $j<$this->r; $j++) {
			$trow=''; // clears table row temp
			for ($i=0; $i<$this->c; $i++) {
				$a2=''; // clears attrib
				if (is_array($this->ad[$i][$j])) $a2=html_att($this->ad[$i][$j]);

				$trow.=html_tag('td',$this->tc[$i][$j],null,null,"$a2 ".$attrib[$i]).NL;
			}
			$table.=html_tag('tr',$trow,null,null,$this->ar[$j]).NL;
		}
		return html_tag('table',$table,null,null,$this->at);
	}
	// wrapper functions
	// adds a header
	public function addHead($data='', $class=null, $att=null) {
		$x=$this->lh; // get current value of pointer
		if ($x==$this->c) { //if pointer beyond the last column check special cases
			if ($this->r) return false; //if there is a row entered, don't add a col
			if ($this->f) return false; //if the table is fixed dim, don't add a col
			$this->c++; // add a column otherwise
		}
		$this->setdata($data, $x, 'h');
		if ($class) $this->setatt ($class, "class", $x, 'h');
		if (is_array($att)) {
			foreach ($att as $k->$v) {
				$this->setatt ($v, $v, $x, 'h');
			}
		}
		$this->lh++; // move pointer
		return true;
	}
	// add data
	public function addCell($data='', $class=null, $att=null) {
		if ($this->c==0) return false; // if no col set, can't add
		if ($this->r==0) $this->r++; // if no row set, add one now
		$x=$this->lc; // get current value of pointer
		$y=$this->lr; // get current column location
		if ($x==$this->c) { //if pointer beyond the last column check special cases
			if ($y+1 ==$this->r){  //last row, beyond the last column 
				if ($this->f) return false; // fixed dimensions, don't add
				$this->r++; // adds a row
			}
			$this->lr++; // moves global pointer down
			$y++; // moves current pointer value down
			$x=0; // moves current pointer value to beginning
			$this->lc=0; // moves global pointer to beginning of row
		}
		$this->setdata($data, $x, $y);
		if ($class) $this->setatt ($class, "class", $x, $y);
		if (is_array($att)) {
			foreach ($att as $k=>$v) {
				$this->setatt ($v, $k, $x, $y);
			}
		}
		$this->lc++; // moves pointer over
		return true;
	}
	public function tableAtt ($value, $name='class') {
		$this->setatt($value, $name, 'a', 'a');
	}
	public function rowAtt ($row, $value, $name='class') {
		$this->setatt($value, $name, 'a', $row);
	}
	public function colAtt ($col, $value, $name='class') {
		$this->setatt($value, $name, $col, 'a');
	}
/*
	// functions
	// initializes table
	public function init($class='', $col=1, $row=0) {
		$this->cols=$col;
		$this->rows=$row;
		$this->tblclass=$class;
	}
	//adds data to table
	public function set ($data, $loc='d', $id=null) {
		switch ($loc) {
			case "c": 
				if ($this->lclass == $this->cols) die ("Too many classes");
				$this->tclass[$this->lclass++]=$data;
				return;
			case "h": 
				if ($this->lhead == $this->cols) die ("Too many columns");
				$this->thead[$this->lhead]=tag($data,'th',$this->lclass[$this->lhead],$id);
				$this->lhead++;
				return;
			case "d": 
				if ($this->lcol == $this->cols) {
					$this->lcol=0;
					$this->lrow++;
				}
				if ($this->rows == $this->lrow) $this->rows++;
				$this->tcell[$this->lrow][($this->lcol)]=tag($data,'td',$this->lclass[$this->lcol],$id);
				$this->lcol++;
				return;
			default: die ("invalid parameter $loc");
		}
	}
	// gets the table in HTML format
	public function get() {
		//initialize variables
		$tbl='';
		$col=$this->cols;
		$row=$this->rows;
		$classes=$this->tclass;
		
		for ($i=0;$i<$col;$i++) {
			$tloop.=$this->thead[$i].NL;
		}
		$tbl.=tag ($tloop, 'tr');
		for ($i=0; $i<$row; $i++) {
			$tloop='';
			for ($j=0; $j<$col; $j++) {
				$tloop.=$this->tcell[$i][$j];
				
			}
			$tbl.=tag ($tloop, 'tr');
		}
		$tbl=tag(NL . $tbl,'table',$this->tblclass);
		return $tbl;
	}
	// format text into row/cell
	// html_tag takes on name|val|class|id|attlist
	protected function format ($data=null, $type='td', $class=null, $id=null) {
		return html_tag($type, $data, $class, $id);
/*		if ($class) $t= " Class=\"$class\"";
		if ($id) $t.=" id=\"$id\"";
		return "<{$type}{$t}>$data</$type>\n";
*/
/*
	}
*/
}
