<?php
/*******************************************************************************
 * groupclass.php
 *******************************************************************************
 * a PHP class file just for long/short name groups 
 * i.e. instances, classes, etc
 ******************************************************************************/
class rt3cl_group{
	private $g;				// the group array
	private $c;				// category
	// *** functions ************************************************************
	// *** constructor. takes in category, shared *******************************
	function __construct($cat, $shared=0) {
		global $rt3db_table;
		if ($shared) $tbl=db_acctk; else $tbl=db_rtkeys;
		$lst=$rt3db_table[$shared]->select($tbl,array('sn','ln'), "cat='$cat'");
		for ($i=0; $i<count ($lst); $i++)
			$this->g[($lst[$i]['sn'])]=$lst[$i]['ln'];
		$this->c=$cat;
	}
	// *** returns icon or name ***
	public function icon ($n) {
		return rt3f_icons($this->c,$n, $this->g[$n]);
	}
	public function name ($n) {
		return $this->g[$n];
	}
	// *** returns icon + text behind it ***
	public function group ($n, $txt) {
		return rt3h_span($this->icon($n),$txt);
	}
	// *** icon + name of icon (diff. from above in that both are included) ***
	public function fullname($n) {
		return $this->group($n,$this->g[$n]);
	}
	public function count() {return count($this->g);}
	// *** to add or delete features in group for special reasons ***
	public function add ($sn, $ln) {
		$this->g[$sn]=$ln;
	}
	public function del ($sn) {
		unset ($this->g[$sn]);
	}

	public function fselect($name, $label=null,$default=null, $class=null, $id=null, $att=null) {
		return rt3h_select ($name, $this->g, $label, $default, $class, $id, $att);
	}
}
/*	

class rtGroup {
	private $Total=0;        // number of elements total
	private $id;             // id if used (internal ID aka counter)
	private $sName;          // short name (or reference to file loc)
   private $lName;          // long name (or description)
	private $desc;           // description to follow after icon
	private $category;       // category of icon for this group
	
	// ****************************** functions
	// --------- constructor. (requires a category)
	function __construct ($cat) {
		$this->category= $cat;
	}
	// add an element
	public function add ($sname, $lname=null, $desc=null) {
		$t=$this->Total;
		$this->id[$t]=$t;
		$this->desc[$t]=$desc;
		$this->lName[$t]=$lname;
		$this->sName[$t]=$sname;
		$this->Total++;
	}
	// function to return total elements in class
	public function count() { return $this->Total;}
	
	// lookup functions
	// Returns the id based on short name (or -1 for not found)
	public function getID($s) {
		for ($i=0; $i<$this->count(); $i++) {
			if ($this->sName[$i]==$s) return $this->id[$i];
		}
		return -1;
	}
	//returns value based on ID #
	public function get ($id=0, $type='s') {
		if ($id<0 || $id > $this->count()) return "Invalid";
		switch ($type) {
			case 'i': return $this->id[$id];
			case 's': return $this->sName[$id];
			case 'l': return $this->lName[$id];
			case 'd': return $this->desc[$id];
			default: die ("Invalid parameter: $type");
		}
	}
	// Wrapper to return type based on the short name given
	public function gets ($s, $type="l") {
		$t=$this->getID($s);
		if ($t<0) return false;
		return $this->get($t, $type);
	}
	// return array of elements. Useful for select
	public function arr($type='d') {
		for ($i=0; $i<$this->count(); $i++) {
			if ($type=='d') $arr[$this->sName[$i]]=$this->desc['$i'];
			if ($type=='s') $arr[$this->sName[$i]]=$this->sName['$i'];
			if ($type=='l') $arr[$this->sName[$i]]=$this->lName['$i'];
		}
		return $arr;
	}
	// generate 
	// generate the image/icon
	public function pic($id) {
		$att['src']= RT_WI . $this->category . "/" . $this->get($id) .".png";
		$att['alt']=$this->get($id,'l');
		return html_tag('img','/',null,null,$att);
	}
	// include all/part of a group
	public function groupelem ($id, $t="f") {
		$elem='';
		if ($t=='f' || $t=='i') $elem.=$this->pic($id);
		if ($t=='l') $elem.=$this->get($id, 'l');
		if ($t=='d' || $t =='f') $elem.=$this->get($id,'d');
		return html_tag('span',$elem, 'group');
	}
	// wrapper to make a group based on short name
	public function group ($n, $t='f') {
		$id=$this->getID($n);
		if ($id<0) return html_tag("span","Unknown", "group");
		return $this->groupelem($id,$t);
	}
}
*/
?>