<?php 
/*******************************************************************************
 * calendar.php
 *------------------------------------------------------------------------------
 * class for holding calendar events, and outputting a table
 * will require table.php
 ******************************************************************************/
include_once RT_LC . "table.php";
class rt3cl_calendar {
	private $startday;																			// start day, unix form
	private $weeks;																				// number of weeks 
	private $month;																				// month mode is set?
	private $event;																				// event in array form
	private $mode;																					// mode? 
	private $special;																				// array for day of week being special
	private $table;																				// table to print out calendar
	private $addbtn;																				// permissions to add?
	private $format;																				// format
	private $today;																				// today's date
	
	/****************************************************************************
	 * Constructor
	 * variables:
	 * day:		Today's date (unix format)
	 * wk:		number of weeks (0/month)
	 * start:	starting day 0-6 (Sun-Sat) works for all modes. 
	 *          7-13 is days back - 7 (0-6 days back). Not valid with month mode
	 ***************************************************************************/
	function __construct ($day, $wk, $start) {
		if ($start<0 || $start>13) 															// start day out of range
			rt3f_criticalerror(1023);
		else if ($start>6 && $wk==0)															// if in month mode, cannot use 7-13 (days back)
			rt3f_criticalerror(1024);
		else if ($wk<0)																			// weeks cannot be negative
			rt3f_criticalerror(1025);
		$this->today=$day;																		// today's date saved
		if ($wk==0) { 																				// if month
			$this->month=date('Ym',$day);
			$sd=strtotime(date('Y-m-\0\1',$day));
		} else {
			$this->month=0;
			$sd=strtotime(date('Y-m-d',$day));
		}
		$swd=date('w',$sd);
		if ($start>6) $dayback=$start-7;
		else {
			$dayback=$swd-$start;
			while ($dayback<0) $dayback+=7;
		}
		$day=strtotime('-'.$dayback." days", $sd);
		$this->startday=$day;																	// start day for calendar
		if ($wk==0){																				// if month, figure out weeks
			$loopday=$this->startday;
			do {
				$wk++;
				$loopday=strtotime("+7 days",$loopday);
				$testdt=date("Ym", $loopday);
			} while ($testdt <= $this->month);
		}
		$this->weeks = $wk; 																		// save week
		$this->format="M j";
		$this->table=new rt3cl_table(7,$this->weeks,0);
	}
	public function setAdd($p) {$this->addbtn=$p;}										// add button
	public function setFormat($p) {$this->format=$p;}									// format of the date
	public function setSpecial ($d, $v=1){$this->special[$d]=$v;}					// set special day of the week. 0-6: sun/sat $v is bool
	public function setMode ($d){ $this->mode=$d;}										// mode?
	public function setToday($d) {$this->today=$d;}									// unsets today's date so it won't show in cal highlighted
	public function getStart() { return $this->startday;}							// retrieve start day of this calendar. fix for month:
	public function getWeeks() { return $this->weeks;}								// retrieve weeks, useful if for month.
	public function setEvent($d, $v) {														// set date with an event. date in unix or date, $v is event (with html)
		if (!is_int($d)) $d=strtotime($d);
		$sd=date('Ymd',$d);
		$this->event[$sd][]=$v;
	}
// *** create the calendar *****************************************************	
	public function html() {
		global $rt3loc_days;																	// get days for calendar use
		$d=date("w",$this->startday);															// calculates starting day
		// *** headings: days of the week ***
		for ($i=0;$i<7;$i++) {																	// 7 headings, one for each week day
			if (isset($this->special[$d])) $colatt='class="reset"';					// for reset check
			$this->table->addhead($rt3loc_days[$d],$colatt);							// add table heading
			unset($colatt);																		// unset reset if it was set
			if (++$d==7) $d=0;																	// if wrapped around, reset to Sunday
		}
		// *** filling in with days ***
		$d=strtotime(date("Y-m-d",$this->startday)." 12:00:00");						// get starting day as unix from noon to avoid most DST issues
		$t=date("Ymd",$this->today);															// Structuring Today's date as YYYYMMDD
		for ($i=0; $i< $this->weeks; $i++) {												// going through each week
			for ($j=0; $j<7; $j++) {															// going through each day of the week
				if ($this->month) {																// if month is set
					$dm=date("Ym", $d);															// check month of this day
					if ($dm!=$this->month) {													// not in same month
						$this->table->addcell(null,'empty');									// add empty cell
						$dp=1;																		// set flag that day has been added
					} else $dp=0;																	// unset flag day so we can add day normally
				}
				if (!$dp) {																			// day has not been added
					// what to do
					$rt3l_short=date('Ymd',$d);												// get current day as YYYYMMDD so we can find events or compare to today
					$dateformat=date($this->format, $d);									// format date 
					// *** adding top part: button
					if ($this->addbtn) {															// if add permissions given
						$datetxt=rt3h_button("addevent[$rt3l_short]",loc_btn_addevent);// create button
						$datetxt=rt3h_div($datetxt,'newevent');
					}
					// *** adding top part: date
					$datetxt.=rt3h_div($dateformat,'date');								// add date
					$events=null;
					if (isset($this->event[$rt3l_short])) {
						//echo "set for $rt3l_short";
						$elist=$this->event[$rt3l_short];
						//echo " count ".count($elist);
						//var_dump ($elist);
						//exit();
						for ($k=0; $k<count($elist); $k++)
							$events.=rt3h_div($elist[$k],'event');
					}
					$datetxt.=$events;
					if ($rt3l_short==$t) {
						$tid='id="today"';
					}
					else {
						$tid=null;
					}
					$this->table->addcell($datetxt,$tid);									// add event to table
					$datetxt=null;
				}
				$d=strtotime("+1 day", $d);
			}
		}
		$this->table->setattributes(0,0,array('id'=>'calendar'));
		return $this->table->html();
	}
}
	



class rtCal {
	private $sd;                // start date in unix time form
	private $wks;               // number of weeks
	private $month;             // 0-weeks only, 1-12 for month
	private $events;            // events in array [Ymd] form
	private $mode;              // 0-regular, 1-mobile, 2-xml
	private $special;           // array for special days if used
	private $table;             // table to print out calendar
	private $addper;            // if add permissions are enabled;
	private $format;            // date formatting
	private $today;             // set today in calendar as unix
	
	// construct, takes starting day, weeks (0/month) and mode and start day (if month)
	function __construct ($date, $weeks=0, $mode=0, $start=0) {
		if ($weeks!=1 && $mode==1) die ("only 1 week for mobile");
		$this->mode=$mode;
		$this->addper=false;
		if ($weeks>0) {  //*********** range
			$this->format="M j";
			$this->sd=$date;
			$this->wks=$weeks;
			$this->month=0;
		} else {        //************ calendar
			$this->format="j";
			$this->month=date("n", $date);
			$this->wks=5;  
				// getting last day of the month
			$finalday=mktime(0,0,-1,$this->month+1,1,date('Y',$date));
			$fd['n']=date('d',$finalday);
			$fd['d']=date('w',$finalday);
			//echo "$fd[n] - $fd[d]";
			//exit();
			if ($fd['n']==28 && $fd['d']==6) $this->wks--;  // if Feb 28 is on Sat (no leap year), only need 4 wks
			if ($fd['n']==31 && $fd['d']<2) $this->wks++;   // if normal 31d month final day is Sun or Mon, add a week
			if ($fd['n']==30 && $fd['d']<1) $this->wks++;   // if normal 30d month final day is Sun, add a week
			$wkday=date("w", $date);
			if ($start<0) $start+=7;
			if ($wkday!=$start) {
				$db=$wkday-$start;
				if ($db<0){
					$db+=7;
					$this->wks++;
				}
				$date-=$db*86400;
			}
			$this->sd=$date;
		}

		$this->table=new rtTable (7,($this->wks));
		$this->table->setAtt("calendar",'id','a','a');
	}
	// set today in calendar
	public function today ($v) {$this->today=$v;}
	// to add/remove permissions
	public function per ($v=false) { $this->addper=$v; }
	// to set special day of the week
	public function specday ($v) {$this->special[$v]="reset"; }
	// to set event. takes it in unix time
	public function event ($date, $desc) {
		$d=date("Ymd",$date);
		$this->event[$d][]=html_div($desc, 'event');
	}
	// set formatting
	public function format($s) {$this->format=$s;}
	// print table
	public function get($header=null, $nav=1) { 
		//if (is_null($header)){
		//	if ($this->month>0) $header= month
		$output=html_tag('h2',$header).BR;
		$row=0; $col=0;
		for ($i=$this->sd+(86400/2); $i<$this->sd+7*86400+(86400/2); $i+=86400) {
			$ds=date("w",$i);
			$dl=date("l",$i);
			$this->table->addHead($dl, $this->special[$ds]);
		}
		for ($i=$this->sd+(86400/2); $i<$this->sd+($this->wks*7)*86400+(86400/2); $i+=86400) { // have to do it from noon to avoid DST
			$tds=date("Ymd", $i);
			$tdm=date("n", $i);
			$tdl=date($this->format, $i);
			$tdi=date("Y-m-d", $i);
			if ($this->month>0 && $tdm != $this->month) {
				$this->table->addCell('&nbsp;','empty');
			} else {
				$daycell='';
				if ($this->addper) { // create new form
					// old way. crete 3 fields for each button
					$calform=new rtForm ();
					$calform->addinput('view','event');
					$calform->nl();
					$calform->addinput("formdata[date]",$tdi);
					$calform->nl();
					$calform->addinput('submit','+', "submit");
					$calform->nl();
					$daycell=$calform->get();
					unset ($calform);
				}
				$daycell=html_div($daycell, 'newevent').NL;
				$daycell.=html_div($tdl, 'date').NL;
				if (isset($this->events[$tds])) {
					$daycell.=NL;
					$dayevent=$this->events[$tds];
					$daycell.=implode (BR,$dayevent);
					unset ($dayevent);
				}
				
				if ($tds == date("Ymd", $this->today)) $datt['id']="today"; else $datt['id']='';
				$this->table->addCell($daycell, null, $datt);
			}
		}
		$output .= $this->table->get();
		// if nav is on, add nav bars
		return $output;
	}
}
?>
