<?php 
/*******************************************************************************
 * writedb.php
 *******************************************************************************
 * This is to write to database
 ******************************************************************************/
include_once RT_LU."db.php";													// include user DB file
//include RT_LS."db.php";														// include DB file
$rt3db_main=new rt3cl_db($rt3db_loc[0],$rt3db_user[0],$rt3db_pass[0],$rt3db_db[0]);
// *** to get structure in *****************************************************
$rt3i_dbl=$rt3fi_dbfield[prefix][0];											// local tables
$rt3i_dbs=$rt3fi_dbfield[prefix][1];											// linked/shared tables
$rt3i_dbstruct[]=<<<EOT
CREATE TABLE `${rt3i_dbl}dkplist` (
  `did` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'dkp transaction ID',
  `aid` int(10) unsigned NOT NULL COMMENT 'link to account id',
  `eid` int(10) unsigned NOT NULL COMMENT 'link to event id',
  `type` tinyint(3) unsigned NOT NULL COMMENT 'transaction type award/purchase/penalty',
  `points` float NOT NULL DEFAULT '0' COMMENT 'points in transaction (include sign)',
  `desc` text COMMENT 'description',
  PRIMARY KEY (`did`),
  KEY `aid` (`aid`,`eid`)
)
EOT;
$rt3i_dbstruct[]=<<<EOT
CREATE TABLE `${rt3i_dbl}dkpt` (
  `aid` int(10) unsigned NOT NULL COMMENT 'account id',
  `dkp` float NOT NULL DEFAULT '0' COMMENT 'total dkp',
  PRIMARY KEY (`aid`)
)
EOT;
$rt3i_dbstruct[]=<<<EOT
CREATE TABLE `${rt3i_dbl}event` (
  `eid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'event ID',
  `ts` datetime NOT NULL COMMENT 'start time',
  `te` datetime NOT NULL COMMENT 'end time',
  `ti` datetime NOT NULL COMMENT 'invite time',
  `tcs` datetime NOT NULL COMMENT 'close subscriptions',
  `tcw` datetime NOT NULL COMMENT 'close withdrawls',
  `loc` varchar(20) NOT NULL COMMENT 'location icon',
  `name` varchar(50) NOT NULL COMMENT 'name of event',
  `vn` text COMMENT 'visual note',
  `pn` text COMMENT 'plan note',
  `level` smallint(5) unsigned DEFAULT NULL COMMENT 'level ',
  `total` smallint(5) unsigned DEFAULT NULL COMMENT 'total required',
  `role` varchar(100) DEFAULT NULL COMMENT 'roles needed with / separated',
  `leader` int(10) unsigned DEFAULT NULL COMMENT 'leader: link to aid',
  PRIMARY KEY (`eid`),
  UNIQUE KEY `eid` (`eid`),
  KEY `ts` (`ts`,`loc`)
)
EOT;
$rt3i_dbstruct[]=<<<EOT
CREATE TABLE `${rt3i_dbl}event` (
  `eid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'event ID',
  `ts` datetime NOT NULL COMMENT 'start time',
  `te` datetime NOT NULL COMMENT 'end time',
  `ti` datetime NOT NULL COMMENT 'invite time',
  `tcs` datetime NOT NULL COMMENT 'close subscriptions',
  `tcw` datetime NOT NULL COMMENT 'close withdrawls',
  `loc` varchar(20) NOT NULL COMMENT 'location icon',
  `name` varchar(50) NOT NULL COMMENT 'name of event',
  `vn` text COMMENT 'visual note',
  `pn` text COMMENT 'plan note',
  `level` smallint(5) unsigned DEFAULT NULL COMMENT 'level ',
  `total` smallint(5) unsigned DEFAULT NULL COMMENT 'total required',
  `role` varchar(100) DEFAULT NULL COMMENT 'roles needed with / separated',
  `leader` int(10) unsigned DEFAULT NULL COMMENT 'leader: link to aid',
  PRIMARY KEY (`eid`),
  UNIQUE KEY `eid` (`eid`),
  KEY `ts` (`ts`,`loc`)
)
EOT;
$rt3i_dbstruct[]=<<<EOT
CREATE TABLE `${rt3i_dbl}locset` (
  `aid` int(10) unsigned NOT NULL COMMENT 'account id',
  `grank` smallint(3) unsigned DEFAULT NULL COMMENT 'guild rank',
  `rtrank` smallint(3) unsigned DEFAULT NULL COMMENT 'RT Privs',
  `fdate` varchar(10) NOT NULL DEFAULT 'Y-m-d' COMMENT 'format of date',
  `ftime` varchar(10) NOT NULL DEFAULT 'H:i',
  `view` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'view on home page',
  `tos` datetime DEFAULT NULL COMMENT 'Date TOS accepted',
  `theme` varchar(30) DEFAULT NULL COMMENT 'theme used',
  `offset` decimal(4,2) NOT NULL DEFAULT '0.00' COMMENT 'hour offset by user from RT',
  `active` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'set active',
  PRIMARY KEY (`aid`)
)
EOT;
$rt3i_dbstruct[]=<<<EOT
CREATE TABLE `${rt3i_dbl}log` (
  `code` smallint(5) unsigned NOT NULL COMMENT 'code/category of transaction',
  `ref` int(10) unsigned DEFAULT NULL COMMENT 'id link',
  `date` datetime NOT NULL COMMENT 'date of transaction',
  `acct` varchar(20) DEFAULT NULL COMMENT 'person/ip address',
  `desc` text NOT NULL COMMENT 'description'
)
EOT;
$rt3i_dbstruct[]=<<<EOT
CREATE TABLE `${rt3i_dbl}privs` (
  `cat` varchar(25) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL COMMENT 'Category',
  `name` varchar(50) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL COMMENT 'Name of priv',
  `level` tinyint(4) NOT NULL COMMENT 'permission level',
  `desc` text CHARACTER SET latin1 COLLATE latin1_general_ci COMMENT 'description',
  KEY `cat` (`cat`),
  KEY `name` (`name`)
)
EOT;
$rt3i_dbstruct[]=<<<EOT
CREATE TABLE `${rt3i_dbl}rtkeys` (
  `cat` varchar(25) NOT NULL COMMENT 'category',
  `sn` varchar(25) NOT NULL COMMENT 'short name',
  `ln` varchar(200) DEFAULT NULL COMMENT 'long name',
  `desc` text COMMENT 'description',
  KEY `cat` (`cat`,`sn`)
)
EOT;
$rt3i_dbstruct[]=<<<EOT
CREATE TABLE `${rt3i_dbl}sub` (
  `sid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'subscription id',
  `aid` int(10) unsigned NOT NULL COMMENT 'link to account id',
  `cid` int(10) unsigned NOT NULL COMMENT 'link to character id',
  `eid` int(10) unsigned NOT NULL COMMENT 'link to character id',
  `role` tinyint(3) unsigned NOT NULL COMMENT 'link to id for role',
  `status` varchar(20) NOT NULL COMMENT 'status of subscription',
  `vn` text COMMENT 'visual note',
  `pn` text COMMENT 'plan note',
  PRIMARY KEY (`sid`),
  KEY `aid` (`aid`,`cid`,`eid`)
)
EOT;
if ($rt3fi_type !=2) {															// do not use if linked tables
$rt3i_dbstruct[]=<<<EOT
CREATE TABLE `${rt3i_dbs}account` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'account id',
  `email` varchar(50) NOT NULL COMMENT 'e-mail addy',
  `main` int(10) unsigned NOT NULL COMMENT 'link to main cid',
  `pass` varchar(256) DEFAULT NULL COMMENT 'password',
  PRIMARY KEY (`aid`),
  UNIQUE KEY `email` (`email`,`main`)
)
EOT;
$rt3i_dbstruct[]=<<<EOT
CREATE TABLE `${rt3i_dbs}akeys` (
  `cat` varchar(25) NOT NULL COMMENT 'category',
  `sn` varchar(25) NOT NULL COMMENT 'short name',
  `ln` varchar(200) DEFAULT NULL COMMENT 'long name',
  `desc` text COMMENT 'description',
  KEY `cat` (`cat`,`sn`)
)
EOT;
$rt3i_dbstruct[]=<<<EOT
CREATE TABLE `${rt3i_dbs}character` (
  `cid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'character id',
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'name of character',
  `aid` int(10) unsigned NOT NULL COMMENT 'link to account',
  `level` smallint(5) unsigned NOT NULL COMMENT 'level of character',
  `role` varchar(20) NOT NULL COMMENT 'link to role id',
  `class` varchar(20) NOT NULL COMMENT 'class',
  `note` text COMMENT 'notes',
  PRIMARY KEY (`cid`),
  UNIQUE KEY `name` (`name`),
  KEY `aid` (`aid`)
)
EOT;
}
for ($i=0; $i<count($rt3i_dbstruct); $i++)										// go thru each table
	$rt3db_main->query($rt3i_dbstruct[$i]);										// make structure
rt3f_success(900); 																// success for database structure completed
// *** to import data in *******************************************************

?>