<?php
/*******************************************************************************
 * corefile.php
 * -----------------------------------------------------------------------------
 * list of core files to be included. must be included for all purposes
 ******************************************************************************/
// define version
define ("RT_VERSION_INT","3.02");
define ("RT_VERSION","3.02.1");
// define constant path vars
define ("RT_WEBPATH", (strlen(dirname($_SERVER['SCRIPT_NAME']))==1?null:dirname($_SERVER['SCRIPT_NAME']))."/"  ); // path on the web-- checks if root or not
define ("RT_SYSPATH", dirname(__FILE__) ."/"); // path on local server

// ------------------------------ local, relevant directories
define ("RT_S", "rt3-core/");
define ("RT_V", "rt3-view/");
define ("RT_L", "rt3-lib/");
define ("RT_C", "rt3-classes/");
define ("RT_I", "images/");
define ("RT_U", "user/");
define ("RT_A", "addons/");
define ("RT_M", "rt3-modules/");
define ("RT_F", "rt3-forms/");
define ("RT_N", "install/");													// n: new for install only
define ("RT_T", "theme/"); 

// ------------------------------ macro constants
// system
define ("RT_LS", RT_SYSPATH . RT_S);
define ("RT_WS", RT_WEBPATH . RT_S);
// view
define ("RT_LV", RT_SYSPATH . RT_V);
define ("RT_WV", RT_WEBPATH . RT_V);
// library
define ("RT_LL", RT_SYSPATH . RT_L);
define ("RT_WL", RT_WEBPATH . RT_L);
// classes
define ("RT_LC", RT_SYSPATH . RT_C);
define ("RT_WC", RT_WEBPATH . RT_C);
// images
define ("RT_LI", RT_SYSPATH . RT_I);
define ("RT_WI", RT_WEBPATH . RT_I);
// user files
define ("RT_LU", RT_SYSPATH . RT_U);
define ("RT_WU", RT_WEBPATH . RT_U);
// forms (process)
define ("RT_LF", RT_SYSPATH . RT_F);
define ("RT_WF", RT_WEBPATH . RT_F);
// install
define ("RT_LN", RT_SYSPATH . RT_N);
define ("RT_WN", RT_WEBPATH . RT_N);
// addons
define ("RT_LA", RT_SYSPATH . RT_A);
define ("RT_WA", RT_WEBPATH . RT_A);
// modules
define ("RT_LM", RT_SYSPATH . RT_M);
define ("RT_WM", RT_WEBPATH . RT_M);
// themes
define ("RT_LT", RT_SYSPATH . RT_T);
define ("RT_WT", RT_WEBPATH . RT_T);

// files to include
require RT_LL ."html.php";    // HTML tags
require RT_LL ."corelib.php"; // Core functions
include RT_LS ."error.php";
include RT_LS ."time.php";
include RT_LC ."table.php";
include RT_LS ."db.php";

/* if not install load prefs */
if (!file_exists(RT_LN."index.php")) {
	require RT_LU ."rt.php"; // RT prefs
	include RT_LL ."rank.php";
	include RT_LL ."role.php";
	include RT_LL ."class.php";
	include RT_LL ."status.php";
	include RT_LL ."location.php";
	if (file_exists(RT_LU."addons.php")) include RT_LU."addons.php";
}
require RT_LU ."local.php";   // localization. loads last so to check what needs to be localized
if (file_exists(RT_LU."addons.php")) include RT_LU."addons.php";
?>