<?php
//---- get game pack details
$rta_gamepack=file(_RT_SYS_INSTALL."/$rtv_pack.rtp");
if (!$rta_gamepack) $rts_internal['message']="Could not find game pack.  Not installing any instances/classes";
if ($rtv_install=="upgrade") {
	//bypass checks for upgrade
} else {
	if ($rtv_dbpass!=$rtv_dbpassc) {
		$rts_internal['message'].="Database passwords didn't match";
		include "install/step2.php";
		return;
	} else if (!$rtv_server || !$rtv_dbuser || !$rtv_dbname || !$rtv_dbprefix) {
		$rts_internal['message'].="Database fields missing data";
		include "install/step2.php";
		return;
	} else if (!$rtv_sdomain || !$rtv_spath) {
		$rts_internal['message'].="Server fields missing data";
		include "install/step2.php";
		return;
	}
	$rts_internal['main']="<h1>Setting up database</h1>\n<p>Please wait while we set up the database...</p>\n";
	if (!($rta_file=fopen(_RT_SYS_HOME ."user/db.php","w"))) {  //open db.php for writing
		$rts_internal['main'].="<p>File could not be created:  Please check that the /user folder is write accessible, and then hit Refresh to continue</p>";
		return;
	}
	// write database info in db.php
	fwrite ($rta_file, "<?php\n");
	fwrite ($rta_file, '$rts_dbserver="'.$rtv_server."\";\n");
	fwrite ($rta_file, '$rts_dbuser="'.$rtv_dbuser."\";\n");
	fwrite ($rta_file, '$rts_dbpass="'.$rtv_dbpass."\";\n");
	fwrite ($rta_file, '$rts_db="'.$rtv_dbname."\";\n");
	fwrite ($rta_file, '$rts_dbprefix="'.$rtv_dbprefix."\";\n");
	fwrite ($rta_file, "?>\n");
	fclose ($rta_file);
	$rts_internal['main'].="<p>Database settings successful</p>\n";
}
// now to include files to create DB table
include_once _RT_SYS_HOME ."user/db.php";
require_once _RT_SYS_INC ."rti-db.php";

$rta_dbconn=mysql_connect($rts_server,$rts_dbuser,$rts_dbpass);
if (!$rta_dbconn) {
	$rts_internal['main'].="<p>Could not open database server.  Please check your settings and then try again</p>";
	return;
}
if (!mysql_select_db($rts_db)) {
	$rts_internal['main'].="<p>Database not found or cannot be opened.  Please check your settings and try again</p>";
	return;
}
if ($rtv_install=='upgrade') {
	$rta_privs=rtd_selcol($rts_dbprefix."account",'rtrank',"email='$rtv_email'");
	if ($rta_privs!='1') {
		$rts_internal['message'].="Invalid account info or does not have privileges to upgrade.";
		include RTS_INSTALL ."/step2.php";
		return;
	}
}
if ($rtv_install=='install') {
//------ set up tables
//raid_account
$rta_table['acct']="CREATE TABLE IF NOT EXISTS `".$rtv_dbprefix."account` (
  `id` smallint(1) unsigned NOT NULL auto_increment COMMENT 'account id',
  `email` varchar(40) NOT NULL COMMENT 'email address',
  `guildrank` tinyint(3) unsigned NOT NULL COMMENT 'rank in guild',
  `rtrank` tinyint(3) unsigned NOT NULL COMMENT 'rank in rtracker',
  `main` varchar(30) NOT NULL,
  `datef` varchar(10) NOT NULL default 'l Y-m-d' COMMENT 'date format',
  `timef` varchar(10) NOT NULL default 'H:i' COMMENT 'time format',
  `settings` varchar(20) NOT NULL default 'c0' COMMENT 'Settings',
  `view` char(1) NOT NULL default 'c' COMMENT 'Calendar/history view',
  `tos` char(1) NOT NULL default '1' COMMENT 'Version of TOS accepted',
  `theme` varchar(20) NULL COMMENT 'RaidTracker personal theme',
  `tsoffset` float NOT NULL default '0' COMMENT 'Personal time offset from server',
  `dayoffset` int(1) NOT NULL default '0' COMMENT 'Personal day offset in calendar',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `main` (`main`)
)";

$rta_table['char']="CREATE TABLE `".$rtv_dbprefix."char` (
  `id` smallint(5) unsigned NOT NULL auto_increment COMMENT 'character id',
  `char` varchar(30) NOT NULL COMMENT 'character name',
  `account` smallint(6) NOT NULL COMMENT 'link to account',
  `level` smallint(6) COMMENT 'character level',
  `class` varchar(5) NOT NULL COMMENT 'character class',
  `role` tinyint(3) unsigned NOT NULL COMMENT 'primary role of character',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `char` (`char`)
)";

$rta_table['hist']="CREATE TABLE `".$rtv_dbprefix."hist` (
  `id` int(10) unsigned NOT NULL auto_increment COMMENT 'transaction id',
  `category` varchar(20) NOT NULL COMMENT 'category of change',
  `ref` smallint(5) unsigned NOT NULL default '0' COMMENT 'reference to change',
  `date` datetime NOT NULL COMMENT 'date/time of this occurance',
  `person` smallint(5) unsigned NOT NULL COMMENT 'Who did change (id)',
  `reason` varchar(200) NOT NULL COMMENT 'what reason for the change',
  `perm` tinyint(3) unsigned NOT NULL COMMENT 'Permissions to see this',
  PRIMARY KEY  (`id`),
  KEY `category` (`category`,`person`)
)";
$rta_table['keys']="CREATE TABLE IF NOT EXISTS `".$rtv_dbprefix."keys` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `category` varchar(20) NOT NULL COMMENT 'category for set of keys',
  `name` varchar(200) default NULL COMMENT 'name',
  `value` varchar(25) default NULL COMMENT 'value for item',
  PRIMARY KEY  (`id`)
)";
$rta_table_ins['keys']="INSERT INTO `".$rtv_dbprefix."keys` (`category`, `name`, `value`) VALUES
('guild', 'Guildmaster',''),
('guild', 'Officer',''),
('guild', 'Raider',''),
('guild', 'Member',''),
('guild', 'Trialist',''),
('rt', 'Administrator',''),
('rt', 'Raid planner',''),
('rt', 'Officer',''),
('rt', 'Member',''),
('rt', 'Trial',''),
('news_head', NULL, 'headline for news'),
('news', NULL, 'news text'),
('news_author', 1, 'Author of news'),
('news_time', 0, 'Unix time of news'),
('RT_system', 'version', '". RTS_VERSION ."'),
('rt', 'Nobody', null),
('raid_instance', 'none','Other')";

$rta_table['list']="CREATE TABLE `".$rtv_dbprefix."list` (
  `id` smallint(5) unsigned NOT NULL auto_increment COMMENT 'id of raid',
  `date` datetime NOT NULL COMMENT 'date and time raid starts',
  `endtime` datetime NOT NULL COMMENT 'ending time',
  `freezenew` datetime NOT NULL COMMENT 'close time for new subscriptions',
  `freezedel` datetime NOT NULL COMMENT 'close time for withdrawing',
  `inv` datetime NOT NULL COMMENT 'invite time',
  `icon` varchar(5) NOT NULL COMMENT 'raid instance icon',
  `instance` varchar(35) NOT NULL COMMENT 'instance',
  `note` varchar(200) default NULL COMMENT 'any extra notes',
  `required` tinyint(3) unsigned NOT NULL COMMENT 'how many required',
  `roles` varchar(15) default NULL COMMENT 'different roles separated by /',
  `offnote` varchar(225) default NULL COMMENT 'officers note on raid',
  PRIMARY KEY  (`id`),
  KEY `date` (`date`)
)";

$rta_table['perm']="CREATE TABLE IF NOT EXISTS `".$rtv_dbprefix."permission` (
  `class` varchar(20) NOT NULL COMMENT 'RaidTracker class',
  `property` varchar(50) NOT NULL COMMENT 'property in RaidTracker',
  `value` varchar(20) NOT NULL COMMENT 'yes/no to property',
  `desc` varchar(100) NOT NULL COMMENT 'description of property',
  UNIQUE KEY `property` (`property`)
)";

$rta_table_ins['perm']="INSERT INTO `".$rtv_dbprefix."permission` (`class`, `property`, `value`, `desc`) VALUES
('account', 'grank_alter', '1', 'Promotes/Demotes players with guild rank'),
('account', 'rtrank_alter', '1', 'Promote/Demotes player''s with RT permissions'),
('account', 'player_delete', '1', 'Deletes players'),
('account', 'guildrank_start', '5', 'New accounts: starting guild rank'),
('account', 'rtrank_start', '5', 'New accounts: starting RT rank'),
('account', 'player_alter', '-1', 'Who can modify a player''s character and account info'),
('account', 'character_add', '-2', 'Add a character to an account'),
('account', 'character_name', '-1', 'Change a character''s name'),
('account', 'character_role', '-3', 'Change default role for a character'),
('account', 'character_level', '-2', 'Allows level to be altered'),
('account', 'character_main', '1', 'Allows change of main character'),
('account', 'character_delete', '-2', 'Deletes characters'),
('account', 'character_class', '-2', 'Allows character class to be modified'),
('general', 'raid_create', '3', 'Who can create raids'),
('general', 'rank_alter', '2', 'Who can alter the <em>names</em> of ranks'),
('general', 'permission_alter', '1', 'Who can alter the permissions (this screen)'),
('general', 'admin_view', '3', 'Who can view the administration menu'),
('general', 'update_news', '3', 'Updating the newsbox'),
('general', 'view_log', '3', 'Viewing the log'),
('general', 'log_clear', '1', 'Allows clearing of the log'),
('general', 'show_settings', '1', 'Allows system wide settings to be modified'),
('manage', 'raid_alter', '3', 'Altering the raid info (not the lists)'),
('manage', 'wb_publish', '2', 'Publishing the whiteboard list'),
('manage', 'wb_erase', '2', 'Clearing the whiteboard list'),
('manage', 'list_delete', '1', 'Deleting players from signups'),
('manage', 'list_raidlist', '2', 'Moving players to the raid list'),
('manage', 'list_wb', '3', 'Moving players to the whiteboard'),
('manage', 'list_available', '3', 'Moving players to ''Available'' status'),
('manage', 'list_reserve', '3', 'Moving players to ''Reserve'' status'),
('manage', 'list_withdraw', '3', 'Moving players to withdraw status'),
('manage', 'list_remove', '1', 'Moving players to ''remove'' status'),
('manage', 'list_move', '3', 'Moving players permission'),
('manage', 'edit_publicnote', '2', 'Editing the note of players'),
('manage', 'edit_officernote', '3', 'Editing the officer''s note'),
('manage', 'change_alt', '3', 'Changing player''s alt'),
('manage', 'change_role', '3', 'Changing the role of the character'),
('manage', 'subscription_alter', '3', 'Allow altercations with players'' subscriptions'),
('signup', 'sign_raidlist', '0', 'Subscribe directly to the raid list'),
('signup', 'signup_override', '3', 'Can override the freeze cutoff'),
('signup', 'list_addchar', '3', 'Allows a character to be added to list'),
('signup', 'sign_alt', '3', 'Allows signup with alts'),
('view', 'show_grank', '5', 'shows guild rank on the guild list'),
('view', 'show_rtrank', '3', 'Shows RT rank on the guild list'),
('view', 'show_stats', '-3', 'Shows stats on the player page (and the guild list if not overriden by self)'),
('view', 'show_email', '1', 'Shows e-mail addresses on the guild list'),
('view', 'view_officernote', '3', 'Viewing the officer note in raid info and for players (in signup lists)'),
('view', 'show_raidlist', '11', 'Reveals the Raid list'),
('view', 'show_available', '11', 'Reveals the available list'),
('view', 'show_reserve', '11', 'Reveals the reserve list'),
('view', 'show_withdraw', '11', 'Reveals the withdraw list'),
('view', 'show_remove', '3', 'Reveals the removed list'),
('view', 'show_whiteboard', '3', 'Reveals the whiteboard'),
('view', 'show_tables', '11', 'Reveals the signup tables'),
('view', 'view_playernote', '5', 'Displays the (public) player note'),
('custom', 'rofp_main', '0', 'View and edit custom control panel')";

$rta_table['sign']="CREATE TABLE `".$rtv_dbprefix."sign` (
  `id` int(10) unsigned NOT NULL auto_increment COMMENT 'entry id',
  `charid` smallint(5) unsigned NOT NULL COMMENT 'id to account',
  `char` smallint(4) NOT NULL COMMENT 'id to character name',
  `raidid` smallint(5) unsigned NOT NULL COMMENT 'id to raid',
  `role` varchar(30) NOT NULL COMMENT 'role played in this raid',
  `status` tinyint(4) NOT NULL COMMENT 'status with this raid',
  `note` varchar(200) default NULL COMMENT 'any notes here',
  `offnote` varchar(200) default NULL COMMENT 'officers note on signup',
  `signup` datetime NOT NULL COMMENT 'date/time signed up',
  `modified` datetime NOT NULL COMMENT 'date/time last modified',
  PRIMARY KEY  (`id`),
  KEY `charid` (`charid`,`raidid`),
  KEY `char` (`char`)
)";
//include file for instances.

} else {  //upgrade only:
 // ---- update table structure
$rta_table[]="ALTER TABLE `". $rts_dbprefix."account` ADD (
`view` char(1) NOT NULL DEFAULT 'c' COMMENT 'Calendar or history view',
`tos` char(1) NOT NULL DEFAULT '1' COMMENT 'version of TOS accepted',
`theme` varchar(20) NULL COMMENT 'Personal RT theme',
`tsoffset` float NOT NULL COMMENT 'individual timezone offset from server',
`dayoffset` tinyint(4) NOT NULL COMMENT 'individual day offset in calendar mode')";
$rta_table[]="ALTER TABLE `".$rts_dbprefix."keys` MODIFY `value` (varchar(25) default NULL COMMENT 'value for name')";
$rta_table[]="ALTER TABLE `".$rts_dbprefix."sign` MODIFY `char` (smallint(4) NOT NULL COMMENT 'id to character name')";
 // ---- update table info
 // -- fix key table
$rta_table_ins[]="DELETE FROM `".$rts_dbprefix."keys` WHERE `category`='raid_instance'"; //remove instances to repop with wow.txt
$rta_table_ins[]="DELETE FROM `".$rts_dbprefix."keys` WHERE `category`='class'"; //remove classes
$rta_table_ins[]="INSERT INTO `".$rts_dbprefix."keys` (`category`,`name`,`value`) 'raid_instance','none','Other'"; //Adds in none
$rta_table_ins[]="UPDATE `".$rts_dbprefix."keys` SET `value`='2.1' WHERE `category`='RT_system'"; // new ver of RT
 // -- fix categories in permissions
$rta_table_ins[]="UPDATE `".$rts_dbprefix."permission` SET `class`='view' WHERE `property` LIKE 'view_%' OR `property` LIKE 'show_%'";
$rta_table_ins[]="UPDATE `".$rts_dbprefix."permission` SET `class`='manage' WHERE `property` LIKE 'list_%' or `property` LIKE 'wb_%'";
$rta_table_ins[]="UPDATE `".$rts_dbprefix."permission` SET `class`='account' WHERE `property` LIKE 'player_%' OR `property` LIKE 'character_%'";
$rta_table_ins[]="UPDATE `".$rts_dbprefix."permission` SET `class`='general' WHERE `property` IN 
('raid_create','rank_alter','permissions_alter','admin_view','update_news','view_log','log_clear','show_settings')";
$rta_table_ins[]="UPDATE `".$rts_dbprefix."permission` SET `class`='manage' WHERE `property` IN 
('edit_publicnote','edit_officernote','change_alt','change_role','raid_alter','subscription_alter')";
$rta_table_ins[]="UPDATE `".$rts_dbprefix."permission` SET `class`='signup' WHERE `property` IN 
('sign_raidlist','signup_override')";
$rta_table_ins[]="UPDATE `".$rts_dbprefix."permission` SET `class`='account' WHERE `property` IN 
('grank_alter','rtrank_alter', 'player_delete','guildrank_start','rtrank_start')";
 // -- add 2.1 specific permissions
$rta_table_ins[]="INSERT INTO `".$rts_dbprefix."permission` (`class`,`property`,`value`,`desc`) "
."('custom','rofp_main','0','To edit/view custom control panel')," //Adds in custom panel option
."('account','character_class','-2','Allows character class to be modified')," 
."('general','show_setttings','1','Allow system-wide settings to be modified')"; 

}
//---- apply game pack
if ($rta_gamepack) {
	while ($rta_gamepack) {
		$rta_packinfo=addslashes(array_shift($rta_gamepack));
		$rta_instancelist.=",\n('".implode("','",explode(',',$rta_packinfo))."')";
	}
	$rta_instancelist[0]="\0";
	$rta_instancelist=trim($rta_instancelist);
	$rta_table_ins[]="INSERT INTO ".$rts_dbprefix."keys (`category`,`name`,`value`) VALUES \n".$rta_instancelist;
}

//---- put values in tables
foreach ($rta_table as $v) 
	$a=rtd_query($v);
foreach ($rta_table_ins as $v) {
	$a=rtd_query($v);
	if (!$a) die ("Failed on $v");
}

$rta_form=input('server[domain]','hidden',$rtv_sdomain);
$rta_form.=input('server[path]','hidden',$rtv_spath);
$rts_internal['main'].="<p>Database tables created</p>\n";
$rta_form.=button('button','Continue');
$rta_form.=input('install','hidden',$rtv_install);
$rta_form.=input('step','hidden','3');
$rts_internal['main'].=form(div($rta_form),'.','post');
?>
