<?php
/**********************************************************************
 * rt-lists.php
 **********************************************************************
 * Ver. 2.0 style of displaying the lists
 **********************************************************************/
// Listchar:
// charid = id of char (char from raid_sign)
// role = role chosen (0=hide)
// chkbox = if checkbox is shown, the record in raid_sign (0=none)
// stat = show signup status (0=hide)
function rtf_listchar($charid, $role, $chkbox, $stat) {
	$rta_html='';
	if ($chkbox)
		$rta_html="<input type=\"checkbox\" name=\"rec[]\" value=\"$chkbox\" />";
	if ($stat)
		$rta_html.=rtf_statusicon($stat,0,0);
	$rta_html.=rtf_char($charid, $role);
	return $rta_html;
}
function rtf_showchar($rowid, $hidecheckbox=0, $showstatus=1, $showrole=1) {
	$rta_info=rtd_select('raid_sign','*',"id=$rowid");
	if ($showstatus===true) $showstatus=$rta_info['status'];
	if ($showrole) $showrole=$rta_info['role'];
	if ($hidecheckbox) $rta_row=0; else $rta_row=$rowid;
	$rta_html=rtf_listchar($rta_info['char'], $showrole, $rta_row, $showstatus);
	if (rtf_p('view_playernote',$rta_info['charid']) && $rta_info['note'])
		$rta_html.=br().rtf_offnote($rta_info['note']);
	if (rtf_p('view_officernote',$rta_info['charid']) && $rta_info['offnote'])
		$rta_html.=br().rtf_offnote($rta_info['offnote'],'o');
	return $rta_html;
}
function rtf_statuslist($raid, $status) {
	if (is_array($status)) $status="raid_sign.status IN (".implode(',', $status).")";
	else $status="raid_sign.status=$status";
	$rta_info=rtd_select('raid_sign, raid_char','raid_sign.*, raid_char.char, raid_char.class',
	"raid_char.id=raid_sign.char AND $status AND raid_sign.raidid=$raid",
	"ORDER BY raid_sign.role ASC, raid_char.class ASC, raid_char.char ASC",1);
	return $rta_info;
}
function rtf_tableopt($wb) {
	$rta_htm='';
	//------------------------------- Whiteboard
	if (rtf_p('wb_publish') && $wb)
		$rta_htm.='<input class="btn" type="submit" name="whiteboard" value="Publish" />';
	if (rtf_p('wb_erase') && $wb)
		$rta_htm.=' <input class="btn" type="submit" name="whiteboard" value="Erase" />';
	if ($rta_htm) $rta_htm="<h3>Whiteboard options:</h3> $rta_htm".br();
	$rta_htm.="Selected members will be modified.  ";
	if (rtf_p('list_addchar')) {
		$rta_htm.= //"<input type=\"checkbox\" name=\"apply[name]\" value=\"new\" />"
		"Add a new <strong>player</strong>: ";
		$rta_htm.="<select name=\"newplayer\">\n";
		$t=rtd_select('raid_account','id, main','','ORDER BY main',1);
		$rta_htm.="<option value=\"0\">---select---</option>\n";
		foreach ($t as $v) {
			$rta_htm.="<option value=\"$v[id]\">$v[main]</option>\n";
		}
		$rta_htm.="</select>".br();
	}
	if (rtf_p('list_move')) {
		$rta_htm.= //"<input type=\"hidden\" name=\"apply[move]\" value=\"move\" />"
		"Move to: <select name=\"status\">\n";
		$rta_htm.='<option value="0">--select--</option>'."\n";
		if (rtf_p('list_raidlist')) $rta_htm.= '<option value="1">Raid list</option>'."\n";
		if (rtf_p('list_wb')) $rta_htm.= '<option value="8">Whiteboard</option>'."\n";
		if (rtf_p('list_available')) $rta_htm.= '<option value="2">Available</option>'."\n";
		if (rtf_p('list_reserve')) $rta_htm.= '<option value="3">Reserve</option>'."\n";
		if (rtf_p('list_withdraw')) $rta_htm.= '<option value="4">Withdraw</option>'."\n";
		if (rtf_p('list_remove')) $rta_htm.= '<option value="5">Remove</option>'."\n";
		if (rtf_p('list_delete')) $rta_htm.= '<option value="-1">Delete</option>'."\n";
		$rta_htm.= "</select>\n".br();
	}
	if (rtf_p('change_alt')||rtf_p('change_role'))
		$rta_htm.="<input type=\"checkbox\" name=\"change\" value=\"role\" />"
		. "Change raid role or use an alt (on next screen) *".br();
	if (rtf_p('edit_publicnote'))
		$rta_htm.= "<input type=\"checkbox\" name=\"cpnote\" value=\"move\" />"
		. 'Replace public note with:  <input type="text" name="pnote" />'.br();
	if (rtf_p('edit_officernote'))
		$rta_htm.= "<input type=\"checkbox\" name=\"conote\" value=\"move\" />"
		. 'Replace officer note with: <input type="text" name="onote" />'.br();
	$rta_htm.= '<input class="btn" type="submit" name="edit" value="Submit" />'.br();
	$rta_htm="<h2>Table options</h2>\n$rta_htm</form>\n";
	return $rta_htm;

}
function rtf_listmain($raid, $override) {
	$rta_wb=rtf_p('show_whiteboard');
	$rta_edit=rtf_p('subscription_alter');
	$rta_maxraiders=rtd_selcol("raid_list",'required',"id=$raid");
	for ($i=1; $i<7; $i++) {
		if (($i==2||$i==3) && !$rta_wb)
			$rta_list[$i]=rtf_statuslist($raid, array ($i, $i+4));
		elseif ($i==6 && $rta_wb)
			$rta_list[$i]=rtf_statuslist($raid, array ($i, $i+1));
		else
			$rta_list[$i]=rtf_statuslist($raid, $i);
		$rta_count[$i]=count($rta_list[$i]);
	}
	$rta_th='';
	$rta_td='';
	if (rtf_p('show_raidlist') && $rta_count[1]) {
		addcell($rta_th,rtf_statusicon(1,0,0)."(".$rta_count[1]."/$rta_maxraiders)",'th');
		$rta_role=0;
		$rta_tmp='';
		$i=0;
		foreach ($rta_list[1] as $v) {
			$rta_rolelist[$v['role']].=div(rtf_showchar($v['id'],$override,0,0));
			$rta_rolecount[$v['role']]++;
/*
			if ($rta_role) $rta_tmp.=br();
			if ($rta_role!=$v['role']) {
				$rta_tmp.="<div class=\"role\">".rtf_role($v['role'])."</div>\n";
				$rta_role=$v['role'];
			}
			$rta_tmp.=rtf_showchar($v['id'],$override,0,0);
*/
		}
		for ($i=1; $i<5; $i++) {
			$rta_tmp.=div(rtf_role($i).' ('.$rta_rolecount[$i].')','','role');
			$rta_tmp.=$rta_rolelist[$i];
		}
		addcell($rta_td,$rta_tmp);
	}
	if (rtf_p('show_whiteboard') && $rta_count[6]) {
		addcell($rta_th,"Whiteboard (".$rta_count[6]."/$rta_maxraiders)",'th');
		$rta_role=0;
		$rta_tmp='';
		foreach ($rta_list[6] as $v) {
			if ($rta_role) $rta_tmp.=br();
			if ($rta_role!=$v['role']) {
				$rta_tmp.="<div class=\"role\">".rtf_role($v['role'])."</div>\n";
				$rta_role=$v['role'];
			}
			$rta_tmp.=rtf_showchar($v[id],$override,0,0);
		}
		addcell($rta_td,$rta_tmp);
	}
	$rta_ht='';
	$rta_tmp='';
	if (rtf_p('show_available') && $rta_count[2]) {
		$rta_ht.=rtf_statusicon(2,0,0)."-$rta_count[2] ";
		$rta_role=0;
		foreach ($rta_list[2] as $v) {
			if ($rta_role) $rta_tmp.=br();
			if ($rta_role!=$v['role']) {
				$rta_tmp.="<div class=\"role\">".rtf_role($v['role'])."</div>\n";
				$rta_role=$v['role'];
			}
			$rta_tmp.=rtf_showchar($v['id'],$override,true,0);
		}
	}
	if (rtf_p('show_reserve') && $rta_count[3]) {
		$rta_ht.=rtf_statusicon(3,0,0)."-$rta_count[3] ";
		$rta_role=0;
		foreach ($rta_list[3] as $v) {
			if ($rta_role) $rta_tmp.=br();
			if ($rta_role!=$v['role']) {
				$rta_tmp.="<div class=\"role\">".rtf_role($v['role'])."</div>\n";
				$rta_role=$v['role'];
			}
			$rta_tmp.=rtf_showchar($v[id],$override,3,0);
		}
	}
	if ($rta_ht) {
		addcell($rta_th,$rta_ht,'th');
		addcell($rta_td,$rta_tmp);
	}
	$rta_ht='';
	$rta_tmp='';
	if (rtf_p('show_withdraw') && $rta_count[4]) {
		$rta_ht.=rtf_statusicon(4,0,0)."-$rta_count[4] ";
		$rta_role=0;
		foreach ($rta_list[4] as $v) {
			if ($rta_role) $rta_tmp.=br();
			if ($rta_role!=$v['role']) {
				$rta_tmp.="<div class=\"role\">".rtf_role($v['role'])."</div>\n";
				$rta_role=$v['role'];
			}
			$rta_tmp.=rtf_showchar($v[id],$override,4,0);
		}
	}
	if (rtf_p('show_remove') && $rta_count[5]) {
		$rta_ht.=rtf_statusicon(5,0,0)."-$rta_count[5] ";
		$rta_role=0;
		foreach ($rta_list[5] as $v) {
			if ($rta_role) $rta_tmp.=br();
			if ($rta_role!=$v['role']) {
				$rta_tmp.="<div class=\"role\">".rtf_role($v['role'])."</div>\n";
				$rta_role=$v['role'];
			}
			$rta_tmp.=rtf_showchar($v[id],$override,5,0);
		}
	}
	if ($rta_ht) {
		addcell($rta_th,$rta_ht,'th');
		addcell($rta_td,$rta_tmp);
	}
	echo '<form method="post" action="."> <!-- for the modify part lists -->'.br();
	echo "<input type=\"hidden\" name=\"raidid\" value=\"$raid\" />\n";
	echo "<h1>Lists</h1>\n";
	if (!$rta_th) {
		echo "No lists available.  This can be a new raid with no signups, "
		."or there may be lists you don't have permissions to see.".br();
	} else {
		addrow($rta_tbl, $rta_th);
		addrow($rta_tbl, $rta_td);
		$rta_tbl=tbl($rta_tbl);
		echo $rta_tbl;
	}
	if (rtf_p('subscription_alter') && !$override) $rta_options=rtf_tableopt($rta_count[6]);
	echo $rta_options;
	echo "</form>\n";
}
?>