<?php
/************************************************
 * rt-char.php
 *-----------------------------------------------
 * New character list sheet
 ***********************************************/
if (!rtf_pcheck('view_log')) { rtf_error(7); return;}  //no permissions

// ------------- Check for cleared log
if ($rtv_clear) {
	rtd_query("TRUNCATE TABLE ". rts_db_hist);
	rtf_log ("log","Cleared the log");
}

//-------------- Submit table
$loglist=rtd_select(rts_db_hist,'*','',"ORDER BY `date` DESC LIMIT 100",1);

//-------------- Functions
function linkref($cat) {
	list ($rt_cat, $rt_number)=split(" ",$cat);
	switch ($rt_cat){
		case "news":
		case "character": return $rt_cat; // may need to fix that.
		case 'log':
		case 'account':
					return $rt_cat;
		case "signup":
		case "raid":
		case "raidinfo":
			$url=rts_syspath."/signup/?raidid=$rt_number";
			break;
	}
	return "<a href=\"$url\">$rt_cat</a>";
}
function rt_readreason (&$text){
	rt_ricon($text);
	rt_plist($text);
	rt_reppl($text);
	rt_raidrole($text);
}
function rt_ricon (&$t) {
	$t=preg_replace('/^(\[icon=)([1-7])(\])/', '<img src="'. rts_syspath .'/images/\2.png" alt="\2-"> ', $t);
}
//--char friendly
function rt_plist(&$t){
	$m=preg_match('/\[plist\]((([0-9]*),?)*)\[\/plist\]/',$t, $match);
	if (!$match[1]) return;
	$rta_rep=explode (",",$match[1]);
	for ($i=0; $i<count($rta_rep);$i++)
		$rta_rep[$i]=rtf_character($rta_rep[$i]);
	$rta_replist=implode (", ",$rta_rep);
	$t=preg_replace("/(\[plist\]$match[1]\[\/plist\])/", $rta_replist, $t);
}
function rt_reppl(&$t){
	while ($m=preg_match('/\[pchar\]([0-9]*)\[\/pchar\]/',$t, $match)) {
		$replstr=rtf_character($match[1]);
		$t=preg_replace("/(\[pchar\]$match[1]\[\/pchar\])/", $replstr, $t);
	}
}
function rt_raidrole(&$t) {
while ($m=preg_match ('/(\[role=)([1-4])(\])/',$t, $match))
	$t=preg_replace('/(\[role=)([1-4])(\])/', rtf_role($match[2]), $t);
}

//-------------- Character table
echo "<h1>Log</h1>\n<table>\n<tr>";
echo "<th>Category</th>";
echo "<th style=\"width: 20%\">Date/Time</th><th>Person</th><th>Reason</th></tr>\n";
foreach ($loglist as $v) {
	$rt_cat=linkref($v['category']);
	echo "<tr><td>$rt_cat</td>";
	echo "<td>$v[date]</td>";
	if ($v['person']==0) $rta_player="Web guest";
	else {
		$rta_playchar=rtf_playermatrix('acctid',$v['person']);
		for ($i=0; $i<count($rta_playchar); $i++) {
			if ($rta_playchar[$i]['charname']==$rta_playchar[0]['main']) {
				break;
			}
		}
		$rta_player=rtf_character($rta_playchar[$i]['charid'], -1,0,1);
	}
	echo "<td>$rta_player</td>";
	$v2=stripslashes($v['reason']);
	rt_readreason ($v2);
	echo "<td>$v2</td>";
	echo "</tr>\n";
}
echo "</table>\n";
if (rtf_p('log_clear')) {
	$rta_form=button('clear','Clear Log');
	$rta_form=form($rta_form, '.');
	echo $rta_form;
}
?>