<?php
if ($rtv_dbpass!=$rtv_dbpassc) {
	$_page['message']="Database passwords didn't match";
	include "install/step2.php";
	return;
} else if (!$rtv_server || !$rtv_dbuser || !$rtv_dbname || !$rtv_dbprefix) {
	$_page['message']="Database fields missing data";
	include "install/step2.php";
	return;
} else if (!$rtv_sdomain || !$rtv_spath) {
	$_page['message']="Server fields missing data";
	include "install/step2.php";
	return;
}
$_page['main']="<h1>Setting up database</h1>\n<p>Please wait while we set up the database...</p>\n";
if (!($rta_file=fopen("user/db.php","w"))) {  //open db.php for writing
	$_page['main'].="<p>File could not be created:  Please check that the /user folder is write accessible, and then hit Refresh to continue</p>";
	return;
}
// write database info in db.php
fwrite ($rta_file, "<?php\n");
fwrite ($rta_file, '$rts_dbserver="'.$rtv_server."\";\n");
fwrite ($rta_file, '$rts_dbuser="'.$rtv_dbuser."\";\n");
fwrite ($rta_file, '$rts_dbpass="'.$rtv_dbpass."\";\n");
fwrite ($rta_file, '$rts_db="'.$rtv_dbname."\";\n");
fwrite ($rta_file, '$rts_dbprefix="'.$rtv_dbprefix."\";\n");
fwrite ($rta_file, "?>\n");
fclose ($rta_file);
$_page['main'].="<p>Database settings successful</p>\n";

// now to include files to create DB table
include "user/db.php";
require "include/rti-db.php";

$rta_dbconn=mysql_connect($rtv_server,$rtv_dbuser,$rtv_dbpass);
if (!$rta_dbconn) {
	$_page['main'].="<p>Could not open database server.  Please check your settings and then try again</p>";
	return;
}
if (!mysql_select_db($rts_db)) {
	$_page['main'].="<p>Database not found or cannot be opened.  Please check your settings and try again</p>";
	return;
}
//------ set up tables
//raid_account
$rta_table['acct']="CREATE TABLE IF NOT EXISTS `".$rtv_dbprefix."account` (
  `id` smallint(1) unsigned NOT NULL auto_increment COMMENT 'account id',
  `email` varchar(40) NOT NULL COMMENT 'email address',
  `guildrank` tinyint(3) unsigned NOT NULL COMMENT 'rank in guild',
  `rtrank` tinyint(3) unsigned NOT NULL COMMENT 'rank in rtracker',
  `main` varchar(30) NOT NULL,
  `datef` varchar(10) NOT NULL default 'l Y-m-d' COMMENT 'date format',
  `timef` varchar(10) NOT NULL default 'H:i' COMMENT 'time format',
  `settings` varchar(20) NOT NULL default 'c0' COMMENT 'Settings',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `main` (`main`)
)";

$rta_table['char']="CREATE TABLE `".$rtv_dbprefix."char` (
  `id` smallint(5) unsigned NOT NULL auto_increment COMMENT 'character id',
  `char` varchar(30) NOT NULL COMMENT 'character name',
  `account` smallint(6) NOT NULL COMMENT 'link to account',
  `level` smallint(6) COMMENT 'character level',
  `class` enum('Dk','Dr','Hu','Ma','Pa','Pr','Ro','Sh','Wl','Wr') NOT NULL COMMENT 'character class',
  `role` tinyint(3) unsigned NOT NULL COMMENT 'primary role of character',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `char` (`char`)
)";

$rta_table['hist']="CREATE TABLE `".$rtv_dbprefix."hist` (
  `id` int(10) unsigned NOT NULL auto_increment COMMENT 'transaction id',
  `category` varchar(20) NOT NULL COMMENT 'category of change',
  `ref` smallint(5) unsigned NOT NULL default '0' COMMENT 'reference to change',
  `date` datetime NOT NULL COMMENT 'date/time of this occurance',
  `person` smallint(5) unsigned NOT NULL COMMENT 'Who did change (id)',
  `reason` varchar(200) NOT NULL COMMENT 'what reason for the change',
  `perm` tinyint(3) unsigned NOT NULL COMMENT 'Permissions to see this',
  PRIMARY KEY  (`id`),
  KEY `category` (`category`,`person`)
)";
$rta_table['keys']="CREATE TABLE IF NOT EXISTS `".$rtv_dbprefix."keys` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `category` varchar(20) NOT NULL COMMENT 'category for set of keys',
  `name` varchar(200) default NULL COMMENT 'name',
  `value` smallint(6) default NULL COMMENT 'value for item',
  PRIMARY KEY  (`id`)
)";
$rta_table_ins['keys']="INSERT INTO `".$rtv_dbprefix."keys` (`category`, `name`) VALUES
('guild', 'Guildmaster'),
('guild', 'Officer'),
('guild', 'Raider'),
('guild', 'Member'),
('guild', 'Trialist'),
('rt', 'Administrator'),
('rt', 'Raid planner'),
('rt', 'Officer'),
('rt', 'Member'),
('rt', 'Trial'),
('news_head', NULL),
('news', NULL),
('raid_instance', 'none'),
('raid_instance', 'aq20'),
('raid_instance', 'bt'),
('raid_instance', 'aq40'),
('raid_instance', 'bwl'),
('raid_instance', 'gruul'),
('raid_instance', 'hyj'),
('raid_instance', 'kara'),
('raid_instance', 'mag'),
('raid_instance', 'mc'),
('raid_instance', 'naxx'),
('raid_instance', 'ony'),
('raid_instance', 'sp'),
('raid_instance', 'ssc'),
('raid_instance', 'tk'),
('raid_instance', 'za'),
('raid_instance', 'zg')";

$rta_table['list']="CREATE TABLE `".$rtv_dbprefix."list` (
  `id` smallint(5) unsigned NOT NULL auto_increment COMMENT 'id of raid',
  `date` datetime NOT NULL COMMENT 'date and time raid starts',
  `endtime` datetime NOT NULL COMMENT 'ending time',
  `freezenew` datetime NOT NULL COMMENT 'close time for new subscriptions',
  `freezedel` datetime NOT NULL COMMENT 'close time for withdrawing',
  `inv` datetime NOT NULL COMMENT 'invite time',
  `icon` varchar(5) NOT NULL COMMENT 'raid instance icon',
  `instance` varchar(35) NOT NULL COMMENT 'instance',
  `note` varchar(200) default NULL COMMENT 'any extra notes',
  `required` tinyint(3) unsigned NOT NULL COMMENT 'how many required',
  `roles` varchar(15) default NULL COMMENT 'different roles separated by /',
  `offnote` varchar(225) default NULL COMMENT 'officers note on raid',
  PRIMARY KEY  (`id`),
  KEY `date` (`date`)
)";

$rta_table['perm']="CREATE TABLE IF NOT EXISTS `".$rtv_dbprefix."permission` (
  `class` varchar(20) NOT NULL COMMENT 'RaidTracker class',
  `property` varchar(50) NOT NULL COMMENT 'property in RaidTracker',
  `value` varchar(20) NOT NULL COMMENT 'yes/no to property',
  `desc` varchar(100) NOT NULL COMMENT 'description of property',
  UNIQUE KEY `property` (`property`)
)";

$rta_table_ins['perm']="INSERT INTO `".$rtv_dbprefix."permission` (`class`, `property`, `value`, `desc`) VALUES
('raid', 'raid_create', '3', 'Who can create raids'),
('admin', 'rank_alter', '2', 'Who can alter the <em>names</em> of ranks'),
('signup', 'wb_publish', '2', 'Publishing the whiteboard list'),
('signup', 'wb_erase', '2', 'Clearing the whiteboard list'),
('admin', 'permission_alter', '1', 'Who can alter the permissions (this screen)'),
('admin', 'admin_view', '3', 'Who can view the administration menu'),
('admin', 'update_news', '3', 'Updating the newsbox'),
('admin', 'view_log', '3', 'Viewing the log'),
('raid', 'raid_alter', '3', 'Altering the raid info (not the lists)'),
('raid', 'view_officernote', '3', 'Viewing the officer note in raid info and for players (in signup lists)'),
('raid', 'sign_raidlist', '0', 'Subscribe directly to the raid list'),
('raid', 'list_delete', '1', 'Deleting players from signups'),
('raid', 'list_raidlist', '2', 'Moving players to the raid list'),
('raid', 'list_wb', '3', 'Moving players to the whiteboard'),
('raid', 'list_available', '3', 'Moving players to ''Available'' status'),
('raid', 'list_reserve', '3', 'Moving players to ''Reserve'' status'),
('raid', 'list_withdraw', '3', 'Moving players to withdraw status'),
('raid', 'list_remove', '1', 'Moving players to ''remove'' status'),
('raid', 'list_move', '3', 'Moving players permission'),
('raid', 'edit_publicnote', '2', 'Editing the note of players'),
('raid', 'edit_officernote', '3', 'Editing the officer''s note'),
('raid', 'change_alt', '3', 'Changing player''s alt'),
('raid', 'change_role', '3', 'Changing the role of the character'),
('admin', 'show_grank', '5', 'shows guild rank on the guild list'),
('admin', 'show_rtrank', '3', 'Shows RT rank on the guild list'),
('admin', 'show_stats', '-3', 'Shows stats on the player page (and the guild list if not overriden by self)'),
('admin', 'show_email', '1', 'Shows e-mail addresses on the guild list'),
('admin', 'grank_alter', '1', 'Promotes/Demotes players with guild rank'),
('admin', 'rtrank_alter', '1', 'Promote/Demotes player''s with RT permissions'),
('admin', 'player_delete', '1', 'Deletes players'),
('raid', 'show_raidlist', '11', 'Reveals the Raid list'),
('raid', 'show_available', '11', 'Reveals the available list'),
('raid', 'show_reserve', '11', 'Reveals the reserve list'),
('raid', 'show_withdraw', '11', 'Reveals the withdraw list'),
('raid', 'show_remove', '3', 'Reveals the removed list'),
('raid', 'show_whiteboard', '3', 'Reveals the whiteboard'),
('raid', 'subscription_alter', '3', 'Allow altercations with players'' subscriptions'),
('raid', 'show_tables', '11', 'Reveals the signup tables'),
('signup', 'guildrank_start', '5', 'New accounts: starting guild rank'),
('signup', 'rtrank_start', '5', 'New accounts: starting RT rank'),
('player', 'player_alter', '-1', 'Who can modify a player''s character and account info'),
('player', 'character_add', '-2', 'Add a character to an account'),
('player', 'character_name', '-1', 'Change a character''s name'),
('player', 'character_role', '-3', 'Change default role for a character'),
('player', 'character_level', '-2', 'Allows level to be altered'),
('player', 'character_main', '1', 'Allows change of main character'),
('player', 'character_delete', '-2', 'Deletes characters'),
('raid', 'signup_override', '3', 'Can override the freeze cutoff'),
('signup', 'view_playernote', '5', 'Displays the (public) player note'),
('signup', 'list_addchar', '3', 'Allows a character to be added to list'),
('signup', 'sign_alt', '3', 'Allows signup with alts'),
('admin', 'log_clear', '1', 'Allows clearing of the log')";

$rta_table['sign']="CREATE TABLE `".$rtv_dbprefix."sign` (
  `id` int(10) unsigned NOT NULL auto_increment COMMENT 'entry id',
  `charid` smallint(5) unsigned NOT NULL COMMENT 'id to account',
  `char` tinyint(4) NOT NULL COMMENT 'id to character name',
  `raidid` smallint(5) unsigned NOT NULL COMMENT 'id to raid',
  `role` varchar(30) NOT NULL COMMENT 'role played in this raid',
  `status` tinyint(4) NOT NULL COMMENT 'status with this raid',
  `note` varchar(200) default NULL COMMENT 'any notes here',
  `offnote` varchar(200) default NULL COMMENT 'officers note on signup',
  `signup` datetime NOT NULL COMMENT 'date/time signed up',
  `modified` datetime NOT NULL COMMENT 'date/time last modified',
  PRIMARY KEY  (`id`),
  KEY `charid` (`charid`,`raidid`),
  KEY `char` (`char`)
)";
//---- put values in tables
foreach ($rta_table as $v)
	rtd_query($v);
foreach ($rta_table_ins as $v)
	rtd_query($v);

$rta_form=input('server[domain]','hidden',$rtv_sdomain);
$rta_form.=input('server[path]','hidden',$rtv_spath);
$_page['main'].="<p>Database tables created</p>\n";
$rta_form.=button('button','Continue');
$rta_form.=input('step','hidden','3');
$_page['main'].=form(div($rta_form),'.','post');
?>
