-- phpMyAdmin SQL Dump
-- version 2.10.3
-- http://www.phpmyadmin.net
-- 
-- Host: localhost
-- Generation Time: Jul 17, 2008 at 01:43 AM
-- Server version: 5.0.45
-- PHP Version: 5.2.3

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

-- 
-- Database: `raid`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `raid_account`
-- 

CREATE TABLE `raid_account` (
  `id` smallint(1) unsigned NOT NULL auto_increment COMMENT 'account id',
  `email` varchar(40) collate latin1_general_ci NOT NULL COMMENT 'email address',
  `guildrank` varchar(25) collate latin1_general_ci NOT NULL default 'member' COMMENT 'rank in guild',
  `rtrank` varchar(25) collate latin1_general_ci NOT NULL default 'member' COMMENT 'rank in rtracker',
  `main` varchar(30) collate latin1_general_ci NOT NULL default 'main character',
  `datef` varchar(10) collate latin1_general_ci NOT NULL default 'l Y-m-d' COMMENT 'date format',
  `timef` varchar(10) collate latin1_general_ci NOT NULL default 'H:i' COMMENT 'time format',
  `settings` varchar(20) collate latin1_general_ci NOT NULL default 'h' COMMENT 'Settings',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `main` (`main`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=33 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `raid_char`
-- 

CREATE TABLE `raid_char` (
  `id` smallint(5) unsigned NOT NULL auto_increment COMMENT 'character id',
  `char` varchar(30) collate latin1_general_ci NOT NULL COMMENT 'character name',
  `account` smallint(6) NOT NULL COMMENT 'link to account',
  `level` smallint(6) default '70' COMMENT 'character level',
  `class` enum('Dk','Dr','Hu','Ma','Pa','Pr','Ro','Sh','Wl','Wr') collate latin1_general_ci NOT NULL COMMENT 'character class',
  `role` varchar(20) collate latin1_general_ci default NULL COMMENT 'primary role of character',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `char` (`char`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=64 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `raid_hist`
-- 

CREATE TABLE `raid_hist` (
  `id` int(10) unsigned NOT NULL auto_increment COMMENT 'transaction id',
  `category` varchar(20) collate latin1_general_ci NOT NULL COMMENT 'category of change',
  `ref` smallint(5) unsigned NOT NULL default '0' COMMENT 'reference to change',
  `date` datetime NOT NULL COMMENT 'date/time of this occurance',
  `person` smallint(5) unsigned NOT NULL COMMENT 'Who did change (id)',
  `reason` varchar(200) collate latin1_general_ci NOT NULL COMMENT 'what reason for the change',
  `perm` tinyint(3) unsigned NOT NULL COMMENT 'Permissions to see this',
  PRIMARY KEY  (`id`),
  KEY `category` (`category`,`person`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=16 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `raid_list`
-- 

CREATE TABLE `raid_list` (
  `id` smallint(5) unsigned NOT NULL auto_increment COMMENT 'id of raid',
  `date` datetime NOT NULL COMMENT 'date and time of raid',
  `endtime` datetime NOT NULL COMMENT 'ending time',
  `invite` tinyint(3) unsigned default '15' COMMENT 'invite time starts x minutes early',
  `cutoff` tinyint(3) unsigned default '2' COMMENT 'cutoff to signup in hours',
  `icon` varchar(5) collate latin1_general_ci default NULL COMMENT 'raid instance icon',
  `instance` varchar(35) collate latin1_general_ci NOT NULL COMMENT 'instance',
  `note` varchar(200) collate latin1_general_ci default NULL COMMENT 'any extra notes',
  `required` tinyint(3) unsigned NOT NULL default '10' COMMENT 'how many required',
  `roles` varchar(15) collate latin1_general_ci default NULL COMMENT 'different roles separated by /',
  `offnote` varchar(225) collate latin1_general_ci default NULL COMMENT 'officer''s note on raid',
  PRIMARY KEY  (`id`),
  KEY `date` (`date`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=49 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `raid_sign`
-- 

CREATE TABLE `raid_sign` (
  `id` int(10) unsigned NOT NULL auto_increment COMMENT 'entry id',
  `charid` smallint(5) unsigned default NULL COMMENT 'id to account',
  `char` tinyint(4) default NULL COMMENT 'id to character name',
  `raidid` smallint(5) unsigned NOT NULL COMMENT 'id to raid',
  `role` varchar(30) collate latin1_general_ci NOT NULL COMMENT 'role played in this raid',
  `status` tinyint(4) NOT NULL COMMENT 'status with this raid',
  `note` varchar(200) collate latin1_general_ci default NULL COMMENT 'any notes here',
  `offnote` varchar(200) collate latin1_general_ci default NULL COMMENT 'officer''s note on signup',
  `update` int(10) unsigned NOT NULL COMMENT 'ref to last update',
  PRIMARY KEY  (`id`),
  KEY `charid` (`charid`,`raidid`),
  KEY `char` (`char`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=153 ;
