<?php
function publish($t) {
	echo $t;
}
function bold($t) {return "<strong>$t</strong>";}
function ital($t) {return "<em>$t</em>";}
function tbl($data, $class="", $id="") {
	return group($data, 'table',$id,$class);
}
function addcell(&$row, $data, $type="td", $class="", $id="") {
	$row.=group($data,$type,$id, $class);
}

function addrow(&$tbl, $row, $class="", $id="") {
	$tbl.=group($row,'tr',$id,$class);
}
function url($url, $text, $query="", $id="", $class="", $title="") {
	if (is_array($query)) {
		$i=0;
		$t="";
		foreach ($query as $k=>$v) {
			if ($i++) $t.="&amp;";
			$t.="$k=$v";
		}
		$query=$t;
	}
	if ($query) $url.="?$query";
	return group($text,'a',$id,$class,"href=\"$url\"");
}
function br() {
	return "<br />\n";
}
function nl(){ return "\n";}
function group($t, $elem="div", $id="", $class="", $other="") {
	$tag="<$elem";
	if (!empty($id)) $tag.=" id=\"$id\"";
	if (!empty($class)) $tag.=" class=\"$class\"";
	if (!empty($other))  $tag.=" $other";
	return $tag.">$t</$elem>";
}
function div($text, $id='', $class='', $other='') {
return group($text, 'div',$id, $class, $other);
}
function span($text, $id='', $class='', $other='') {
return group($text, 'span',$id, $class, $other);
}
function form($body, $action="#", $method="post", $id="", $class="", $other="") {
	return group ($body, "form", $id, $class, "method=\"$method\" action=\"$action\" $other");
}
function input($name, $type="text", $value="", $other="") {
	return "<input type=\"$type\" name=\"$name\" value=\"$value\" $other />\n";
}
function sel($name, $array, $default="", $id="", $class="", $other=""){
	$t="<select name=\"$name\" id=\"$id\" class=\"class\" $other>\n";
	foreach ($array as $k=>$v) {
		$t.="  <option value=\"$k\"";
		if ($k==$default) $t.= " selected=\"selected\"";
		$t.=">$v</option>\n";
	}
	$t.="</select>\n";
	return $t;
}
function err($text, $id="") {
	return group("Error $text", 'div', $id, "error");
}
function HTMLstrip($t) {
	return preg_replace('/(<)(.+?)(>)/', '', $t);
}
function button($nam='submit', $value='Submit', $class='', $id='') {
	return "<input id=\"$id\" class=\"$class\" type=\"submit\" name=\"$nam\" value=\"$value\" />";
}
function textfield($rtv_name, $rtv_label='', $rtv_value='', $rtv_style='line',$rtv_dim='20', $rtv_other='') {
	//for field box here
	$rta_ret=group($rtv_label,'label','','heading',"for=\"$rtv_name\"").' ';
	if ($rtv_style=='line') $rta_ret.=input ($rtv_name,'text',$rtv_value,"size=\"$rtv_dim\" id=\"$rtv_name\" $rtv_other");
	else if ($rtv_style=='box') $rta_ret.=group($rtv_value,'textarea','$rtv_name','',"name=\"$rtv_name\" rows=\"$rtv_dim[y]\" cols=\"$rtv_dim[x]\" id=\"$rtv_name\" ".$rtv_other);
	else rtf_error (101,"textfield / $rtv_style");
	$rta_ret.=br();
	return $rta_ret;
}
function passfield($rtv_name, $rtv_label='', $rtv_value='', $rtv_dim='20', $rtv_other='') {
	//for field box here
	$rta_ret=group($rtv_label,'label','','heading',"for=\"$rtv_name\"").' ';
	$rta_ret.=input ($rtv_name,'password',$rtv_value,"size=\"$rtv_dim\" id=\"$rtv_name\" $rtv_other");
	//else if ($rtv_style=='box') $rta_ret.=group($rtv_value,'textarea','$rtv_name','',"name=\"$rtv_name\" rows=\"$rtv_dim[y]\" cols=\"$rtv_dim[x]\" id=\"$rtv_name\" ".$rtv_other);
	//else rtf_error (101,"textfield / $rtv_style");
	$rta_ret.=br();
	return $rta_ret;
}
?>