<?php
/******************************************************
 * rti-createchar.php
 ******************************************************
 * Version 2.0 compatible for creating characters
 ******************************************************/
/******************************************************
 * rtf_charform
 ******************************************************
 * Creates a form for the character.
 * DOES NOT include <form> tags... that's up to the
 * caller
 * Options: $rtv_info (null).  If given, array of character
 * info if there is an error in the form
 ******************************************************/
function rtf_charform ($rtv_info=null) {
	$rta_return='';  //holds the form
	if (!$rtv_info['level']) $rtv_info['level']=70;
	$rta_return.=textfield('char[char]','Character:',$rtv_info['char']);
	$rta_return.=textfield('char[level]','Level:',$rtv_info['level'],'line','1');
	$rta_return.=rtf_classsel('char[class]',$rtv_info['class']).br();
	$rta_return.=rtff_role('char[role]',$rtv_info['role'],1).br();
	return $rta_return;
}

/******************************************************
 * rtf_emailform
 ******************************************************
 * Creates an new form with e-mail addresses (for new players)
 * Or, if e-mail is given in info, creates a form to
 * confirm e-mail address.
 * Options: $rtv_require.  If given, will give form only
 *  with confirm e-mail.
 * $rtv_info (null).  Required for $rtv_require.
 *  If given, array of character info if there is an error in the form
 ******************************************************/
function rtf_emailform ($rtv_info=null, $rtv_require=null) {
	if ($rtv_require && !$rtv_info) rtf_error(106,'rtv_info');
	if ($rtv_info)
		foreach ($rtv_info as $k=>$v)
			$rta_return.=input("character[$k]",'hidden',$v)."\n";
	if ($rtv_require)
		$rta_return.=span("Confirm e-mail:",'','heading spaceleft').' '.input('acct[confirm]','password','').br();
	else {
		$rta_return.=textfield('acct[email]','e-mail address:',$rtv_info['email']);
		$rta_return.=rtf_charform($rtv_info);
	}
	$rta_return.=span('&nbsp;','','spaceleft').span(button('submit'),'','spaceright');
//	$rta_return=form($rta_return,".",'post', 'trueform');
	return $rta_return;
}
/******************************************************
 * rtf_validate
 ******************************************************
 * Validates if a certain property exists  0/no 1/yes
 * Input:
 *   $rta_type : name of property.
 *              email / charname
 *   $rta_var  : data to check
 *   $rta_except: account id to check against
 *      default-0 (none).  If exists and matches this
 *      account, returns -1
 ******************************************************/
function rtf_validate($rta_type, $rta_var, $rta_except=0) {
	switch ($rta_type) {
		case 'email':
			$rta_match=rtd_select(rts_db_acct,'*',"email='$rta_var'");
			if ($rta_match)
				$rta_match=(($rta_match['id']==$rta_except)?-1:1);
			break;
		case 'charname':
			$rta_match=rtf_playermatrix('char',$rta_var);
			if ($rta_match)
				$rta_match=(($rta_match[0]['acctid']==$rta_except)?-1:1);
			break;
		default:
			rtf_error(104,$rta_type);
	}
	return $rta_match;
}
function rtf_newaccount() {
	$rta_form=input ('tos','hidden',rts_tosv);
	$rta_form.=input ('status','hidden','create2');
	$rta_form.=rtf_emailform();
	$rta_form=form($rta_form,".",'post', 'trueform');
	$rta_ret="<h1>Create account</h1>\n<p>Please enter your e-mail address and main character information.  Your e-mail address is the account name.</p>\n".$rta_form;
	$rta_ret.="<h1>About accounts</h1><p>An account identifies a player in ".rts_guild
.<<<EOD
.  Just like each player has 1 or more characters in the guild, each account holds information personalized to the character, such as signing up for raids, storing all of your characters, date and time settings, and other settings depending on the officers and admin.  Please only create one account and use it to sign up for our raids if you are in the guild.  Administrators reserves the right to delete accounts if it is a duplicate or not in our guild.</p>
<p>All accounts need an identifier, in this case, one e-mail address.  Your e-mail address is used only to log in, and e-mail addresses are never given or sold to any third party.  Once you log in, you will be solely associated by your main character.  In most cases, your main character is the character you created the account.  You may need to talk to an admin if you change main characters.</p>
<p>RaidTracker uses a cookie system, but only while you are logged in, which is after the account is created.  RT uses this cookie to personalize your view, such as showing which raids you have signed up on the calendar, and to sign you up.  Without this cookie, it is impossible to manage subscriptions without constantly asking for your e-mail address.  If you are paranoid, use session cookies, and always log out after use.<br />
<strong>IE 7 users:</strong> due to the privacy settings on IE7, this browser may not keep your cookie, and thus shows you as logged out despite entering your e-mail address.  The log-in screen will tell you how you can tell IE to accept your cookies.</p>
<p>RaidTracker is constantly improving, so new features may be implemented at any time.  Abusing RaidTracker will cause you to be banned.</p>
EOD;
	return $rta_ret;
}
?>