<?php
/************************************************
 * rt-char.php
 *-----------------------------------------------
 * New character list sheet  now 2.0 compatible
 ***********************************************/
//----------------- table process
function rtf_tabledisp($row, $acct,$main) {
	$t="<tr><td style=\"text-align: right\">";
	if ($row['char']==$main) $t.= " * ";
	if (rtf_p('player_alter', $acct))
		$t.= "<input type=\"radio\" name=\"char\" value=\"$row[char]\" />";
	$t.="</td><td>$row[char]</td>"
	."<td style=\"text-align: center;\">".rtf_classicon($row['class'])."</td><td>";
	$t.=rtf_role($row[role]);
	$t.="</td><td>$row[level]</td></tr>\n";
return $t;
}

// ---------------- Set up variables
if (isset($rtv_charid)) {
	$rta_acct=$rtv_charid or rtf_error(110,"viewing character files");
	$rta_main=rtd_selcol(rts_db_acct,'main',"id=$rtv_charid");
} else {
	$rta_acct=rtc_acct();
	$rta_main=rtc_name();
	$rt_menu='char';
}
$rta_list=rtd_select(rts_db_char,'*',"account=".$rta_acct,'ORDER BY `char`');
//-------------- Submit table
if ($rtv_button=="Create Alt") {
	$rta_create="alt";
	include 'rt-character.php';
	return;
} else if ($rtv_button=="Change") {
	if ($rtv_email && $rtv_datef && $rtv_timef) {
		$arr=array('datef'=>$rtv_datef,'timef'=>$rtv_timef,'email'=>$rtv_email);
		rtd_update(rts_db_acct,$arr, "id=$rta_acct");
		$_page['message']="Account settings changed";
	} else {
		$_page['message']="All fields in account settings are required.";
	}
	$rta_check="$rtv_view";
	if ($rta_check!=$rtv_settings[0]) {
		$rtv_settings[0]=$rtv_view;
		rtd_update (rts_db_acct,array('settings'=>$rtv_settings),"id=$rta_acct");
	}
} else if  ($rtv_create) {
	echo "<h1>Creating character</h1>\n";
	if (!$rtv_class || !$rtv_role) {
		$_page['message']="$rtv_char was not added for some reason";
		return;
	} else {
		$arr['char']=$rtv_char;
		$arr['level']=$rtv_level;
		$arr['account']=$rtv_charid;
		$arr['class']=$rtv_class;
		$arr['role']=$rtv_role;
		$rta_temp=rtd_insrec(rts_db_char,$arr, array('account','char'),'id');
		$rta_temp=rtf_log('character',"Created [pchar]".$rta_temp."[/pchar]",11,$rta_temp);
		$_page['message']="$rtv_char added.";
	}
} else if ($rtv_button) {
	echo "<h1>Submitting changes</h1>\n";
	if ($rtv_button=="Submit") {
		if ($rtv_manage=='main') {  //---------------- main character
			if (!$rtv_char) {
				echo "<p>Error: No main character set</p>\n";
			} else {
				$rta_temp=rtd_update(rts_db_acct,array('main'=>"$rtv_char"),"id='$rtv_charid'");
				if ($rta_temp) {echo "<p>Main change successful</p>\n";
					if ($rtv_charid==rtc_id()) {
						echo "<p>You need to relog in to see the changes.  <a href=\"". rts_syspath ."/login\">Continue here</a></p>\n";
						return;
					}
				}
			}
		} else if ($rtv_manage=='details'){ //-------------- details
			$sql='';
			if ($rtv_charname) $sql['char']="$rtv_charname";
			if ($rtv_level) $sql['level']="$rtv_level";
			if ($rtv_role) $sql['role']="$rtv_role";
			if (!$sql) echo "<p>ERROR: Required name, level or role was missing.</p>\n";
			else {
//				var_dump($_POST) ;
//				echo br()."rta_main: $rta_main";
//				exit;
				$rta_temp=rtd_update(rts_db_char,$sql,"`char`='$rtv_char'");
				echo "<p>Character info modified successfully</p>";
				if ($rtv_char==$rta_main && $rtv_charname && $rtv_char!=$rtv_charname) { //check for main name
					$sql=mysql_query("UPDATE ".rts_db_acct . "SET `main`='$rtv_charname' WHERE id='$rtv_charid'");
					if ($rtv_charid==rtc_id()) {
						echo "<p>You need to relog in to see the changes.  <a href=\"".rts_syspath ."/login\">Continue here</a></p>\n";
						return;
					}
				}
			}
		} else if ($rtv_manage=='delete'){
			$_page['message']="Attempting to delete $rtv_char.  ";
			$rta_playerlist=rtf_playermatrix('char',$rtv_char);
			$rta_charid=$rta_playerlist[0]['charid'];
			$rta_player=$rta_playerlist[0]['playerid'];
			if ($rtv_char==$rta_main) {
				$_page['message'].="Failed because $rtv_char is a main character.  Please make another character main before deleting";
//				echo "<p>Error: You cannot delete a main character. Please make another character main before deleting.</p>\n";
			} else {
				$sql=rtd_query("DELETE FROM ".rts_db_char ." WHERE `char`='$rtv_char'");
				$sql2=rtd_query("DELETE FROM ".rts_db_sign ." WHERE `char`='$rta_charid'");
				if (!sql) {
					$_page['message'].='Failed.';
//					rtf_error(4,"Character not deleted");
				} else {
					rtf_log("character $rta_player","Deleted $rtv_char");
					$_page['message'].="Success.";
				}
			}
		}
	}
}


$rta_main=rtd_selcol(rts_db_acct,'main',"id=$rta_acct");
$rta_list=rtd_select(rts_db_char,'*',"account=$rta_acct",'ORDER BY `char`');
$rta_info=rtd_select(rts_db_acct,'*',"id=$rta_acct");
//---------------------------------------- Character table
if (!rtc_acct()) rtf_error(110,"viewing character tables");
if (!count($rta_list)) {
	rtf_error(3,"No characters found.  Please logout and log in again, or contact an admin.");
	return;
}
echo "<form method=\"post\" action=\".\">\n";
echo "<input type=\"hidden\" name=\"charid\" value=\"$rta_acct\" />\n";

echo "<h1>Character list</h1>\n<table>\n<tr>";
echo "<th style=\"width: 5%;\">&nbsp;</th>";
echo "<th style=\"width: 20%;\">Character</th><th style=\"width: 5%;\">Class</th><th style=\"width: 10%;\">Main role</th><th style=\"width: 5%;\">Level</th></tr>\n";
if ($rta_list[0])
	foreach ($rta_list as $v)
		echo rtf_tabledisp($v, $rta_acct,$rta_main);
else
	echo rtf_tabledisp($rta_list, $rta_acct,$rta_main);
echo "</table>\n* denotes main character. ";
if (rtf_p('character_add', $rta_acct))
	echo '<input class="btn" type="submit" name="button" value="Create Alt" />';
echo br();
//------------------------------------ Character management
if (rtf_p('player_alter', $rta_acct)){
	echo "<h2>Character management</h2>\n";
	echo '<input type="radio" name="manage" value="main"'
	.(!rtf_p('character_main', $rta_acct)?' disabled':'').' />Establish as main character.'
	.(!rtf_p('character_main', $rta_acct)?' <em>Please ask an admin to change this</em>':'').br();
	if (rtf_p('character_role', $rta_acct)||rtf_p('character_name', $rta_acct)||rtf_p('character_level', $rta_acct)) {
		echo '<input type="radio" name="manage" value="details" />Update with: ';
		if (rtf_p('character_name', $rta_acct))
			echo '<span class="rt heading">Name:</span><input type="text" name="charname" /> ';
		if (rtf_p('character_level', $rta_acct))
			echo '<span class="rt heading">Level:</span><input type="text" size="1" name="level" /> ';
		if (rtf_p('character_role', $rta_acct)) echo rtff_role('role',0,0);
		echo br();
	}
	if (rtf_p('character_delete', $rta_acct)){
		echo '<input type="radio" name="manage" value="delete" />Delete character ';
		if (rtf_p('character_main'))
			echo "<em>Main characters cannot be deleted. Please promote another character to main character before deleting</em>".br();
		else
			echo "<em>You cannot delete your main character.  Please ask an admin for assistance</em>".br();
	}
	echo '<input class="btn" type="submit" name="button" value="Submit" />';
	echo "\n";
}
echo "</form>\n";
//----------------------------------------- Account settings
if (rtf_p('player_alter', $rta_acct)) {
echo "<h1>Account Settings</h1>\n"
. "<form method=\"post\" action=\".\">\n"
. "<input type=\"hidden\" name=\"charid\" value=\"$rta_acct\" />\n"
. "<span class=\"heading\">e-mail address:</span> <input type=\"text\" name=\"email\" value=\"{$rta_info['email']}\" />".br()
. "<span class=\"heading\">Date format*:</span> <input type=\"text\" name=\"datef\" value=\"{$rta_info['datef']}\" />".br()
. "<span class=\"heading\">Time format*:</span> <input type=\"text\" name=\"timef\" value=\"{$rta_info['timef']}\" />".br();
echo input('settings','hidden',$rta_info['settings'])."\n";
//echo $rta_info['settings'][0].br();
echo "<span class=\"heading\">Default view:</span> ".
 sel('view',array('c'=>'Calendar', 'h'=>'History'),$rta_info['settings'][0]).br();
echo "<input class=\"btn\" type=\"submit\" name=\"button\" value=\"Change\" />".br()
. "* Date and Time format uses the standard PHP <a href=\"http://se2.php.net/manual/en/function.date.php\">date</a> rules.".br();
echo "</form>\n";
}
//------------------------------------------- Show stats
if (rtf_p('show_stats',$rta_acct)) {
	for ($i=1; $i<=7; $i++) {
		$rta_count[$i]=count(rtd_select(rts_db_sign.' INNER JOIN '.rts_db_list .' ON ' .rts_db_sign .'.raidid = '.rts_db_list.'.id',
		'*',rts_db_sign.".charid=$rta_acct AND ".rts_db_sign.".status =$i
		AND (".rts_db_list.".date BETWEEN DATE_SUB( NOW() , INTERVAL 2 MONTH) AND NOW())",'',1));
	}

	$rta_raidsign=rtd_select(rts_db_sign.', '.rts_db_list,rts_db_sign.'.*, '.rts_db_list.'.date, '.rts_db_list.'.instance',rts_db_list.".id=".rts_db_sign.".raidid AND ".rts_db_sign.".charid =$rta_acct","ORDER BY ".rts_db_list.".date DESC LIMIT 30",1);
	echo "<h1>Player Stats</h1>\n<h2>60 day summary</h2>\n";
	for ($i=1; $i<6; $i++) {
		if ($i==2 || $i==3) $rta_raidcount=$rta_count[$i]+$rta_count[$i+4];
		else $rta_raidcount=$rta_count[$i];
		echo rtf_statusicon ($i,0,0)." - $rta_raidcount.  ";
	}
	echo br();
	echo "<h2>Raid history</h2>\n";
	if ($rta_raidsign) {
		echo "Last 30 raid history".br();
		echo "<table style=\"width: 100%\">\n<tr><th>Date</th><th>Instance</th>"
		."<th>Character</th><th>Action</th></tr>\n";
		foreach ($rta_raidsign as $v){
			echo "<tr><td>";
			echo url(rts_syspath."/signup?raidid=$v[raidid]",rtf_datetime(strtotime($v['date']),dt))."</td><td>$v[instance]</td><td>";
			echo rtf_char($v['char'],$v['role'])."</td><td>"
			.rtf_statusicon($v['status'],0,0).($v['note']?"-".rtf_offnote($v[note]):"")."</td></tr>\n";
		}
		echo "</table>\n";
	} else {
		echo "No raid history".br();
	}
}
?>